/** @file time_Gt.cpp
 *
 *  Timing tests for methods of elliptic polylogs. */

/*
 *  GiNaC Copyright (C) 1999-2026 Johannes Gutenberg University Mainz, Germany
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <iostream>
#include "timer.h"
#include "ginac.h"
#include "parser/parse_context.h"
#include "Gt.h"

using namespace GiNaC;
using namespace std;

// To speed up compilation, large expressions are encoded as strings and parsed at runtime (which is much faster then compiling them)
#define DEFINE_SYMBOL(s) const symbol s{#s};
#define DEFINE_SYMBOLS LIST_SYMBOLS(DEFINE_SYMBOL)
#define ADD_PARSER_SYMBOL(s) symbols[#s] = s;
#define MAKE_PARSER \
	symtab symbols; \
	LIST_SYMBOLS(ADD_PARSER_SYMBOL) \
	prototype_table table = GiNaC::get_default_reader(); \
	table.emplace(prototype{"Gt", 3}, [](const exvector& args) -> ex { return Gt(ex_to<lst>(args[0]), args[1], args[2]); }); \
	parser parse(symbols, false, table);

// from 1907.03787
static unsigned time_banana()
{
	const char* tests[18] = {
		"2197/25*(-(Gt({{0,0},{0,0},{1,-1/6}},5/6+5/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6}},5/6+5/6*mTau1,mTau1))-20818/15*(-(Gt({{0,0},{0,0},{1,-1/6}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6}},1/2*mTau1,mTau1))-6591/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/6,mTau1))+Gt({{0,0},{0,0},{1,1/3}},1/6,mTau1))-386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+1/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/3}},2/3+1/3*mTau1,mTau1))+386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+2/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/3}},2/3+2/3*mTau1,mTau1))+18621/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/3}},1/2*mTau1,mTau1))-386267/60*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/3}},2/3*mTau1,mTau1))+1330*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau1}},1/2,mTau1))-893/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau1}},1/2*mTau1,mTau1))+1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau1}},1/2,mTau1))-1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau1}},1/2+1/2*mTau1,mTau1))+8141/10*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau1}},1/2*mTau1,mTau1))+840*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau1}},2/3,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau1}},2/3,mTau1))+2016/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau1}},5/6,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau1}},5/6,mTau1))-462*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau1}},1/2+1/2*mTau1,mTau1))+576/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau1}},1/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau1}},1/6*mTau1,mTau1))+1557/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau1}},1/2*mTau1,mTau1))-560*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau1}},1/2,mTau1))+168/5*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau1}},1/2+1/2*mTau1,mTau1))-57739/24*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau1}},1/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau1}},1/6*mTau1,mTau1))+36031/120*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau1}},5/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau1}},5/6*mTau1,mTau1))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau1}},1/3,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau1}},1/3,mTau1))-1330*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau1}},1/2,mTau1))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau1}},2/3,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau1}},2/3,mTau1))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau1}},1/3+1/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau1}},1/3+1/3*mTau1,mTau1))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau1}},1/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau1}},1/3*mTau1,mTau1))+1127/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau1}},1/2,mTau1))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau1}},1/2+1/2*mTau1,mTau1))-1045553/60*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau1}},1/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau1}},1/3*mTau1,mTau1))+462814/45*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau1}},1/2*mTau1,mTau1))+22867/30*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau1}},1/2,mTau1))-6207/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau1}},2/3+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau1}},2/3+1/2*mTau1,mTau1))-72913/30*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau1}},1/2,mTau1))+4443/5*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau1}},1/2+1/2*mTau1,mTau1))-188113/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau1}},1/3,mTau1))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau1}},1/3,mTau1))+1582769/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau1}},2/3,mTau1))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau1}},2/3,mTau1))-4665/2*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau1}},5/6,mTau1))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau1}},5/6,mTau1))+630*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau1}},1/2+1/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau1}},1/2+1/6*mTau1,mTau1))+1052*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau1}},1/2+1/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau1}},1/2+1/3*mTau1,mTau1))-2734/5*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau1}},5/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau1}},5/6*mTau1,mTau1))-31277/30*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau1}},1/2,mTau1))-1764/5*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau1}},1/2+1/2*mTau1,mTau1))-9379/30*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau1}},1/2,mTau1))-1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau1}},2/3,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau1}},2/3,mTau1))+1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau1}},5/6,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau1}},5/6,mTau1))+6207/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau1}},1/2*mTau1,mTau1))+7343/5*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau1}},1/2,mTau1))-4281/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau1}},1/2*mTau1,mTau1))+2541/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau1}},2/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau1}},2/3*mTau1,mTau1))+665*(-(Gt({{0,0},{0,0},{1,-1/3-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,1/3+2/3*mTau1}},1/2,mTau1))+462/5*(-(Gt({{0,0},{0,0},{1,-1/2-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,1/2+2/3*mTau1}},1/2,mTau1))-386267/30*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau1}},1/3,mTau1))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau1}},1/3,mTau1))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau1}},2/3,mTau1))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau1}},2/3,mTau1))+1338/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau1}},1/2,mTau1))+288/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau1}},2/3,mTau1))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau1}},2/3,mTau1))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau1}},1/6+1/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau1}},1/6+1/6*mTau1,mTau1))+168/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau1}},2/3+5/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau1}},2/3+5/6*mTau1,mTau1))-64911/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau1}},1/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau1}},1/6*mTau1,mTau1))-4737/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau1}},5/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau1}},5/6*mTau1,mTau1))-1579/10*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau1}},1/2*mTau1,mTau1))-165/2*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau1}},2/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau1}},2/3*mTau1,mTau1))+893/5*(-(Gt({{0,0},{0,0},{1,-1/3-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/3+5/6*mTau1}},1/2*mTau1,mTau1))-126*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau1}},1/2+1/2*mTau1,mTau1))+168/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau1}},1/2+2/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau1}},1/2+2/3*mTau1,mTau1))+406/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau1}},1/2*mTau1,mTau1))-6666/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau1}},1/2,mTau1))-41*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau1}},1/2+1/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau1}},1/2+1/3*mTau1,mTau1))+221/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau1}},1/2+1/2*mTau1,mTau1))-253/15*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau1}},1/2*mTau1,mTau1))-37841/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau1}},1/3,mTau1))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau1}},1/3,mTau1))+321817/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau1}},1/2,mTau1))-136121/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau1}},2/3,mTau1))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau1}},2/3,mTau1))+12277/25*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau1}},5/6,mTau1))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau1}},5/6,mTau1))-208783/12*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau1}},1/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau1}},1/6*mTau1,mTau1))+1078601/180*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau1}},1/2*mTau1,mTau1))-846/5*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau1}},5/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau1}},5/6*mTau1,mTau1))-13319/8*(-(Gt({{0,0},{0,0},{1,-1/6*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,1/6*mTau1}},1/2,mTau1))+8037/40*(-(Gt({{0,0},{0,0},{1,-1/6*mTau1}},5/6+2/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/6*mTau1}},5/6+2/3*mTau1,mTau1))-462/5*(-(Gt({{0,0},{0,0},{1,-1/3*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,1/3*mTau1}},1/2,mTau1))-755827/600*(-(Gt({{0,0},{0,0},{1,-1/2*mTau1}},5/6,mTau1))+Gt({{0,0},{0,0},{1,1/2*mTau1}},5/6,mTau1))-22841/10*(-(Gt({{0,0},{0,0},{1,-1/2*mTau1}},2/3+1/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2*mTau1}},2/3+1/6*mTau1,mTau1))-1371547/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau1}},5/6+1/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2*mTau1}},5/6+1/3*mTau1,mTau1))+969431/60*(-(Gt({{0,0},{0,0},{1,-1/2*mTau1}},5/6+1/2*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2*mTau1}},5/6+1/2*mTau1,mTau1))+20261/120*(-(Gt({{0,0},{0,0},{1,-1/2*mTau1}},1/6+2/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2*mTau1}},1/6+2/3*mTau1,mTau1))+577/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau1}},1/3+5/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2*mTau1}},1/3+5/6*mTau1,mTau1))+1639/15*(-(Gt({{0,0},{0,0},{1,-1/2*mTau1}},2/3+5/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2*mTau1}},2/3+5/6*mTau1,mTau1))-1011209/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau1}},5/6+5/6*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2*mTau1}},5/6+5/6*mTau1,mTau1))-11644/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau1}},1/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,1/2*mTau1}},1/3*mTau1,mTau1))+231/5*(-(Gt({{0,0},{0,0},{1,-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,2/3*mTau1}},1/2,mTau1))-70291/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau1}},1/2,mTau1))+Gt({{0,0},{0,0},{1,5/6*mTau1}},1/2,mTau1))+8037/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau1}},5/6+2/3*mTau1,mTau1))+Gt({{0,0},{0,0},{1,5/6*mTau1}},5/6+2/3*mTau1,mTau1))",
		"2197/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},5/6+5/6*mTau1,mTau1))+Gt({{0,0},{2,1/6}},5/6+5/6*mTau1,mTau1))-10409/15*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},1/2*mTau1,mTau1))+Gt({{0,0},{2,1/6}},1/2*mTau1,mTau1))-6591/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/6,mTau1))+Gt({{0,0},{2,1/3}},1/6,mTau1))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+1/3*mTau1,mTau1))+Gt({{0,0},{2,1/3}},2/3+1/3*mTau1,mTau1))+386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+2/3*mTau1,mTau1))+Gt({{0,0},{2,1/3}},2/3+2/3*mTau1,mTau1))+18621/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/2*mTau1,mTau1))+Gt({{0,0},{2,1/3}},1/2*mTau1,mTau1))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3*mTau1,mTau1))+Gt({{0,0},{2,1/3}},2/3*mTau1,mTau1))+665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau1}},1/2,mTau1))+Gt({{0,0},{2,1/6+1/6*mTau1}},1/2,mTau1))-893/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,1/6+1/6*mTau1}},1/2*mTau1,mTau1))+1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau1}},1/2,mTau1))+Gt({{0,0},{2,2/3+1/6*mTau1}},1/2,mTau1))-1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{2,2/3+1/6*mTau1}},1/2+1/2*mTau1,mTau1))+8141/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,2/3+1/6*mTau1}},1/2*mTau1,mTau1))+420*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau1}},2/3,mTau1))+Gt({{0,0},{2,5/6+1/6*mTau1}},2/3,mTau1))+1008/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau1}},5/6,mTau1))+Gt({{0,0},{2,5/6+1/6*mTau1}},5/6,mTau1))-231*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{2,5/6+1/6*mTau1}},1/2+1/2*mTau1,mTau1))+288/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau1}},1/6*mTau1,mTau1))+Gt({{0,0},{2,5/6+1/6*mTau1}},1/6*mTau1,mTau1))+1557/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,5/6+1/6*mTau1}},1/2*mTau1,mTau1))-280*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau1}},1/2,mTau1))+Gt({{0,0},{2,1/6+1/3*mTau1}},1/2,mTau1))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{2,1/6+1/3*mTau1}},1/2+1/2*mTau1,mTau1))-57739/48*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau1}},1/6*mTau1,mTau1))+Gt({{0,0},{2,1/6+1/3*mTau1}},1/6*mTau1,mTau1))+36031/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau1}},5/6*mTau1,mTau1))+Gt({{0,0},{2,1/6+1/3*mTau1}},5/6*mTau1,mTau1))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau1}},1/3,mTau1))+Gt({{0,0},{2,2/3+1/3*mTau1}},1/3,mTau1))-665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau1}},1/2,mTau1))+Gt({{0,0},{2,2/3+1/3*mTau1}},1/2,mTau1))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau1}},2/3,mTau1))+Gt({{0,0},{2,2/3+1/3*mTau1}},2/3,mTau1))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau1}},1/3+1/3*mTau1,mTau1))+Gt({{0,0},{2,2/3+1/3*mTau1}},1/3+1/3*mTau1,mTau1))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau1}},1/3*mTau1,mTau1))+Gt({{0,0},{2,2/3+1/3*mTau1}},1/3*mTau1,mTau1))+1127/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau1}},1/2,mTau1))+Gt({{0,0},{2,5/6+1/3*mTau1}},1/2,mTau1))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{2,5/6+1/3*mTau1}},1/2+1/2*mTau1,mTau1))-1045553/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau1}},1/3*mTau1,mTau1))+Gt({{0,0},{2,5/6+1/3*mTau1}},1/3*mTau1,mTau1))+231407/45*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,5/6+1/3*mTau1}},1/2*mTau1,mTau1))+22867/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau1}},1/2,mTau1))+Gt({{0,0},{2,1/6+1/2*mTau1}},1/2,mTau1))-6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau1}},2/3+1/2*mTau1,mTau1))+Gt({{0,0},{2,1/6+1/2*mTau1}},2/3+1/2*mTau1,mTau1))-72913/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau1}},1/2,mTau1))+Gt({{0,0},{2,1/3+1/2*mTau1}},1/2,mTau1))+4443/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{2,1/3+1/2*mTau1}},1/2+1/2*mTau1,mTau1))-188113/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau1}},1/3,mTau1))+Gt({{0,0},{2,1/2+1/2*mTau1}},1/3,mTau1))+1582769/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau1}},2/3,mTau1))+Gt({{0,0},{2,1/2+1/2*mTau1}},2/3,mTau1))-4665/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau1}},5/6,mTau1))+Gt({{0,0},{2,1/2+1/2*mTau1}},5/6,mTau1))+315*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau1}},1/2+1/6*mTau1,mTau1))+Gt({{0,0},{2,1/2+1/2*mTau1}},1/2+1/6*mTau1,mTau1))+526*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau1}},1/2+1/3*mTau1,mTau1))+Gt({{0,0},{2,1/2+1/2*mTau1}},1/2+1/3*mTau1,mTau1))-1367/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau1}},5/6*mTau1,mTau1))+Gt({{0,0},{2,1/2+1/2*mTau1}},5/6*mTau1,mTau1))-31277/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau1}},1/2,mTau1))+Gt({{0,0},{2,2/3+1/2*mTau1}},1/2,mTau1))-882/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{2,2/3+1/2*mTau1}},1/2+1/2*mTau1,mTau1))-9379/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau1}},1/2,mTau1))+Gt({{0,0},{2,5/6+1/2*mTau1}},1/2,mTau1))-756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau1}},2/3,mTau1))+Gt({{0,0},{2,5/6+1/2*mTau1}},2/3,mTau1))+756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau1}},5/6,mTau1))+Gt({{0,0},{2,5/6+1/2*mTau1}},5/6,mTau1))+6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,5/6+1/2*mTau1}},1/2*mTau1,mTau1))+7343/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{2,1/6+2/3*mTau1}},1/2,mTau1))-4281/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,1/6+2/3*mTau1}},1/2*mTau1,mTau1))+2541/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau1}},2/3*mTau1,mTau1))+Gt({{0,0},{2,1/6+2/3*mTau1}},2/3*mTau1,mTau1))+665/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{2,1/3+2/3*mTau1}},1/2,mTau1))+231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{2,1/2+2/3*mTau1}},1/2,mTau1))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau1}},1/3,mTau1))+Gt({{0,0},{2,2/3+2/3*mTau1}},1/3,mTau1))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau1}},2/3,mTau1))+Gt({{0,0},{2,2/3+2/3*mTau1}},2/3,mTau1))+669/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{2,5/6+2/3*mTau1}},1/2,mTau1))+144/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau1}},2/3,mTau1))+Gt({{0,0},{2,5/6+2/3*mTau1}},2/3,mTau1))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau1}},1/6+1/6*mTau1,mTau1))+Gt({{0,0},{2,5/6+2/3*mTau1}},1/6+1/6*mTau1,mTau1))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau1}},2/3+5/6*mTau1,mTau1))+Gt({{0,0},{2,5/6+2/3*mTau1}},2/3+5/6*mTau1,mTau1))-64911/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau1}},1/6*mTau1,mTau1))+Gt({{0,0},{2,5/6+2/3*mTau1}},1/6*mTau1,mTau1))-4737/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau1}},5/6*mTau1,mTau1))+Gt({{0,0},{2,5/6+2/3*mTau1}},5/6*mTau1,mTau1))-1579/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,1/6+5/6*mTau1}},1/2*mTau1,mTau1))-165/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau1}},2/3*mTau1,mTau1))+Gt({{0,0},{2,1/6+5/6*mTau1}},2/3*mTau1,mTau1))+893/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,1/3+5/6*mTau1}},1/2*mTau1,mTau1))-63*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{2,1/2+5/6*mTau1}},1/2+1/2*mTau1,mTau1))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau1}},1/2+2/3*mTau1,mTau1))+Gt({{0,0},{2,1/2+5/6*mTau1}},1/2+2/3*mTau1,mTau1))+203/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,1/2+5/6*mTau1}},1/2*mTau1,mTau1))-3333/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau1}},1/2,mTau1))+Gt({{0,0},{2,2/3+5/6*mTau1}},1/2,mTau1))-41/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau1}},1/2+1/3*mTau1,mTau1))+Gt({{0,0},{2,2/3+5/6*mTau1}},1/2+1/3*mTau1,mTau1))+221/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{0,0},{2,2/3+5/6*mTau1}},1/2+1/2*mTau1,mTau1))-253/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,2/3+5/6*mTau1}},1/2*mTau1,mTau1))-37841/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau1}},1/3,mTau1))+Gt({{0,0},{2,5/6+5/6*mTau1}},1/3,mTau1))+321817/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau1}},1/2,mTau1))+Gt({{0,0},{2,5/6+5/6*mTau1}},1/2,mTau1))-136121/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau1}},2/3,mTau1))+Gt({{0,0},{2,5/6+5/6*mTau1}},2/3,mTau1))+12277/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau1}},5/6,mTau1))+Gt({{0,0},{2,5/6+5/6*mTau1}},5/6,mTau1))-208783/24*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau1}},1/6*mTau1,mTau1))+Gt({{0,0},{2,5/6+5/6*mTau1}},1/6*mTau1,mTau1))+1078601/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{0,0},{2,5/6+5/6*mTau1}},1/2*mTau1,mTau1))-423/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau1}},5/6*mTau1,mTau1))+Gt({{0,0},{2,5/6+5/6*mTau1}},5/6*mTau1,mTau1))-13319/16*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau1}},1/2,mTau1))+Gt({{0,0},{2,1/6*mTau1}},1/2,mTau1))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau1}},5/6+2/3*mTau1,mTau1))+Gt({{0,0},{2,1/6*mTau1}},5/6+2/3*mTau1,mTau1))-231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3*mTau1}},1/2,mTau1))+Gt({{0,0},{2,1/3*mTau1}},1/2,mTau1))-755827/1200*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau1}},5/6,mTau1))+Gt({{0,0},{2,1/2*mTau1}},5/6,mTau1))-22841/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau1}},2/3+1/6*mTau1,mTau1))+Gt({{0,0},{2,1/2*mTau1}},2/3+1/6*mTau1,mTau1))-1371547/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau1}},5/6+1/3*mTau1,mTau1))+Gt({{0,0},{2,1/2*mTau1}},5/6+1/3*mTau1,mTau1))+969431/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau1}},5/6+1/2*mTau1,mTau1))+Gt({{0,0},{2,1/2*mTau1}},5/6+1/2*mTau1,mTau1))+20261/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau1}},1/6+2/3*mTau1,mTau1))+Gt({{0,0},{2,1/2*mTau1}},1/6+2/3*mTau1,mTau1))+577/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau1}},1/3+5/6*mTau1,mTau1))+Gt({{0,0},{2,1/2*mTau1}},1/3+5/6*mTau1,mTau1))+1639/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau1}},2/3+5/6*mTau1,mTau1))+Gt({{0,0},{2,1/2*mTau1}},2/3+5/6*mTau1,mTau1))-1011209/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau1}},5/6+5/6*mTau1,mTau1))+Gt({{0,0},{2,1/2*mTau1}},5/6+5/6*mTau1,mTau1))-5822/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau1}},1/3*mTau1,mTau1))+Gt({{0,0},{2,1/2*mTau1}},1/3*mTau1,mTau1))+231/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3*mTau1}},1/2,mTau1))+Gt({{0,0},{2,2/3*mTau1}},1/2,mTau1))-70291/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau1}},1/2,mTau1))+Gt({{0,0},{2,5/6*mTau1}},1/2,mTau1))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau1}},5/6+2/3*mTau1,mTau1))+Gt({{0,0},{2,5/6*mTau1}},5/6+2/3*mTau1,mTau1))",
		"2197/300*(pow(Pi,-2))*(-(Gt({{3,-1/6}},5/6+5/6*mTau1,mTau1))+Gt({{3,1/6}},5/6+5/6*mTau1,mTau1))-10409/90*(pow(Pi,-2))*(-(Gt({{3,-1/6}},1/2*mTau1,mTau1))+Gt({{3,1/6}},1/2*mTau1,mTau1))-2197/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/6,mTau1))+Gt({{3,1/3}},1/6,mTau1))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+1/3*mTau1,mTau1))+Gt({{3,1/3}},2/3+1/3*mTau1,mTau1))+386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+2/3*mTau1,mTau1))+Gt({{3,1/3}},2/3+2/3*mTau1,mTau1))+6207/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/2*mTau1,mTau1))+Gt({{3,1/3}},1/2*mTau1,mTau1))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3*mTau1,mTau1))+Gt({{3,1/3}},2/3*mTau1,mTau1))+665/6*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau1}},1/2,mTau1))+Gt({{3,1/6+1/6*mTau1}},1/2,mTau1))-893/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau1}},1/2*mTau1,mTau1))+Gt({{3,1/6+1/6*mTau1}},1/2*mTau1,mTau1))+1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau1}},1/2,mTau1))+Gt({{3,2/3+1/6*mTau1}},1/2,mTau1))-1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{3,2/3+1/6*mTau1}},1/2+1/2*mTau1,mTau1))+8141/120*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau1}},1/2*mTau1,mTau1))+Gt({{3,2/3+1/6*mTau1}},1/2*mTau1,mTau1))+70*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau1}},2/3,mTau1))+Gt({{3,5/6+1/6*mTau1}},2/3,mTau1))+168/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau1}},5/6,mTau1))+Gt({{3,5/6+1/6*mTau1}},5/6,mTau1))-77/2*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{3,5/6+1/6*mTau1}},1/2+1/2*mTau1,mTau1))+48/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau1}},1/6*mTau1,mTau1))+Gt({{3,5/6+1/6*mTau1}},1/6*mTau1,mTau1))+519/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau1}},1/2*mTau1,mTau1))+Gt({{3,5/6+1/6*mTau1}},1/2*mTau1,mTau1))-140/3*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau1}},1/2,mTau1))+Gt({{3,1/6+1/3*mTau1}},1/2,mTau1))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{3,1/6+1/3*mTau1}},1/2+1/2*mTau1,mTau1))-57739/288*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau1}},1/6*mTau1,mTau1))+Gt({{3,1/6+1/3*mTau1}},1/6*mTau1,mTau1))+36031/1440*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau1}},5/6*mTau1,mTau1))+Gt({{3,1/6+1/3*mTau1}},5/6*mTau1,mTau1))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau1}},1/3,mTau1))+Gt({{3,2/3+1/3*mTau1}},1/3,mTau1))-665/6*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau1}},1/2,mTau1))+Gt({{3,2/3+1/3*mTau1}},1/2,mTau1))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau1}},2/3,mTau1))+Gt({{3,2/3+1/3*mTau1}},2/3,mTau1))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau1}},1/3+1/3*mTau1,mTau1))+Gt({{3,2/3+1/3*mTau1}},1/3+1/3*mTau1,mTau1))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau1}},1/3*mTau1,mTau1))+Gt({{3,2/3+1/3*mTau1}},1/3*mTau1,mTau1))+1127/60*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau1}},1/2,mTau1))+Gt({{3,5/6+1/3*mTau1}},1/2,mTau1))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{3,5/6+1/3*mTau1}},1/2+1/2*mTau1,mTau1))-1045553/720*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau1}},1/3*mTau1,mTau1))+Gt({{3,5/6+1/3*mTau1}},1/3*mTau1,mTau1))+231407/270*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau1}},1/2*mTau1,mTau1))+Gt({{3,5/6+1/3*mTau1}},1/2*mTau1,mTau1))+22867/360*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau1}},1/2,mTau1))+Gt({{3,1/6+1/2*mTau1}},1/2,mTau1))-2069/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau1}},2/3+1/2*mTau1,mTau1))+Gt({{3,1/6+1/2*mTau1}},2/3+1/2*mTau1,mTau1))-72913/360*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau1}},1/2,mTau1))+Gt({{3,1/3+1/2*mTau1}},1/2,mTau1))+1481/20*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{3,1/3+1/2*mTau1}},1/2+1/2*mTau1,mTau1))-188113/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau1}},1/3,mTau1))+Gt({{3,1/2+1/2*mTau1}},1/3,mTau1))+1582769/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau1}},2/3,mTau1))+Gt({{3,1/2+1/2*mTau1}},2/3,mTau1))-1555/8*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau1}},5/6,mTau1))+Gt({{3,1/2+1/2*mTau1}},5/6,mTau1))+105/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau1}},1/2+1/6*mTau1,mTau1))+Gt({{3,1/2+1/2*mTau1}},1/2+1/6*mTau1,mTau1))+263/3*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau1}},1/2+1/3*mTau1,mTau1))+Gt({{3,1/2+1/2*mTau1}},1/2+1/3*mTau1,mTau1))-1367/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau1}},5/6*mTau1,mTau1))+Gt({{3,1/2+1/2*mTau1}},5/6*mTau1,mTau1))-31277/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau1}},1/2,mTau1))+Gt({{3,2/3+1/2*mTau1}},1/2,mTau1))-147/5*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{3,2/3+1/2*mTau1}},1/2+1/2*mTau1,mTau1))-9379/360*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau1}},1/2,mTau1))+Gt({{3,5/6+1/2*mTau1}},1/2,mTau1))-126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau1}},2/3,mTau1))+Gt({{3,5/6+1/2*mTau1}},2/3,mTau1))+126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau1}},5/6,mTau1))+Gt({{3,5/6+1/2*mTau1}},5/6,mTau1))+2069/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau1}},1/2*mTau1,mTau1))+Gt({{3,5/6+1/2*mTau1}},1/2*mTau1,mTau1))+7343/60*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau1}},1/2,mTau1))+Gt({{3,1/6+2/3*mTau1}},1/2,mTau1))-1427/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau1}},1/2*mTau1,mTau1))+Gt({{3,1/6+2/3*mTau1}},1/2*mTau1,mTau1))+847/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau1}},2/3*mTau1,mTau1))+Gt({{3,1/6+2/3*mTau1}},2/3*mTau1,mTau1))+665/12*(pow(Pi,-2))*(-(Gt({{3,-1/3-2/3*mTau1}},1/2,mTau1))+Gt({{3,1/3+2/3*mTau1}},1/2,mTau1))+77/10*(pow(Pi,-2))*(-(Gt({{3,-1/2-2/3*mTau1}},1/2,mTau1))+Gt({{3,1/2+2/3*mTau1}},1/2,mTau1))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau1}},1/3,mTau1))+Gt({{3,2/3+2/3*mTau1}},1/3,mTau1))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau1}},2/3,mTau1))+Gt({{3,2/3+2/3*mTau1}},2/3,mTau1))+223/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau1}},1/2,mTau1))+Gt({{3,5/6+2/3*mTau1}},1/2,mTau1))+24/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau1}},2/3,mTau1))+Gt({{3,5/6+2/3*mTau1}},2/3,mTau1))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau1}},1/6+1/6*mTau1,mTau1))+Gt({{3,5/6+2/3*mTau1}},1/6+1/6*mTau1,mTau1))+14/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau1}},2/3+5/6*mTau1,mTau1))+Gt({{3,5/6+2/3*mTau1}},2/3+5/6*mTau1,mTau1))-21637/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau1}},1/6*mTau1,mTau1))+Gt({{3,5/6+2/3*mTau1}},1/6*mTau1,mTau1))-1579/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau1}},5/6*mTau1,mTau1))+Gt({{3,5/6+2/3*mTau1}},5/6*mTau1,mTau1))-1579/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{3,1/6+5/6*mTau1}},1/2*mTau1,mTau1))-55/8*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau1}},2/3*mTau1,mTau1))+Gt({{3,1/6+5/6*mTau1}},2/3*mTau1,mTau1))+893/60*(pow(Pi,-2))*(-(Gt({{3,-1/3-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{3,1/3+5/6*mTau1}},1/2*mTau1,mTau1))-21/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{3,1/2+5/6*mTau1}},1/2+1/2*mTau1,mTau1))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau1}},1/2+2/3*mTau1,mTau1))+Gt({{3,1/2+5/6*mTau1}},1/2+2/3*mTau1,mTau1))+203/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{3,1/2+5/6*mTau1}},1/2*mTau1,mTau1))-1111/10*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau1}},1/2,mTau1))+Gt({{3,2/3+5/6*mTau1}},1/2,mTau1))-41/12*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau1}},1/2+1/3*mTau1,mTau1))+Gt({{3,2/3+5/6*mTau1}},1/2+1/3*mTau1,mTau1))+221/60*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau1}},1/2+1/2*mTau1,mTau1))+Gt({{3,2/3+5/6*mTau1}},1/2+1/2*mTau1,mTau1))-253/180*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{3,2/3+5/6*mTau1}},1/2*mTau1,mTau1))-37841/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau1}},1/3,mTau1))+Gt({{3,5/6+5/6*mTau1}},1/3,mTau1))+321817/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau1}},1/2,mTau1))+Gt({{3,5/6+5/6*mTau1}},1/2,mTau1))-136121/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau1}},2/3,mTau1))+Gt({{3,5/6+5/6*mTau1}},2/3,mTau1))+12277/300*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau1}},5/6,mTau1))+Gt({{3,5/6+5/6*mTau1}},5/6,mTau1))-208783/144*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau1}},1/6*mTau1,mTau1))+Gt({{3,5/6+5/6*mTau1}},1/6*mTau1,mTau1))+1078601/2160*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau1}},1/2*mTau1,mTau1))+Gt({{3,5/6+5/6*mTau1}},1/2*mTau1,mTau1))-141/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau1}},5/6*mTau1,mTau1))+Gt({{3,5/6+5/6*mTau1}},5/6*mTau1,mTau1))-13319/96*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau1}},1/2,mTau1))+Gt({{3,1/6*mTau1}},1/2,mTau1))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau1}},5/6+2/3*mTau1,mTau1))+Gt({{3,1/6*mTau1}},5/6+2/3*mTau1,mTau1))-77/10*(pow(Pi,-2))*(-(Gt({{3,-1/3*mTau1}},1/2,mTau1))+Gt({{3,1/3*mTau1}},1/2,mTau1))-755827/7200*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau1}},5/6,mTau1))+Gt({{3,1/2*mTau1}},5/6,mTau1))-22841/120*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau1}},2/3+1/6*mTau1,mTau1))+Gt({{3,1/2*mTau1}},2/3+1/6*mTau1,mTau1))-1371547/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau1}},5/6+1/3*mTau1,mTau1))+Gt({{3,1/2*mTau1}},5/6+1/3*mTau1,mTau1))+969431/720*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau1}},5/6+1/2*mTau1,mTau1))+Gt({{3,1/2*mTau1}},5/6+1/2*mTau1,mTau1))+20261/1440*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau1}},1/6+2/3*mTau1,mTau1))+Gt({{3,1/2*mTau1}},1/6+2/3*mTau1,mTau1))+577/60*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau1}},1/3+5/6*mTau1,mTau1))+Gt({{3,1/2*mTau1}},1/3+5/6*mTau1,mTau1))+1639/180*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau1}},2/3+5/6*mTau1,mTau1))+Gt({{3,1/2*mTau1}},2/3+5/6*mTau1,mTau1))-1011209/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau1}},5/6+5/6*mTau1,mTau1))+Gt({{3,1/2*mTau1}},5/6+5/6*mTau1,mTau1))-2911/15*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau1}},1/3*mTau1,mTau1))+Gt({{3,1/2*mTau1}},1/3*mTau1,mTau1))+77/20*(pow(Pi,-2))*(-(Gt({{3,-2/3*mTau1}},1/2,mTau1))+Gt({{3,2/3*mTau1}},1/2,mTau1))-70291/480*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau1}},1/2,mTau1))+Gt({{3,5/6*mTau1}},1/2,mTau1))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau1}},5/6+2/3*mTau1,mTau1))+Gt({{3,5/6*mTau1}},5/6+2/3*mTau1,mTau1))",
		"2197/25*(-(Gt({{0,0},{0,0},{1,-1/6}},5/6+5/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6}},5/6+5/6*mTau2,mTau2))-20818/15*(-(Gt({{0,0},{0,0},{1,-1/6}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6}},1/2*mTau2,mTau2))-6591/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/6,mTau2))+Gt({{0,0},{0,0},{1,1/3}},1/6,mTau2))-386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+1/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/3}},2/3+1/3*mTau2,mTau2))+386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+2/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/3}},2/3+2/3*mTau2,mTau2))+18621/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/3}},1/2*mTau2,mTau2))-386267/60*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/3}},2/3*mTau2,mTau2))+1330*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau2}},1/2,mTau2))-893/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau2}},1/2*mTau2,mTau2))+1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau2}},1/2,mTau2))-1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau2}},1/2+1/2*mTau2,mTau2))+8141/10*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau2}},1/2*mTau2,mTau2))+840*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau2}},2/3,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau2}},2/3,mTau2))+2016/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau2}},5/6,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau2}},5/6,mTau2))-462*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau2}},1/2+1/2*mTau2,mTau2))+576/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau2}},1/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau2}},1/6*mTau2,mTau2))+1557/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau2}},1/2*mTau2,mTau2))-560*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau2}},1/2,mTau2))+168/5*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau2}},1/2+1/2*mTau2,mTau2))-57739/24*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau2}},1/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau2}},1/6*mTau2,mTau2))+36031/120*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau2}},5/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau2}},5/6*mTau2,mTau2))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau2}},1/3,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau2}},1/3,mTau2))-1330*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau2}},1/2,mTau2))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau2}},2/3,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau2}},2/3,mTau2))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau2}},1/3+1/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau2}},1/3+1/3*mTau2,mTau2))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau2}},1/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau2}},1/3*mTau2,mTau2))+1127/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau2}},1/2,mTau2))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau2}},1/2+1/2*mTau2,mTau2))-1045553/60*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau2}},1/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau2}},1/3*mTau2,mTau2))+462814/45*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau2}},1/2*mTau2,mTau2))+22867/30*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau2}},1/2,mTau2))-6207/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau2}},2/3+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau2}},2/3+1/2*mTau2,mTau2))-72913/30*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau2}},1/2,mTau2))+4443/5*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau2}},1/2+1/2*mTau2,mTau2))-188113/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau2}},1/3,mTau2))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau2}},1/3,mTau2))+1582769/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau2}},2/3,mTau2))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau2}},2/3,mTau2))-4665/2*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau2}},5/6,mTau2))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau2}},5/6,mTau2))+630*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau2}},1/2+1/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau2}},1/2+1/6*mTau2,mTau2))+1052*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau2}},1/2+1/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau2}},1/2+1/3*mTau2,mTau2))-2734/5*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau2}},5/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau2}},5/6*mTau2,mTau2))-31277/30*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau2}},1/2,mTau2))-1764/5*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau2}},1/2+1/2*mTau2,mTau2))-9379/30*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau2}},1/2,mTau2))-1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau2}},2/3,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau2}},2/3,mTau2))+1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau2}},5/6,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau2}},5/6,mTau2))+6207/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau2}},1/2*mTau2,mTau2))+7343/5*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau2}},1/2,mTau2))-4281/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau2}},1/2*mTau2,mTau2))+2541/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau2}},2/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau2}},2/3*mTau2,mTau2))+665*(-(Gt({{0,0},{0,0},{1,-1/3-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,1/3+2/3*mTau2}},1/2,mTau2))+462/5*(-(Gt({{0,0},{0,0},{1,-1/2-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,1/2+2/3*mTau2}},1/2,mTau2))-386267/30*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau2}},1/3,mTau2))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau2}},1/3,mTau2))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau2}},2/3,mTau2))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau2}},2/3,mTau2))+1338/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau2}},1/2,mTau2))+288/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau2}},2/3,mTau2))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau2}},2/3,mTau2))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau2}},1/6+1/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau2}},1/6+1/6*mTau2,mTau2))+168/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau2}},2/3+5/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau2}},2/3+5/6*mTau2,mTau2))-64911/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau2}},1/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau2}},1/6*mTau2,mTau2))-4737/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau2}},5/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau2}},5/6*mTau2,mTau2))-1579/10*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau2}},1/2*mTau2,mTau2))-165/2*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau2}},2/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau2}},2/3*mTau2,mTau2))+893/5*(-(Gt({{0,0},{0,0},{1,-1/3-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/3+5/6*mTau2}},1/2*mTau2,mTau2))-126*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau2}},1/2+1/2*mTau2,mTau2))+168/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau2}},1/2+2/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau2}},1/2+2/3*mTau2,mTau2))+406/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau2}},1/2*mTau2,mTau2))-6666/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau2}},1/2,mTau2))-41*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau2}},1/2+1/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau2}},1/2+1/3*mTau2,mTau2))+221/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau2}},1/2+1/2*mTau2,mTau2))-253/15*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau2}},1/2*mTau2,mTau2))-37841/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau2}},1/3,mTau2))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau2}},1/3,mTau2))+321817/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau2}},1/2,mTau2))-136121/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau2}},2/3,mTau2))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau2}},2/3,mTau2))+12277/25*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau2}},5/6,mTau2))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau2}},5/6,mTau2))-208783/12*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau2}},1/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau2}},1/6*mTau2,mTau2))+1078601/180*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau2}},1/2*mTau2,mTau2))-846/5*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau2}},5/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau2}},5/6*mTau2,mTau2))-13319/8*(-(Gt({{0,0},{0,0},{1,-1/6*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,1/6*mTau2}},1/2,mTau2))+8037/40*(-(Gt({{0,0},{0,0},{1,-1/6*mTau2}},5/6+2/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/6*mTau2}},5/6+2/3*mTau2,mTau2))-462/5*(-(Gt({{0,0},{0,0},{1,-1/3*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,1/3*mTau2}},1/2,mTau2))-755827/600*(-(Gt({{0,0},{0,0},{1,-1/2*mTau2}},5/6,mTau2))+Gt({{0,0},{0,0},{1,1/2*mTau2}},5/6,mTau2))-22841/10*(-(Gt({{0,0},{0,0},{1,-1/2*mTau2}},2/3+1/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2*mTau2}},2/3+1/6*mTau2,mTau2))-1371547/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau2}},5/6+1/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2*mTau2}},5/6+1/3*mTau2,mTau2))+969431/60*(-(Gt({{0,0},{0,0},{1,-1/2*mTau2}},5/6+1/2*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2*mTau2}},5/6+1/2*mTau2,mTau2))+20261/120*(-(Gt({{0,0},{0,0},{1,-1/2*mTau2}},1/6+2/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2*mTau2}},1/6+2/3*mTau2,mTau2))+577/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau2}},1/3+5/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2*mTau2}},1/3+5/6*mTau2,mTau2))+1639/15*(-(Gt({{0,0},{0,0},{1,-1/2*mTau2}},2/3+5/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2*mTau2}},2/3+5/6*mTau2,mTau2))-1011209/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau2}},5/6+5/6*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2*mTau2}},5/6+5/6*mTau2,mTau2))-11644/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau2}},1/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,1/2*mTau2}},1/3*mTau2,mTau2))+231/5*(-(Gt({{0,0},{0,0},{1,-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,2/3*mTau2}},1/2,mTau2))-70291/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau2}},1/2,mTau2))+Gt({{0,0},{0,0},{1,5/6*mTau2}},1/2,mTau2))+8037/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau2}},5/6+2/3*mTau2,mTau2))+Gt({{0,0},{0,0},{1,5/6*mTau2}},5/6+2/3*mTau2,mTau2))",
		"2197/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},5/6+5/6*mTau2,mTau2))+Gt({{0,0},{2,1/6}},5/6+5/6*mTau2,mTau2))-10409/15*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},1/2*mTau2,mTau2))+Gt({{0,0},{2,1/6}},1/2*mTau2,mTau2))-6591/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/6,mTau2))+Gt({{0,0},{2,1/3}},1/6,mTau2))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+1/3*mTau2,mTau2))+Gt({{0,0},{2,1/3}},2/3+1/3*mTau2,mTau2))+386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+2/3*mTau2,mTau2))+Gt({{0,0},{2,1/3}},2/3+2/3*mTau2,mTau2))+18621/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/2*mTau2,mTau2))+Gt({{0,0},{2,1/3}},1/2*mTau2,mTau2))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3*mTau2,mTau2))+Gt({{0,0},{2,1/3}},2/3*mTau2,mTau2))+665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau2}},1/2,mTau2))+Gt({{0,0},{2,1/6+1/6*mTau2}},1/2,mTau2))-893/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,1/6+1/6*mTau2}},1/2*mTau2,mTau2))+1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau2}},1/2,mTau2))+Gt({{0,0},{2,2/3+1/6*mTau2}},1/2,mTau2))-1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{2,2/3+1/6*mTau2}},1/2+1/2*mTau2,mTau2))+8141/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,2/3+1/6*mTau2}},1/2*mTau2,mTau2))+420*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau2}},2/3,mTau2))+Gt({{0,0},{2,5/6+1/6*mTau2}},2/3,mTau2))+1008/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau2}},5/6,mTau2))+Gt({{0,0},{2,5/6+1/6*mTau2}},5/6,mTau2))-231*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{2,5/6+1/6*mTau2}},1/2+1/2*mTau2,mTau2))+288/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau2}},1/6*mTau2,mTau2))+Gt({{0,0},{2,5/6+1/6*mTau2}},1/6*mTau2,mTau2))+1557/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,5/6+1/6*mTau2}},1/2*mTau2,mTau2))-280*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau2}},1/2,mTau2))+Gt({{0,0},{2,1/6+1/3*mTau2}},1/2,mTau2))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{2,1/6+1/3*mTau2}},1/2+1/2*mTau2,mTau2))-57739/48*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau2}},1/6*mTau2,mTau2))+Gt({{0,0},{2,1/6+1/3*mTau2}},1/6*mTau2,mTau2))+36031/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau2}},5/6*mTau2,mTau2))+Gt({{0,0},{2,1/6+1/3*mTau2}},5/6*mTau2,mTau2))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau2}},1/3,mTau2))+Gt({{0,0},{2,2/3+1/3*mTau2}},1/3,mTau2))-665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau2}},1/2,mTau2))+Gt({{0,0},{2,2/3+1/3*mTau2}},1/2,mTau2))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau2}},2/3,mTau2))+Gt({{0,0},{2,2/3+1/3*mTau2}},2/3,mTau2))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau2}},1/3+1/3*mTau2,mTau2))+Gt({{0,0},{2,2/3+1/3*mTau2}},1/3+1/3*mTau2,mTau2))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau2}},1/3*mTau2,mTau2))+Gt({{0,0},{2,2/3+1/3*mTau2}},1/3*mTau2,mTau2))+1127/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau2}},1/2,mTau2))+Gt({{0,0},{2,5/6+1/3*mTau2}},1/2,mTau2))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{2,5/6+1/3*mTau2}},1/2+1/2*mTau2,mTau2))-1045553/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau2}},1/3*mTau2,mTau2))+Gt({{0,0},{2,5/6+1/3*mTau2}},1/3*mTau2,mTau2))+231407/45*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,5/6+1/3*mTau2}},1/2*mTau2,mTau2))+22867/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau2}},1/2,mTau2))+Gt({{0,0},{2,1/6+1/2*mTau2}},1/2,mTau2))-6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau2}},2/3+1/2*mTau2,mTau2))+Gt({{0,0},{2,1/6+1/2*mTau2}},2/3+1/2*mTau2,mTau2))-72913/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau2}},1/2,mTau2))+Gt({{0,0},{2,1/3+1/2*mTau2}},1/2,mTau2))+4443/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{2,1/3+1/2*mTau2}},1/2+1/2*mTau2,mTau2))-188113/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau2}},1/3,mTau2))+Gt({{0,0},{2,1/2+1/2*mTau2}},1/3,mTau2))+1582769/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau2}},2/3,mTau2))+Gt({{0,0},{2,1/2+1/2*mTau2}},2/3,mTau2))-4665/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau2}},5/6,mTau2))+Gt({{0,0},{2,1/2+1/2*mTau2}},5/6,mTau2))+315*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau2}},1/2+1/6*mTau2,mTau2))+Gt({{0,0},{2,1/2+1/2*mTau2}},1/2+1/6*mTau2,mTau2))+526*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau2}},1/2+1/3*mTau2,mTau2))+Gt({{0,0},{2,1/2+1/2*mTau2}},1/2+1/3*mTau2,mTau2))-1367/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau2}},5/6*mTau2,mTau2))+Gt({{0,0},{2,1/2+1/2*mTau2}},5/6*mTau2,mTau2))-31277/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau2}},1/2,mTau2))+Gt({{0,0},{2,2/3+1/2*mTau2}},1/2,mTau2))-882/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{2,2/3+1/2*mTau2}},1/2+1/2*mTau2,mTau2))-9379/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau2}},1/2,mTau2))+Gt({{0,0},{2,5/6+1/2*mTau2}},1/2,mTau2))-756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau2}},2/3,mTau2))+Gt({{0,0},{2,5/6+1/2*mTau2}},2/3,mTau2))+756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau2}},5/6,mTau2))+Gt({{0,0},{2,5/6+1/2*mTau2}},5/6,mTau2))+6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,5/6+1/2*mTau2}},1/2*mTau2,mTau2))+7343/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{2,1/6+2/3*mTau2}},1/2,mTau2))-4281/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,1/6+2/3*mTau2}},1/2*mTau2,mTau2))+2541/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau2}},2/3*mTau2,mTau2))+Gt({{0,0},{2,1/6+2/3*mTau2}},2/3*mTau2,mTau2))+665/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{2,1/3+2/3*mTau2}},1/2,mTau2))+231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{2,1/2+2/3*mTau2}},1/2,mTau2))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau2}},1/3,mTau2))+Gt({{0,0},{2,2/3+2/3*mTau2}},1/3,mTau2))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau2}},2/3,mTau2))+Gt({{0,0},{2,2/3+2/3*mTau2}},2/3,mTau2))+669/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{2,5/6+2/3*mTau2}},1/2,mTau2))+144/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau2}},2/3,mTau2))+Gt({{0,0},{2,5/6+2/3*mTau2}},2/3,mTau2))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau2}},1/6+1/6*mTau2,mTau2))+Gt({{0,0},{2,5/6+2/3*mTau2}},1/6+1/6*mTau2,mTau2))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau2}},2/3+5/6*mTau2,mTau2))+Gt({{0,0},{2,5/6+2/3*mTau2}},2/3+5/6*mTau2,mTau2))-64911/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau2}},1/6*mTau2,mTau2))+Gt({{0,0},{2,5/6+2/3*mTau2}},1/6*mTau2,mTau2))-4737/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau2}},5/6*mTau2,mTau2))+Gt({{0,0},{2,5/6+2/3*mTau2}},5/6*mTau2,mTau2))-1579/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,1/6+5/6*mTau2}},1/2*mTau2,mTau2))-165/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau2}},2/3*mTau2,mTau2))+Gt({{0,0},{2,1/6+5/6*mTau2}},2/3*mTau2,mTau2))+893/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,1/3+5/6*mTau2}},1/2*mTau2,mTau2))-63*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{2,1/2+5/6*mTau2}},1/2+1/2*mTau2,mTau2))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau2}},1/2+2/3*mTau2,mTau2))+Gt({{0,0},{2,1/2+5/6*mTau2}},1/2+2/3*mTau2,mTau2))+203/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,1/2+5/6*mTau2}},1/2*mTau2,mTau2))-3333/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau2}},1/2,mTau2))+Gt({{0,0},{2,2/3+5/6*mTau2}},1/2,mTau2))-41/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau2}},1/2+1/3*mTau2,mTau2))+Gt({{0,0},{2,2/3+5/6*mTau2}},1/2+1/3*mTau2,mTau2))+221/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{0,0},{2,2/3+5/6*mTau2}},1/2+1/2*mTau2,mTau2))-253/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,2/3+5/6*mTau2}},1/2*mTau2,mTau2))-37841/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau2}},1/3,mTau2))+Gt({{0,0},{2,5/6+5/6*mTau2}},1/3,mTau2))+321817/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau2}},1/2,mTau2))+Gt({{0,0},{2,5/6+5/6*mTau2}},1/2,mTau2))-136121/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau2}},2/3,mTau2))+Gt({{0,0},{2,5/6+5/6*mTau2}},2/3,mTau2))+12277/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau2}},5/6,mTau2))+Gt({{0,0},{2,5/6+5/6*mTau2}},5/6,mTau2))-208783/24*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau2}},1/6*mTau2,mTau2))+Gt({{0,0},{2,5/6+5/6*mTau2}},1/6*mTau2,mTau2))+1078601/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{0,0},{2,5/6+5/6*mTau2}},1/2*mTau2,mTau2))-423/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau2}},5/6*mTau2,mTau2))+Gt({{0,0},{2,5/6+5/6*mTau2}},5/6*mTau2,mTau2))-13319/16*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau2}},1/2,mTau2))+Gt({{0,0},{2,1/6*mTau2}},1/2,mTau2))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau2}},5/6+2/3*mTau2,mTau2))+Gt({{0,0},{2,1/6*mTau2}},5/6+2/3*mTau2,mTau2))-231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3*mTau2}},1/2,mTau2))+Gt({{0,0},{2,1/3*mTau2}},1/2,mTau2))-755827/1200*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau2}},5/6,mTau2))+Gt({{0,0},{2,1/2*mTau2}},5/6,mTau2))-22841/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau2}},2/3+1/6*mTau2,mTau2))+Gt({{0,0},{2,1/2*mTau2}},2/3+1/6*mTau2,mTau2))-1371547/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau2}},5/6+1/3*mTau2,mTau2))+Gt({{0,0},{2,1/2*mTau2}},5/6+1/3*mTau2,mTau2))+969431/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau2}},5/6+1/2*mTau2,mTau2))+Gt({{0,0},{2,1/2*mTau2}},5/6+1/2*mTau2,mTau2))+20261/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau2}},1/6+2/3*mTau2,mTau2))+Gt({{0,0},{2,1/2*mTau2}},1/6+2/3*mTau2,mTau2))+577/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau2}},1/3+5/6*mTau2,mTau2))+Gt({{0,0},{2,1/2*mTau2}},1/3+5/6*mTau2,mTau2))+1639/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau2}},2/3+5/6*mTau2,mTau2))+Gt({{0,0},{2,1/2*mTau2}},2/3+5/6*mTau2,mTau2))-1011209/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau2}},5/6+5/6*mTau2,mTau2))+Gt({{0,0},{2,1/2*mTau2}},5/6+5/6*mTau2,mTau2))-5822/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau2}},1/3*mTau2,mTau2))+Gt({{0,0},{2,1/2*mTau2}},1/3*mTau2,mTau2))+231/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3*mTau2}},1/2,mTau2))+Gt({{0,0},{2,2/3*mTau2}},1/2,mTau2))-70291/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau2}},1/2,mTau2))+Gt({{0,0},{2,5/6*mTau2}},1/2,mTau2))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau2}},5/6+2/3*mTau2,mTau2))+Gt({{0,0},{2,5/6*mTau2}},5/6+2/3*mTau2,mTau2))",
		"2197/300*(pow(Pi,-2))*(-(Gt({{3,-1/6}},5/6+5/6*mTau2,mTau2))+Gt({{3,1/6}},5/6+5/6*mTau2,mTau2))-10409/90*(pow(Pi,-2))*(-(Gt({{3,-1/6}},1/2*mTau2,mTau2))+Gt({{3,1/6}},1/2*mTau2,mTau2))-2197/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/6,mTau2))+Gt({{3,1/3}},1/6,mTau2))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+1/3*mTau2,mTau2))+Gt({{3,1/3}},2/3+1/3*mTau2,mTau2))+386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+2/3*mTau2,mTau2))+Gt({{3,1/3}},2/3+2/3*mTau2,mTau2))+6207/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/2*mTau2,mTau2))+Gt({{3,1/3}},1/2*mTau2,mTau2))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3*mTau2,mTau2))+Gt({{3,1/3}},2/3*mTau2,mTau2))+665/6*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau2}},1/2,mTau2))+Gt({{3,1/6+1/6*mTau2}},1/2,mTau2))-893/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau2}},1/2*mTau2,mTau2))+Gt({{3,1/6+1/6*mTau2}},1/2*mTau2,mTau2))+1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau2}},1/2,mTau2))+Gt({{3,2/3+1/6*mTau2}},1/2,mTau2))-1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{3,2/3+1/6*mTau2}},1/2+1/2*mTau2,mTau2))+8141/120*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau2}},1/2*mTau2,mTau2))+Gt({{3,2/3+1/6*mTau2}},1/2*mTau2,mTau2))+70*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau2}},2/3,mTau2))+Gt({{3,5/6+1/6*mTau2}},2/3,mTau2))+168/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau2}},5/6,mTau2))+Gt({{3,5/6+1/6*mTau2}},5/6,mTau2))-77/2*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{3,5/6+1/6*mTau2}},1/2+1/2*mTau2,mTau2))+48/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau2}},1/6*mTau2,mTau2))+Gt({{3,5/6+1/6*mTau2}},1/6*mTau2,mTau2))+519/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau2}},1/2*mTau2,mTau2))+Gt({{3,5/6+1/6*mTau2}},1/2*mTau2,mTau2))-140/3*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau2}},1/2,mTau2))+Gt({{3,1/6+1/3*mTau2}},1/2,mTau2))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{3,1/6+1/3*mTau2}},1/2+1/2*mTau2,mTau2))-57739/288*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau2}},1/6*mTau2,mTau2))+Gt({{3,1/6+1/3*mTau2}},1/6*mTau2,mTau2))+36031/1440*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau2}},5/6*mTau2,mTau2))+Gt({{3,1/6+1/3*mTau2}},5/6*mTau2,mTau2))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau2}},1/3,mTau2))+Gt({{3,2/3+1/3*mTau2}},1/3,mTau2))-665/6*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau2}},1/2,mTau2))+Gt({{3,2/3+1/3*mTau2}},1/2,mTau2))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau2}},2/3,mTau2))+Gt({{3,2/3+1/3*mTau2}},2/3,mTau2))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau2}},1/3+1/3*mTau2,mTau2))+Gt({{3,2/3+1/3*mTau2}},1/3+1/3*mTau2,mTau2))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau2}},1/3*mTau2,mTau2))+Gt({{3,2/3+1/3*mTau2}},1/3*mTau2,mTau2))+1127/60*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau2}},1/2,mTau2))+Gt({{3,5/6+1/3*mTau2}},1/2,mTau2))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{3,5/6+1/3*mTau2}},1/2+1/2*mTau2,mTau2))-1045553/720*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau2}},1/3*mTau2,mTau2))+Gt({{3,5/6+1/3*mTau2}},1/3*mTau2,mTau2))+231407/270*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau2}},1/2*mTau2,mTau2))+Gt({{3,5/6+1/3*mTau2}},1/2*mTau2,mTau2))+22867/360*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau2}},1/2,mTau2))+Gt({{3,1/6+1/2*mTau2}},1/2,mTau2))-2069/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau2}},2/3+1/2*mTau2,mTau2))+Gt({{3,1/6+1/2*mTau2}},2/3+1/2*mTau2,mTau2))-72913/360*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau2}},1/2,mTau2))+Gt({{3,1/3+1/2*mTau2}},1/2,mTau2))+1481/20*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{3,1/3+1/2*mTau2}},1/2+1/2*mTau2,mTau2))-188113/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau2}},1/3,mTau2))+Gt({{3,1/2+1/2*mTau2}},1/3,mTau2))+1582769/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau2}},2/3,mTau2))+Gt({{3,1/2+1/2*mTau2}},2/3,mTau2))-1555/8*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau2}},5/6,mTau2))+Gt({{3,1/2+1/2*mTau2}},5/6,mTau2))+105/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau2}},1/2+1/6*mTau2,mTau2))+Gt({{3,1/2+1/2*mTau2}},1/2+1/6*mTau2,mTau2))+263/3*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau2}},1/2+1/3*mTau2,mTau2))+Gt({{3,1/2+1/2*mTau2}},1/2+1/3*mTau2,mTau2))-1367/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau2}},5/6*mTau2,mTau2))+Gt({{3,1/2+1/2*mTau2}},5/6*mTau2,mTau2))-31277/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau2}},1/2,mTau2))+Gt({{3,2/3+1/2*mTau2}},1/2,mTau2))-147/5*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{3,2/3+1/2*mTau2}},1/2+1/2*mTau2,mTau2))-9379/360*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau2}},1/2,mTau2))+Gt({{3,5/6+1/2*mTau2}},1/2,mTau2))-126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau2}},2/3,mTau2))+Gt({{3,5/6+1/2*mTau2}},2/3,mTau2))+126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau2}},5/6,mTau2))+Gt({{3,5/6+1/2*mTau2}},5/6,mTau2))+2069/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau2}},1/2*mTau2,mTau2))+Gt({{3,5/6+1/2*mTau2}},1/2*mTau2,mTau2))+7343/60*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau2}},1/2,mTau2))+Gt({{3,1/6+2/3*mTau2}},1/2,mTau2))-1427/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau2}},1/2*mTau2,mTau2))+Gt({{3,1/6+2/3*mTau2}},1/2*mTau2,mTau2))+847/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau2}},2/3*mTau2,mTau2))+Gt({{3,1/6+2/3*mTau2}},2/3*mTau2,mTau2))+665/12*(pow(Pi,-2))*(-(Gt({{3,-1/3-2/3*mTau2}},1/2,mTau2))+Gt({{3,1/3+2/3*mTau2}},1/2,mTau2))+77/10*(pow(Pi,-2))*(-(Gt({{3,-1/2-2/3*mTau2}},1/2,mTau2))+Gt({{3,1/2+2/3*mTau2}},1/2,mTau2))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau2}},1/3,mTau2))+Gt({{3,2/3+2/3*mTau2}},1/3,mTau2))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau2}},2/3,mTau2))+Gt({{3,2/3+2/3*mTau2}},2/3,mTau2))+223/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau2}},1/2,mTau2))+Gt({{3,5/6+2/3*mTau2}},1/2,mTau2))+24/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau2}},2/3,mTau2))+Gt({{3,5/6+2/3*mTau2}},2/3,mTau2))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau2}},1/6+1/6*mTau2,mTau2))+Gt({{3,5/6+2/3*mTau2}},1/6+1/6*mTau2,mTau2))+14/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau2}},2/3+5/6*mTau2,mTau2))+Gt({{3,5/6+2/3*mTau2}},2/3+5/6*mTau2,mTau2))-21637/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau2}},1/6*mTau2,mTau2))+Gt({{3,5/6+2/3*mTau2}},1/6*mTau2,mTau2))-1579/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau2}},5/6*mTau2,mTau2))+Gt({{3,5/6+2/3*mTau2}},5/6*mTau2,mTau2))-1579/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{3,1/6+5/6*mTau2}},1/2*mTau2,mTau2))-55/8*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau2}},2/3*mTau2,mTau2))+Gt({{3,1/6+5/6*mTau2}},2/3*mTau2,mTau2))+893/60*(pow(Pi,-2))*(-(Gt({{3,-1/3-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{3,1/3+5/6*mTau2}},1/2*mTau2,mTau2))-21/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{3,1/2+5/6*mTau2}},1/2+1/2*mTau2,mTau2))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau2}},1/2+2/3*mTau2,mTau2))+Gt({{3,1/2+5/6*mTau2}},1/2+2/3*mTau2,mTau2))+203/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{3,1/2+5/6*mTau2}},1/2*mTau2,mTau2))-1111/10*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau2}},1/2,mTau2))+Gt({{3,2/3+5/6*mTau2}},1/2,mTau2))-41/12*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau2}},1/2+1/3*mTau2,mTau2))+Gt({{3,2/3+5/6*mTau2}},1/2+1/3*mTau2,mTau2))+221/60*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau2}},1/2+1/2*mTau2,mTau2))+Gt({{3,2/3+5/6*mTau2}},1/2+1/2*mTau2,mTau2))-253/180*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{3,2/3+5/6*mTau2}},1/2*mTau2,mTau2))-37841/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau2}},1/3,mTau2))+Gt({{3,5/6+5/6*mTau2}},1/3,mTau2))+321817/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau2}},1/2,mTau2))+Gt({{3,5/6+5/6*mTau2}},1/2,mTau2))-136121/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau2}},2/3,mTau2))+Gt({{3,5/6+5/6*mTau2}},2/3,mTau2))+12277/300*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau2}},5/6,mTau2))+Gt({{3,5/6+5/6*mTau2}},5/6,mTau2))-208783/144*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau2}},1/6*mTau2,mTau2))+Gt({{3,5/6+5/6*mTau2}},1/6*mTau2,mTau2))+1078601/2160*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau2}},1/2*mTau2,mTau2))+Gt({{3,5/6+5/6*mTau2}},1/2*mTau2,mTau2))-141/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau2}},5/6*mTau2,mTau2))+Gt({{3,5/6+5/6*mTau2}},5/6*mTau2,mTau2))-13319/96*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau2}},1/2,mTau2))+Gt({{3,1/6*mTau2}},1/2,mTau2))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau2}},5/6+2/3*mTau2,mTau2))+Gt({{3,1/6*mTau2}},5/6+2/3*mTau2,mTau2))-77/10*(pow(Pi,-2))*(-(Gt({{3,-1/3*mTau2}},1/2,mTau2))+Gt({{3,1/3*mTau2}},1/2,mTau2))-755827/7200*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau2}},5/6,mTau2))+Gt({{3,1/2*mTau2}},5/6,mTau2))-22841/120*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau2}},2/3+1/6*mTau2,mTau2))+Gt({{3,1/2*mTau2}},2/3+1/6*mTau2,mTau2))-1371547/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau2}},5/6+1/3*mTau2,mTau2))+Gt({{3,1/2*mTau2}},5/6+1/3*mTau2,mTau2))+969431/720*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau2}},5/6+1/2*mTau2,mTau2))+Gt({{3,1/2*mTau2}},5/6+1/2*mTau2,mTau2))+20261/1440*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau2}},1/6+2/3*mTau2,mTau2))+Gt({{3,1/2*mTau2}},1/6+2/3*mTau2,mTau2))+577/60*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau2}},1/3+5/6*mTau2,mTau2))+Gt({{3,1/2*mTau2}},1/3+5/6*mTau2,mTau2))+1639/180*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau2}},2/3+5/6*mTau2,mTau2))+Gt({{3,1/2*mTau2}},2/3+5/6*mTau2,mTau2))-1011209/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau2}},5/6+5/6*mTau2,mTau2))+Gt({{3,1/2*mTau2}},5/6+5/6*mTau2,mTau2))-2911/15*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau2}},1/3*mTau2,mTau2))+Gt({{3,1/2*mTau2}},1/3*mTau2,mTau2))+77/20*(pow(Pi,-2))*(-(Gt({{3,-2/3*mTau2}},1/2,mTau2))+Gt({{3,2/3*mTau2}},1/2,mTau2))-70291/480*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau2}},1/2,mTau2))+Gt({{3,5/6*mTau2}},1/2,mTau2))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau2}},5/6+2/3*mTau2,mTau2))+Gt({{3,5/6*mTau2}},5/6+2/3*mTau2,mTau2))",
		"2197/25*(-(Gt({{0,0},{0,0},{1,-1/6}},5/6+5/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6}},5/6+5/6*mTau3,mTau3))-20818/15*(-(Gt({{0,0},{0,0},{1,-1/6}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6}},1/2*mTau3,mTau3))-6591/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/6,mTau3))+Gt({{0,0},{0,0},{1,1/3}},1/6,mTau3))-386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+1/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/3}},2/3+1/3*mTau3,mTau3))+386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+2/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/3}},2/3+2/3*mTau3,mTau3))+18621/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/3}},1/2*mTau3,mTau3))-386267/60*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/3}},2/3*mTau3,mTau3))+1330*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau3}},1/2,mTau3))-893/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau3}},1/2*mTau3,mTau3))+1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau3}},1/2,mTau3))-1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau3}},1/2+1/2*mTau3,mTau3))+8141/10*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau3}},1/2*mTau3,mTau3))+840*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau3}},2/3,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau3}},2/3,mTau3))+2016/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau3}},5/6,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau3}},5/6,mTau3))-462*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau3}},1/2+1/2*mTau3,mTau3))+576/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau3}},1/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau3}},1/6*mTau3,mTau3))+1557/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau3}},1/2*mTau3,mTau3))-560*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau3}},1/2,mTau3))+168/5*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau3}},1/2+1/2*mTau3,mTau3))-57739/24*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau3}},1/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau3}},1/6*mTau3,mTau3))+36031/120*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau3}},5/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau3}},5/6*mTau3,mTau3))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau3}},1/3,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau3}},1/3,mTau3))-1330*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau3}},1/2,mTau3))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau3}},2/3,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau3}},2/3,mTau3))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau3}},1/3+1/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau3}},1/3+1/3*mTau3,mTau3))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau3}},1/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau3}},1/3*mTau3,mTau3))+1127/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau3}},1/2,mTau3))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau3}},1/2+1/2*mTau3,mTau3))-1045553/60*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau3}},1/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau3}},1/3*mTau3,mTau3))+462814/45*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau3}},1/2*mTau3,mTau3))+22867/30*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau3}},1/2,mTau3))-6207/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau3}},2/3+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau3}},2/3+1/2*mTau3,mTau3))-72913/30*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau3}},1/2,mTau3))+4443/5*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau3}},1/2+1/2*mTau3,mTau3))-188113/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau3}},1/3,mTau3))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau3}},1/3,mTau3))+1582769/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau3}},2/3,mTau3))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau3}},2/3,mTau3))-4665/2*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau3}},5/6,mTau3))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau3}},5/6,mTau3))+630*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau3}},1/2+1/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau3}},1/2+1/6*mTau3,mTau3))+1052*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau3}},1/2+1/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau3}},1/2+1/3*mTau3,mTau3))-2734/5*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau3}},5/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau3}},5/6*mTau3,mTau3))-31277/30*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau3}},1/2,mTau3))-1764/5*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau3}},1/2+1/2*mTau3,mTau3))-9379/30*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau3}},1/2,mTau3))-1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau3}},2/3,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau3}},2/3,mTau3))+1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau3}},5/6,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau3}},5/6,mTau3))+6207/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau3}},1/2*mTau3,mTau3))+7343/5*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau3}},1/2,mTau3))-4281/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau3}},1/2*mTau3,mTau3))+2541/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau3}},2/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau3}},2/3*mTau3,mTau3))+665*(-(Gt({{0,0},{0,0},{1,-1/3-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,1/3+2/3*mTau3}},1/2,mTau3))+462/5*(-(Gt({{0,0},{0,0},{1,-1/2-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,1/2+2/3*mTau3}},1/2,mTau3))-386267/30*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau3}},1/3,mTau3))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau3}},1/3,mTau3))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau3}},2/3,mTau3))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau3}},2/3,mTau3))+1338/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau3}},1/2,mTau3))+288/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau3}},2/3,mTau3))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau3}},2/3,mTau3))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau3}},1/6+1/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau3}},1/6+1/6*mTau3,mTau3))+168/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau3}},2/3+5/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau3}},2/3+5/6*mTau3,mTau3))-64911/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau3}},1/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau3}},1/6*mTau3,mTau3))-4737/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau3}},5/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau3}},5/6*mTau3,mTau3))-1579/10*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau3}},1/2*mTau3,mTau3))-165/2*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau3}},2/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau3}},2/3*mTau3,mTau3))+893/5*(-(Gt({{0,0},{0,0},{1,-1/3-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/3+5/6*mTau3}},1/2*mTau3,mTau3))-126*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau3}},1/2+1/2*mTau3,mTau3))+168/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau3}},1/2+2/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau3}},1/2+2/3*mTau3,mTau3))+406/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau3}},1/2*mTau3,mTau3))-6666/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau3}},1/2,mTau3))-41*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau3}},1/2+1/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau3}},1/2+1/3*mTau3,mTau3))+221/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau3}},1/2+1/2*mTau3,mTau3))-253/15*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau3}},1/2*mTau3,mTau3))-37841/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau3}},1/3,mTau3))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau3}},1/3,mTau3))+321817/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau3}},1/2,mTau3))-136121/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau3}},2/3,mTau3))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau3}},2/3,mTau3))+12277/25*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau3}},5/6,mTau3))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau3}},5/6,mTau3))-208783/12*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau3}},1/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau3}},1/6*mTau3,mTau3))+1078601/180*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau3}},1/2*mTau3,mTau3))-846/5*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau3}},5/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau3}},5/6*mTau3,mTau3))-13319/8*(-(Gt({{0,0},{0,0},{1,-1/6*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,1/6*mTau3}},1/2,mTau3))+8037/40*(-(Gt({{0,0},{0,0},{1,-1/6*mTau3}},5/6+2/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/6*mTau3}},5/6+2/3*mTau3,mTau3))-462/5*(-(Gt({{0,0},{0,0},{1,-1/3*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,1/3*mTau3}},1/2,mTau3))-755827/600*(-(Gt({{0,0},{0,0},{1,-1/2*mTau3}},5/6,mTau3))+Gt({{0,0},{0,0},{1,1/2*mTau3}},5/6,mTau3))-22841/10*(-(Gt({{0,0},{0,0},{1,-1/2*mTau3}},2/3+1/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2*mTau3}},2/3+1/6*mTau3,mTau3))-1371547/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau3}},5/6+1/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2*mTau3}},5/6+1/3*mTau3,mTau3))+969431/60*(-(Gt({{0,0},{0,0},{1,-1/2*mTau3}},5/6+1/2*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2*mTau3}},5/6+1/2*mTau3,mTau3))+20261/120*(-(Gt({{0,0},{0,0},{1,-1/2*mTau3}},1/6+2/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2*mTau3}},1/6+2/3*mTau3,mTau3))+577/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau3}},1/3+5/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2*mTau3}},1/3+5/6*mTau3,mTau3))+1639/15*(-(Gt({{0,0},{0,0},{1,-1/2*mTau3}},2/3+5/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2*mTau3}},2/3+5/6*mTau3,mTau3))-1011209/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau3}},5/6+5/6*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2*mTau3}},5/6+5/6*mTau3,mTau3))-11644/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau3}},1/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,1/2*mTau3}},1/3*mTau3,mTau3))+231/5*(-(Gt({{0,0},{0,0},{1,-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,2/3*mTau3}},1/2,mTau3))-70291/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau3}},1/2,mTau3))+Gt({{0,0},{0,0},{1,5/6*mTau3}},1/2,mTau3))+8037/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau3}},5/6+2/3*mTau3,mTau3))+Gt({{0,0},{0,0},{1,5/6*mTau3}},5/6+2/3*mTau3,mTau3))",
		"2197/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},5/6+5/6*mTau3,mTau3))+Gt({{0,0},{2,1/6}},5/6+5/6*mTau3,mTau3))-10409/15*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},1/2*mTau3,mTau3))+Gt({{0,0},{2,1/6}},1/2*mTau3,mTau3))-6591/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/6,mTau3))+Gt({{0,0},{2,1/3}},1/6,mTau3))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+1/3*mTau3,mTau3))+Gt({{0,0},{2,1/3}},2/3+1/3*mTau3,mTau3))+386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+2/3*mTau3,mTau3))+Gt({{0,0},{2,1/3}},2/3+2/3*mTau3,mTau3))+18621/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,1/3}},1/2*mTau3,mTau3))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3*mTau3,mTau3))+Gt({{0,0},{2,1/3}},2/3*mTau3,mTau3))+665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau3}},1/2,mTau3))+Gt({{0,0},{2,1/6+1/6*mTau3}},1/2,mTau3))-893/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,1/6+1/6*mTau3}},1/2*mTau3,mTau3))+1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau3}},1/2,mTau3))+Gt({{0,0},{2,2/3+1/6*mTau3}},1/2,mTau3))-1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{2,2/3+1/6*mTau3}},1/2+1/2*mTau3,mTau3))+8141/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,2/3+1/6*mTau3}},1/2*mTau3,mTau3))+420*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau3}},2/3,mTau3))+Gt({{0,0},{2,5/6+1/6*mTau3}},2/3,mTau3))+1008/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau3}},5/6,mTau3))+Gt({{0,0},{2,5/6+1/6*mTau3}},5/6,mTau3))-231*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{2,5/6+1/6*mTau3}},1/2+1/2*mTau3,mTau3))+288/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau3}},1/6*mTau3,mTau3))+Gt({{0,0},{2,5/6+1/6*mTau3}},1/6*mTau3,mTau3))+1557/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,5/6+1/6*mTau3}},1/2*mTau3,mTau3))-280*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau3}},1/2,mTau3))+Gt({{0,0},{2,1/6+1/3*mTau3}},1/2,mTau3))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{2,1/6+1/3*mTau3}},1/2+1/2*mTau3,mTau3))-57739/48*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau3}},1/6*mTau3,mTau3))+Gt({{0,0},{2,1/6+1/3*mTau3}},1/6*mTau3,mTau3))+36031/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau3}},5/6*mTau3,mTau3))+Gt({{0,0},{2,1/6+1/3*mTau3}},5/6*mTau3,mTau3))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau3}},1/3,mTau3))+Gt({{0,0},{2,2/3+1/3*mTau3}},1/3,mTau3))-665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau3}},1/2,mTau3))+Gt({{0,0},{2,2/3+1/3*mTau3}},1/2,mTau3))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau3}},2/3,mTau3))+Gt({{0,0},{2,2/3+1/3*mTau3}},2/3,mTau3))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau3}},1/3+1/3*mTau3,mTau3))+Gt({{0,0},{2,2/3+1/3*mTau3}},1/3+1/3*mTau3,mTau3))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau3}},1/3*mTau3,mTau3))+Gt({{0,0},{2,2/3+1/3*mTau3}},1/3*mTau3,mTau3))+1127/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau3}},1/2,mTau3))+Gt({{0,0},{2,5/6+1/3*mTau3}},1/2,mTau3))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{2,5/6+1/3*mTau3}},1/2+1/2*mTau3,mTau3))-1045553/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau3}},1/3*mTau3,mTau3))+Gt({{0,0},{2,5/6+1/3*mTau3}},1/3*mTau3,mTau3))+231407/45*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,5/6+1/3*mTau3}},1/2*mTau3,mTau3))+22867/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau3}},1/2,mTau3))+Gt({{0,0},{2,1/6+1/2*mTau3}},1/2,mTau3))-6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau3}},2/3+1/2*mTau3,mTau3))+Gt({{0,0},{2,1/6+1/2*mTau3}},2/3+1/2*mTau3,mTau3))-72913/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau3}},1/2,mTau3))+Gt({{0,0},{2,1/3+1/2*mTau3}},1/2,mTau3))+4443/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{2,1/3+1/2*mTau3}},1/2+1/2*mTau3,mTau3))-188113/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau3}},1/3,mTau3))+Gt({{0,0},{2,1/2+1/2*mTau3}},1/3,mTau3))+1582769/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau3}},2/3,mTau3))+Gt({{0,0},{2,1/2+1/2*mTau3}},2/3,mTau3))-4665/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau3}},5/6,mTau3))+Gt({{0,0},{2,1/2+1/2*mTau3}},5/6,mTau3))+315*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau3}},1/2+1/6*mTau3,mTau3))+Gt({{0,0},{2,1/2+1/2*mTau3}},1/2+1/6*mTau3,mTau3))+526*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau3}},1/2+1/3*mTau3,mTau3))+Gt({{0,0},{2,1/2+1/2*mTau3}},1/2+1/3*mTau3,mTau3))-1367/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau3}},5/6*mTau3,mTau3))+Gt({{0,0},{2,1/2+1/2*mTau3}},5/6*mTau3,mTau3))-31277/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau3}},1/2,mTau3))+Gt({{0,0},{2,2/3+1/2*mTau3}},1/2,mTau3))-882/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{2,2/3+1/2*mTau3}},1/2+1/2*mTau3,mTau3))-9379/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau3}},1/2,mTau3))+Gt({{0,0},{2,5/6+1/2*mTau3}},1/2,mTau3))-756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau3}},2/3,mTau3))+Gt({{0,0},{2,5/6+1/2*mTau3}},2/3,mTau3))+756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau3}},5/6,mTau3))+Gt({{0,0},{2,5/6+1/2*mTau3}},5/6,mTau3))+6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,5/6+1/2*mTau3}},1/2*mTau3,mTau3))+7343/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{2,1/6+2/3*mTau3}},1/2,mTau3))-4281/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,1/6+2/3*mTau3}},1/2*mTau3,mTau3))+2541/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau3}},2/3*mTau3,mTau3))+Gt({{0,0},{2,1/6+2/3*mTau3}},2/3*mTau3,mTau3))+665/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{2,1/3+2/3*mTau3}},1/2,mTau3))+231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{2,1/2+2/3*mTau3}},1/2,mTau3))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau3}},1/3,mTau3))+Gt({{0,0},{2,2/3+2/3*mTau3}},1/3,mTau3))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau3}},2/3,mTau3))+Gt({{0,0},{2,2/3+2/3*mTau3}},2/3,mTau3))+669/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{2,5/6+2/3*mTau3}},1/2,mTau3))+144/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau3}},2/3,mTau3))+Gt({{0,0},{2,5/6+2/3*mTau3}},2/3,mTau3))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau3}},1/6+1/6*mTau3,mTau3))+Gt({{0,0},{2,5/6+2/3*mTau3}},1/6+1/6*mTau3,mTau3))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau3}},2/3+5/6*mTau3,mTau3))+Gt({{0,0},{2,5/6+2/3*mTau3}},2/3+5/6*mTau3,mTau3))-64911/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau3}},1/6*mTau3,mTau3))+Gt({{0,0},{2,5/6+2/3*mTau3}},1/6*mTau3,mTau3))-4737/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau3}},5/6*mTau3,mTau3))+Gt({{0,0},{2,5/6+2/3*mTau3}},5/6*mTau3,mTau3))-1579/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,1/6+5/6*mTau3}},1/2*mTau3,mTau3))-165/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau3}},2/3*mTau3,mTau3))+Gt({{0,0},{2,1/6+5/6*mTau3}},2/3*mTau3,mTau3))+893/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,1/3+5/6*mTau3}},1/2*mTau3,mTau3))-63*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{2,1/2+5/6*mTau3}},1/2+1/2*mTau3,mTau3))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau3}},1/2+2/3*mTau3,mTau3))+Gt({{0,0},{2,1/2+5/6*mTau3}},1/2+2/3*mTau3,mTau3))+203/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,1/2+5/6*mTau3}},1/2*mTau3,mTau3))-3333/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau3}},1/2,mTau3))+Gt({{0,0},{2,2/3+5/6*mTau3}},1/2,mTau3))-41/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau3}},1/2+1/3*mTau3,mTau3))+Gt({{0,0},{2,2/3+5/6*mTau3}},1/2+1/3*mTau3,mTau3))+221/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{0,0},{2,2/3+5/6*mTau3}},1/2+1/2*mTau3,mTau3))-253/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,2/3+5/6*mTau3}},1/2*mTau3,mTau3))-37841/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau3}},1/3,mTau3))+Gt({{0,0},{2,5/6+5/6*mTau3}},1/3,mTau3))+321817/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau3}},1/2,mTau3))+Gt({{0,0},{2,5/6+5/6*mTau3}},1/2,mTau3))-136121/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau3}},2/3,mTau3))+Gt({{0,0},{2,5/6+5/6*mTau3}},2/3,mTau3))+12277/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau3}},5/6,mTau3))+Gt({{0,0},{2,5/6+5/6*mTau3}},5/6,mTau3))-208783/24*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau3}},1/6*mTau3,mTau3))+Gt({{0,0},{2,5/6+5/6*mTau3}},1/6*mTau3,mTau3))+1078601/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{0,0},{2,5/6+5/6*mTau3}},1/2*mTau3,mTau3))-423/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau3}},5/6*mTau3,mTau3))+Gt({{0,0},{2,5/6+5/6*mTau3}},5/6*mTau3,mTau3))-13319/16*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau3}},1/2,mTau3))+Gt({{0,0},{2,1/6*mTau3}},1/2,mTau3))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau3}},5/6+2/3*mTau3,mTau3))+Gt({{0,0},{2,1/6*mTau3}},5/6+2/3*mTau3,mTau3))-231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3*mTau3}},1/2,mTau3))+Gt({{0,0},{2,1/3*mTau3}},1/2,mTau3))-755827/1200*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau3}},5/6,mTau3))+Gt({{0,0},{2,1/2*mTau3}},5/6,mTau3))-22841/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau3}},2/3+1/6*mTau3,mTau3))+Gt({{0,0},{2,1/2*mTau3}},2/3+1/6*mTau3,mTau3))-1371547/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau3}},5/6+1/3*mTau3,mTau3))+Gt({{0,0},{2,1/2*mTau3}},5/6+1/3*mTau3,mTau3))+969431/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau3}},5/6+1/2*mTau3,mTau3))+Gt({{0,0},{2,1/2*mTau3}},5/6+1/2*mTau3,mTau3))+20261/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau3}},1/6+2/3*mTau3,mTau3))+Gt({{0,0},{2,1/2*mTau3}},1/6+2/3*mTau3,mTau3))+577/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau3}},1/3+5/6*mTau3,mTau3))+Gt({{0,0},{2,1/2*mTau3}},1/3+5/6*mTau3,mTau3))+1639/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau3}},2/3+5/6*mTau3,mTau3))+Gt({{0,0},{2,1/2*mTau3}},2/3+5/6*mTau3,mTau3))-1011209/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau3}},5/6+5/6*mTau3,mTau3))+Gt({{0,0},{2,1/2*mTau3}},5/6+5/6*mTau3,mTau3))-5822/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau3}},1/3*mTau3,mTau3))+Gt({{0,0},{2,1/2*mTau3}},1/3*mTau3,mTau3))+231/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3*mTau3}},1/2,mTau3))+Gt({{0,0},{2,2/3*mTau3}},1/2,mTau3))-70291/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau3}},1/2,mTau3))+Gt({{0,0},{2,5/6*mTau3}},1/2,mTau3))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau3}},5/6+2/3*mTau3,mTau3))+Gt({{0,0},{2,5/6*mTau3}},5/6+2/3*mTau3,mTau3))",
		"2197/300*(pow(Pi,-2))*(-(Gt({{3,-1/6}},5/6+5/6*mTau3,mTau3))+Gt({{3,1/6}},5/6+5/6*mTau3,mTau3))-10409/90*(pow(Pi,-2))*(-(Gt({{3,-1/6}},1/2*mTau3,mTau3))+Gt({{3,1/6}},1/2*mTau3,mTau3))-2197/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/6,mTau3))+Gt({{3,1/3}},1/6,mTau3))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+1/3*mTau3,mTau3))+Gt({{3,1/3}},2/3+1/3*mTau3,mTau3))+386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+2/3*mTau3,mTau3))+Gt({{3,1/3}},2/3+2/3*mTau3,mTau3))+6207/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/2*mTau3,mTau3))+Gt({{3,1/3}},1/2*mTau3,mTau3))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3*mTau3,mTau3))+Gt({{3,1/3}},2/3*mTau3,mTau3))+665/6*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau3}},1/2,mTau3))+Gt({{3,1/6+1/6*mTau3}},1/2,mTau3))-893/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau3}},1/2*mTau3,mTau3))+Gt({{3,1/6+1/6*mTau3}},1/2*mTau3,mTau3))+1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau3}},1/2,mTau3))+Gt({{3,2/3+1/6*mTau3}},1/2,mTau3))-1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{3,2/3+1/6*mTau3}},1/2+1/2*mTau3,mTau3))+8141/120*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau3}},1/2*mTau3,mTau3))+Gt({{3,2/3+1/6*mTau3}},1/2*mTau3,mTau3))+70*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau3}},2/3,mTau3))+Gt({{3,5/6+1/6*mTau3}},2/3,mTau3))+168/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau3}},5/6,mTau3))+Gt({{3,5/6+1/6*mTau3}},5/6,mTau3))-77/2*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{3,5/6+1/6*mTau3}},1/2+1/2*mTau3,mTau3))+48/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau3}},1/6*mTau3,mTau3))+Gt({{3,5/6+1/6*mTau3}},1/6*mTau3,mTau3))+519/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau3}},1/2*mTau3,mTau3))+Gt({{3,5/6+1/6*mTau3}},1/2*mTau3,mTau3))-140/3*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau3}},1/2,mTau3))+Gt({{3,1/6+1/3*mTau3}},1/2,mTau3))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{3,1/6+1/3*mTau3}},1/2+1/2*mTau3,mTau3))-57739/288*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau3}},1/6*mTau3,mTau3))+Gt({{3,1/6+1/3*mTau3}},1/6*mTau3,mTau3))+36031/1440*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau3}},5/6*mTau3,mTau3))+Gt({{3,1/6+1/3*mTau3}},5/6*mTau3,mTau3))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau3}},1/3,mTau3))+Gt({{3,2/3+1/3*mTau3}},1/3,mTau3))-665/6*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau3}},1/2,mTau3))+Gt({{3,2/3+1/3*mTau3}},1/2,mTau3))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau3}},2/3,mTau3))+Gt({{3,2/3+1/3*mTau3}},2/3,mTau3))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau3}},1/3+1/3*mTau3,mTau3))+Gt({{3,2/3+1/3*mTau3}},1/3+1/3*mTau3,mTau3))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau3}},1/3*mTau3,mTau3))+Gt({{3,2/3+1/3*mTau3}},1/3*mTau3,mTau3))+1127/60*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau3}},1/2,mTau3))+Gt({{3,5/6+1/3*mTau3}},1/2,mTau3))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{3,5/6+1/3*mTau3}},1/2+1/2*mTau3,mTau3))-1045553/720*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau3}},1/3*mTau3,mTau3))+Gt({{3,5/6+1/3*mTau3}},1/3*mTau3,mTau3))+231407/270*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau3}},1/2*mTau3,mTau3))+Gt({{3,5/6+1/3*mTau3}},1/2*mTau3,mTau3))+22867/360*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau3}},1/2,mTau3))+Gt({{3,1/6+1/2*mTau3}},1/2,mTau3))-2069/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau3}},2/3+1/2*mTau3,mTau3))+Gt({{3,1/6+1/2*mTau3}},2/3+1/2*mTau3,mTau3))-72913/360*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau3}},1/2,mTau3))+Gt({{3,1/3+1/2*mTau3}},1/2,mTau3))+1481/20*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{3,1/3+1/2*mTau3}},1/2+1/2*mTau3,mTau3))-188113/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau3}},1/3,mTau3))+Gt({{3,1/2+1/2*mTau3}},1/3,mTau3))+1582769/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau3}},2/3,mTau3))+Gt({{3,1/2+1/2*mTau3}},2/3,mTau3))-1555/8*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau3}},5/6,mTau3))+Gt({{3,1/2+1/2*mTau3}},5/6,mTau3))+105/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau3}},1/2+1/6*mTau3,mTau3))+Gt({{3,1/2+1/2*mTau3}},1/2+1/6*mTau3,mTau3))+263/3*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau3}},1/2+1/3*mTau3,mTau3))+Gt({{3,1/2+1/2*mTau3}},1/2+1/3*mTau3,mTau3))-1367/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau3}},5/6*mTau3,mTau3))+Gt({{3,1/2+1/2*mTau3}},5/6*mTau3,mTau3))-31277/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau3}},1/2,mTau3))+Gt({{3,2/3+1/2*mTau3}},1/2,mTau3))-147/5*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{3,2/3+1/2*mTau3}},1/2+1/2*mTau3,mTau3))-9379/360*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau3}},1/2,mTau3))+Gt({{3,5/6+1/2*mTau3}},1/2,mTau3))-126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau3}},2/3,mTau3))+Gt({{3,5/6+1/2*mTau3}},2/3,mTau3))+126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau3}},5/6,mTau3))+Gt({{3,5/6+1/2*mTau3}},5/6,mTau3))+2069/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau3}},1/2*mTau3,mTau3))+Gt({{3,5/6+1/2*mTau3}},1/2*mTau3,mTau3))+7343/60*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau3}},1/2,mTau3))+Gt({{3,1/6+2/3*mTau3}},1/2,mTau3))-1427/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau3}},1/2*mTau3,mTau3))+Gt({{3,1/6+2/3*mTau3}},1/2*mTau3,mTau3))+847/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau3}},2/3*mTau3,mTau3))+Gt({{3,1/6+2/3*mTau3}},2/3*mTau3,mTau3))+665/12*(pow(Pi,-2))*(-(Gt({{3,-1/3-2/3*mTau3}},1/2,mTau3))+Gt({{3,1/3+2/3*mTau3}},1/2,mTau3))+77/10*(pow(Pi,-2))*(-(Gt({{3,-1/2-2/3*mTau3}},1/2,mTau3))+Gt({{3,1/2+2/3*mTau3}},1/2,mTau3))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau3}},1/3,mTau3))+Gt({{3,2/3+2/3*mTau3}},1/3,mTau3))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau3}},2/3,mTau3))+Gt({{3,2/3+2/3*mTau3}},2/3,mTau3))+223/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau3}},1/2,mTau3))+Gt({{3,5/6+2/3*mTau3}},1/2,mTau3))+24/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau3}},2/3,mTau3))+Gt({{3,5/6+2/3*mTau3}},2/3,mTau3))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau3}},1/6+1/6*mTau3,mTau3))+Gt({{3,5/6+2/3*mTau3}},1/6+1/6*mTau3,mTau3))+14/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau3}},2/3+5/6*mTau3,mTau3))+Gt({{3,5/6+2/3*mTau3}},2/3+5/6*mTau3,mTau3))-21637/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau3}},1/6*mTau3,mTau3))+Gt({{3,5/6+2/3*mTau3}},1/6*mTau3,mTau3))-1579/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau3}},5/6*mTau3,mTau3))+Gt({{3,5/6+2/3*mTau3}},5/6*mTau3,mTau3))-1579/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{3,1/6+5/6*mTau3}},1/2*mTau3,mTau3))-55/8*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau3}},2/3*mTau3,mTau3))+Gt({{3,1/6+5/6*mTau3}},2/3*mTau3,mTau3))+893/60*(pow(Pi,-2))*(-(Gt({{3,-1/3-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{3,1/3+5/6*mTau3}},1/2*mTau3,mTau3))-21/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{3,1/2+5/6*mTau3}},1/2+1/2*mTau3,mTau3))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau3}},1/2+2/3*mTau3,mTau3))+Gt({{3,1/2+5/6*mTau3}},1/2+2/3*mTau3,mTau3))+203/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{3,1/2+5/6*mTau3}},1/2*mTau3,mTau3))-1111/10*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau3}},1/2,mTau3))+Gt({{3,2/3+5/6*mTau3}},1/2,mTau3))-41/12*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau3}},1/2+1/3*mTau3,mTau3))+Gt({{3,2/3+5/6*mTau3}},1/2+1/3*mTau3,mTau3))+221/60*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau3}},1/2+1/2*mTau3,mTau3))+Gt({{3,2/3+5/6*mTau3}},1/2+1/2*mTau3,mTau3))-253/180*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{3,2/3+5/6*mTau3}},1/2*mTau3,mTau3))-37841/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau3}},1/3,mTau3))+Gt({{3,5/6+5/6*mTau3}},1/3,mTau3))+321817/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau3}},1/2,mTau3))+Gt({{3,5/6+5/6*mTau3}},1/2,mTau3))-136121/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau3}},2/3,mTau3))+Gt({{3,5/6+5/6*mTau3}},2/3,mTau3))+12277/300*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau3}},5/6,mTau3))+Gt({{3,5/6+5/6*mTau3}},5/6,mTau3))-208783/144*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau3}},1/6*mTau3,mTau3))+Gt({{3,5/6+5/6*mTau3}},1/6*mTau3,mTau3))+1078601/2160*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau3}},1/2*mTau3,mTau3))+Gt({{3,5/6+5/6*mTau3}},1/2*mTau3,mTau3))-141/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau3}},5/6*mTau3,mTau3))+Gt({{3,5/6+5/6*mTau3}},5/6*mTau3,mTau3))-13319/96*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau3}},1/2,mTau3))+Gt({{3,1/6*mTau3}},1/2,mTau3))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau3}},5/6+2/3*mTau3,mTau3))+Gt({{3,1/6*mTau3}},5/6+2/3*mTau3,mTau3))-77/10*(pow(Pi,-2))*(-(Gt({{3,-1/3*mTau3}},1/2,mTau3))+Gt({{3,1/3*mTau3}},1/2,mTau3))-755827/7200*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau3}},5/6,mTau3))+Gt({{3,1/2*mTau3}},5/6,mTau3))-22841/120*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau3}},2/3+1/6*mTau3,mTau3))+Gt({{3,1/2*mTau3}},2/3+1/6*mTau3,mTau3))-1371547/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau3}},5/6+1/3*mTau3,mTau3))+Gt({{3,1/2*mTau3}},5/6+1/3*mTau3,mTau3))+969431/720*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau3}},5/6+1/2*mTau3,mTau3))+Gt({{3,1/2*mTau3}},5/6+1/2*mTau3,mTau3))+20261/1440*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau3}},1/6+2/3*mTau3,mTau3))+Gt({{3,1/2*mTau3}},1/6+2/3*mTau3,mTau3))+577/60*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau3}},1/3+5/6*mTau3,mTau3))+Gt({{3,1/2*mTau3}},1/3+5/6*mTau3,mTau3))+1639/180*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau3}},2/3+5/6*mTau3,mTau3))+Gt({{3,1/2*mTau3}},2/3+5/6*mTau3,mTau3))-1011209/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau3}},5/6+5/6*mTau3,mTau3))+Gt({{3,1/2*mTau3}},5/6+5/6*mTau3,mTau3))-2911/15*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau3}},1/3*mTau3,mTau3))+Gt({{3,1/2*mTau3}},1/3*mTau3,mTau3))+77/20*(pow(Pi,-2))*(-(Gt({{3,-2/3*mTau3}},1/2,mTau3))+Gt({{3,2/3*mTau3}},1/2,mTau3))-70291/480*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau3}},1/2,mTau3))+Gt({{3,5/6*mTau3}},1/2,mTau3))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau3}},5/6+2/3*mTau3,mTau3))+Gt({{3,5/6*mTau3}},5/6+2/3*mTau3,mTau3))",
		"2197/25*(-(Gt({{0,0},{0,0},{1,-1/6}},5/6+5/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6}},5/6+5/6*mTau4,mTau4))-20818/15*(-(Gt({{0,0},{0,0},{1,-1/6}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6}},1/2*mTau4,mTau4))-6591/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/6,mTau4))+Gt({{0,0},{0,0},{1,1/3}},1/6,mTau4))-386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+1/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/3}},2/3+1/3*mTau4,mTau4))+386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+2/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/3}},2/3+2/3*mTau4,mTau4))+18621/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/3}},1/2*mTau4,mTau4))-386267/60*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/3}},2/3*mTau4,mTau4))+1330*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau4}},1/2,mTau4))-893/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau4}},1/2*mTau4,mTau4))+1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau4}},1/2,mTau4))-1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau4}},1/2+1/2*mTau4,mTau4))+8141/10*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau4}},1/2*mTau4,mTau4))+840*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau4}},2/3,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau4}},2/3,mTau4))+2016/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau4}},5/6,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau4}},5/6,mTau4))-462*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau4}},1/2+1/2*mTau4,mTau4))+576/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau4}},1/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau4}},1/6*mTau4,mTau4))+1557/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau4}},1/2*mTau4,mTau4))-560*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau4}},1/2,mTau4))+168/5*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau4}},1/2+1/2*mTau4,mTau4))-57739/24*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau4}},1/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau4}},1/6*mTau4,mTau4))+36031/120*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau4}},5/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau4}},5/6*mTau4,mTau4))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau4}},1/3,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau4}},1/3,mTau4))-1330*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau4}},1/2,mTau4))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau4}},2/3,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau4}},2/3,mTau4))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau4}},1/3+1/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau4}},1/3+1/3*mTau4,mTau4))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau4}},1/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau4}},1/3*mTau4,mTau4))+1127/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau4}},1/2,mTau4))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau4}},1/2+1/2*mTau4,mTau4))-1045553/60*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau4}},1/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau4}},1/3*mTau4,mTau4))+462814/45*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau4}},1/2*mTau4,mTau4))+22867/30*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau4}},1/2,mTau4))-6207/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau4}},2/3+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau4}},2/3+1/2*mTau4,mTau4))-72913/30*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau4}},1/2,mTau4))+4443/5*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau4}},1/2+1/2*mTau4,mTau4))-188113/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau4}},1/3,mTau4))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau4}},1/3,mTau4))+1582769/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau4}},2/3,mTau4))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau4}},2/3,mTau4))-4665/2*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau4}},5/6,mTau4))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau4}},5/6,mTau4))+630*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau4}},1/2+1/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau4}},1/2+1/6*mTau4,mTau4))+1052*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau4}},1/2+1/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau4}},1/2+1/3*mTau4,mTau4))-2734/5*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau4}},5/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau4}},5/6*mTau4,mTau4))-31277/30*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau4}},1/2,mTau4))-1764/5*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau4}},1/2+1/2*mTau4,mTau4))-9379/30*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau4}},1/2,mTau4))-1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau4}},2/3,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau4}},2/3,mTau4))+1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau4}},5/6,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau4}},5/6,mTau4))+6207/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau4}},1/2*mTau4,mTau4))+7343/5*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau4}},1/2,mTau4))-4281/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau4}},1/2*mTau4,mTau4))+2541/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau4}},2/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau4}},2/3*mTau4,mTau4))+665*(-(Gt({{0,0},{0,0},{1,-1/3-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,1/3+2/3*mTau4}},1/2,mTau4))+462/5*(-(Gt({{0,0},{0,0},{1,-1/2-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,1/2+2/3*mTau4}},1/2,mTau4))-386267/30*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau4}},1/3,mTau4))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau4}},1/3,mTau4))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau4}},2/3,mTau4))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau4}},2/3,mTau4))+1338/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau4}},1/2,mTau4))+288/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau4}},2/3,mTau4))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau4}},2/3,mTau4))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau4}},1/6+1/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau4}},1/6+1/6*mTau4,mTau4))+168/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau4}},2/3+5/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau4}},2/3+5/6*mTau4,mTau4))-64911/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau4}},1/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau4}},1/6*mTau4,mTau4))-4737/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau4}},5/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau4}},5/6*mTau4,mTau4))-1579/10*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau4}},1/2*mTau4,mTau4))-165/2*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau4}},2/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau4}},2/3*mTau4,mTau4))+893/5*(-(Gt({{0,0},{0,0},{1,-1/3-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/3+5/6*mTau4}},1/2*mTau4,mTau4))-126*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau4}},1/2+1/2*mTau4,mTau4))+168/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau4}},1/2+2/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau4}},1/2+2/3*mTau4,mTau4))+406/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau4}},1/2*mTau4,mTau4))-6666/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau4}},1/2,mTau4))-41*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau4}},1/2+1/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau4}},1/2+1/3*mTau4,mTau4))+221/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau4}},1/2+1/2*mTau4,mTau4))-253/15*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau4}},1/2*mTau4,mTau4))-37841/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau4}},1/3,mTau4))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau4}},1/3,mTau4))+321817/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau4}},1/2,mTau4))-136121/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau4}},2/3,mTau4))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau4}},2/3,mTau4))+12277/25*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau4}},5/6,mTau4))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau4}},5/6,mTau4))-208783/12*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau4}},1/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau4}},1/6*mTau4,mTau4))+1078601/180*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau4}},1/2*mTau4,mTau4))-846/5*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau4}},5/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau4}},5/6*mTau4,mTau4))-13319/8*(-(Gt({{0,0},{0,0},{1,-1/6*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,1/6*mTau4}},1/2,mTau4))+8037/40*(-(Gt({{0,0},{0,0},{1,-1/6*mTau4}},5/6+2/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/6*mTau4}},5/6+2/3*mTau4,mTau4))-462/5*(-(Gt({{0,0},{0,0},{1,-1/3*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,1/3*mTau4}},1/2,mTau4))-755827/600*(-(Gt({{0,0},{0,0},{1,-1/2*mTau4}},5/6,mTau4))+Gt({{0,0},{0,0},{1,1/2*mTau4}},5/6,mTau4))-22841/10*(-(Gt({{0,0},{0,0},{1,-1/2*mTau4}},2/3+1/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2*mTau4}},2/3+1/6*mTau4,mTau4))-1371547/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau4}},5/6+1/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2*mTau4}},5/6+1/3*mTau4,mTau4))+969431/60*(-(Gt({{0,0},{0,0},{1,-1/2*mTau4}},5/6+1/2*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2*mTau4}},5/6+1/2*mTau4,mTau4))+20261/120*(-(Gt({{0,0},{0,0},{1,-1/2*mTau4}},1/6+2/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2*mTau4}},1/6+2/3*mTau4,mTau4))+577/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau4}},1/3+5/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2*mTau4}},1/3+5/6*mTau4,mTau4))+1639/15*(-(Gt({{0,0},{0,0},{1,-1/2*mTau4}},2/3+5/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2*mTau4}},2/3+5/6*mTau4,mTau4))-1011209/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau4}},5/6+5/6*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2*mTau4}},5/6+5/6*mTau4,mTau4))-11644/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau4}},1/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,1/2*mTau4}},1/3*mTau4,mTau4))+231/5*(-(Gt({{0,0},{0,0},{1,-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,2/3*mTau4}},1/2,mTau4))-70291/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau4}},1/2,mTau4))+Gt({{0,0},{0,0},{1,5/6*mTau4}},1/2,mTau4))+8037/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau4}},5/6+2/3*mTau4,mTau4))+Gt({{0,0},{0,0},{1,5/6*mTau4}},5/6+2/3*mTau4,mTau4))",
		"2197/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},5/6+5/6*mTau4,mTau4))+Gt({{0,0},{2,1/6}},5/6+5/6*mTau4,mTau4))-10409/15*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},1/2*mTau4,mTau4))+Gt({{0,0},{2,1/6}},1/2*mTau4,mTau4))-6591/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/6,mTau4))+Gt({{0,0},{2,1/3}},1/6,mTau4))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+1/3*mTau4,mTau4))+Gt({{0,0},{2,1/3}},2/3+1/3*mTau4,mTau4))+386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+2/3*mTau4,mTau4))+Gt({{0,0},{2,1/3}},2/3+2/3*mTau4,mTau4))+18621/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/2*mTau4,mTau4))+Gt({{0,0},{2,1/3}},1/2*mTau4,mTau4))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3*mTau4,mTau4))+Gt({{0,0},{2,1/3}},2/3*mTau4,mTau4))+665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau4}},1/2,mTau4))+Gt({{0,0},{2,1/6+1/6*mTau4}},1/2,mTau4))-893/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,1/6+1/6*mTau4}},1/2*mTau4,mTau4))+1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau4}},1/2,mTau4))+Gt({{0,0},{2,2/3+1/6*mTau4}},1/2,mTau4))-1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{2,2/3+1/6*mTau4}},1/2+1/2*mTau4,mTau4))+8141/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,2/3+1/6*mTau4}},1/2*mTau4,mTau4))+420*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau4}},2/3,mTau4))+Gt({{0,0},{2,5/6+1/6*mTau4}},2/3,mTau4))+1008/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau4}},5/6,mTau4))+Gt({{0,0},{2,5/6+1/6*mTau4}},5/6,mTau4))-231*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{2,5/6+1/6*mTau4}},1/2+1/2*mTau4,mTau4))+288/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau4}},1/6*mTau4,mTau4))+Gt({{0,0},{2,5/6+1/6*mTau4}},1/6*mTau4,mTau4))+1557/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,5/6+1/6*mTau4}},1/2*mTau4,mTau4))-280*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau4}},1/2,mTau4))+Gt({{0,0},{2,1/6+1/3*mTau4}},1/2,mTau4))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{2,1/6+1/3*mTau4}},1/2+1/2*mTau4,mTau4))-57739/48*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau4}},1/6*mTau4,mTau4))+Gt({{0,0},{2,1/6+1/3*mTau4}},1/6*mTau4,mTau4))+36031/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau4}},5/6*mTau4,mTau4))+Gt({{0,0},{2,1/6+1/3*mTau4}},5/6*mTau4,mTau4))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau4}},1/3,mTau4))+Gt({{0,0},{2,2/3+1/3*mTau4}},1/3,mTau4))-665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau4}},1/2,mTau4))+Gt({{0,0},{2,2/3+1/3*mTau4}},1/2,mTau4))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau4}},2/3,mTau4))+Gt({{0,0},{2,2/3+1/3*mTau4}},2/3,mTau4))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau4}},1/3+1/3*mTau4,mTau4))+Gt({{0,0},{2,2/3+1/3*mTau4}},1/3+1/3*mTau4,mTau4))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau4}},1/3*mTau4,mTau4))+Gt({{0,0},{2,2/3+1/3*mTau4}},1/3*mTau4,mTau4))+1127/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau4}},1/2,mTau4))+Gt({{0,0},{2,5/6+1/3*mTau4}},1/2,mTau4))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{2,5/6+1/3*mTau4}},1/2+1/2*mTau4,mTau4))-1045553/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau4}},1/3*mTau4,mTau4))+Gt({{0,0},{2,5/6+1/3*mTau4}},1/3*mTau4,mTau4))+231407/45*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,5/6+1/3*mTau4}},1/2*mTau4,mTau4))+22867/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau4}},1/2,mTau4))+Gt({{0,0},{2,1/6+1/2*mTau4}},1/2,mTau4))-6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau4}},2/3+1/2*mTau4,mTau4))+Gt({{0,0},{2,1/6+1/2*mTau4}},2/3+1/2*mTau4,mTau4))-72913/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau4}},1/2,mTau4))+Gt({{0,0},{2,1/3+1/2*mTau4}},1/2,mTau4))+4443/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{2,1/3+1/2*mTau4}},1/2+1/2*mTau4,mTau4))-188113/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau4}},1/3,mTau4))+Gt({{0,0},{2,1/2+1/2*mTau4}},1/3,mTau4))+1582769/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau4}},2/3,mTau4))+Gt({{0,0},{2,1/2+1/2*mTau4}},2/3,mTau4))-4665/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau4}},5/6,mTau4))+Gt({{0,0},{2,1/2+1/2*mTau4}},5/6,mTau4))+315*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau4}},1/2+1/6*mTau4,mTau4))+Gt({{0,0},{2,1/2+1/2*mTau4}},1/2+1/6*mTau4,mTau4))+526*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau4}},1/2+1/3*mTau4,mTau4))+Gt({{0,0},{2,1/2+1/2*mTau4}},1/2+1/3*mTau4,mTau4))-1367/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau4}},5/6*mTau4,mTau4))+Gt({{0,0},{2,1/2+1/2*mTau4}},5/6*mTau4,mTau4))-31277/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau4}},1/2,mTau4))+Gt({{0,0},{2,2/3+1/2*mTau4}},1/2,mTau4))-882/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{2,2/3+1/2*mTau4}},1/2+1/2*mTau4,mTau4))-9379/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau4}},1/2,mTau4))+Gt({{0,0},{2,5/6+1/2*mTau4}},1/2,mTau4))-756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau4}},2/3,mTau4))+Gt({{0,0},{2,5/6+1/2*mTau4}},2/3,mTau4))+756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau4}},5/6,mTau4))+Gt({{0,0},{2,5/6+1/2*mTau4}},5/6,mTau4))+6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,5/6+1/2*mTau4}},1/2*mTau4,mTau4))+7343/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{2,1/6+2/3*mTau4}},1/2,mTau4))-4281/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,1/6+2/3*mTau4}},1/2*mTau4,mTau4))+2541/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau4}},2/3*mTau4,mTau4))+Gt({{0,0},{2,1/6+2/3*mTau4}},2/3*mTau4,mTau4))+665/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{2,1/3+2/3*mTau4}},1/2,mTau4))+231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{2,1/2+2/3*mTau4}},1/2,mTau4))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau4}},1/3,mTau4))+Gt({{0,0},{2,2/3+2/3*mTau4}},1/3,mTau4))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau4}},2/3,mTau4))+Gt({{0,0},{2,2/3+2/3*mTau4}},2/3,mTau4))+669/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{2,5/6+2/3*mTau4}},1/2,mTau4))+144/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau4}},2/3,mTau4))+Gt({{0,0},{2,5/6+2/3*mTau4}},2/3,mTau4))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau4}},1/6+1/6*mTau4,mTau4))+Gt({{0,0},{2,5/6+2/3*mTau4}},1/6+1/6*mTau4,mTau4))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau4}},2/3+5/6*mTau4,mTau4))+Gt({{0,0},{2,5/6+2/3*mTau4}},2/3+5/6*mTau4,mTau4))-64911/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau4}},1/6*mTau4,mTau4))+Gt({{0,0},{2,5/6+2/3*mTau4}},1/6*mTau4,mTau4))-4737/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau4}},5/6*mTau4,mTau4))+Gt({{0,0},{2,5/6+2/3*mTau4}},5/6*mTau4,mTau4))-1579/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,1/6+5/6*mTau4}},1/2*mTau4,mTau4))-165/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau4}},2/3*mTau4,mTau4))+Gt({{0,0},{2,1/6+5/6*mTau4}},2/3*mTau4,mTau4))+893/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,1/3+5/6*mTau4}},1/2*mTau4,mTau4))-63*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{2,1/2+5/6*mTau4}},1/2+1/2*mTau4,mTau4))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau4}},1/2+2/3*mTau4,mTau4))+Gt({{0,0},{2,1/2+5/6*mTau4}},1/2+2/3*mTau4,mTau4))+203/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,1/2+5/6*mTau4}},1/2*mTau4,mTau4))-3333/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau4}},1/2,mTau4))+Gt({{0,0},{2,2/3+5/6*mTau4}},1/2,mTau4))-41/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau4}},1/2+1/3*mTau4,mTau4))+Gt({{0,0},{2,2/3+5/6*mTau4}},1/2+1/3*mTau4,mTau4))+221/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{0,0},{2,2/3+5/6*mTau4}},1/2+1/2*mTau4,mTau4))-253/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,2/3+5/6*mTau4}},1/2*mTau4,mTau4))-37841/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau4}},1/3,mTau4))+Gt({{0,0},{2,5/6+5/6*mTau4}},1/3,mTau4))+321817/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau4}},1/2,mTau4))+Gt({{0,0},{2,5/6+5/6*mTau4}},1/2,mTau4))-136121/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau4}},2/3,mTau4))+Gt({{0,0},{2,5/6+5/6*mTau4}},2/3,mTau4))+12277/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau4}},5/6,mTau4))+Gt({{0,0},{2,5/6+5/6*mTau4}},5/6,mTau4))-208783/24*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau4}},1/6*mTau4,mTau4))+Gt({{0,0},{2,5/6+5/6*mTau4}},1/6*mTau4,mTau4))+1078601/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{0,0},{2,5/6+5/6*mTau4}},1/2*mTau4,mTau4))-423/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau4}},5/6*mTau4,mTau4))+Gt({{0,0},{2,5/6+5/6*mTau4}},5/6*mTau4,mTau4))-13319/16*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau4}},1/2,mTau4))+Gt({{0,0},{2,1/6*mTau4}},1/2,mTau4))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau4}},5/6+2/3*mTau4,mTau4))+Gt({{0,0},{2,1/6*mTau4}},5/6+2/3*mTau4,mTau4))-231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3*mTau4}},1/2,mTau4))+Gt({{0,0},{2,1/3*mTau4}},1/2,mTau4))-755827/1200*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau4}},5/6,mTau4))+Gt({{0,0},{2,1/2*mTau4}},5/6,mTau4))-22841/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau4}},2/3+1/6*mTau4,mTau4))+Gt({{0,0},{2,1/2*mTau4}},2/3+1/6*mTau4,mTau4))-1371547/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau4}},5/6+1/3*mTau4,mTau4))+Gt({{0,0},{2,1/2*mTau4}},5/6+1/3*mTau4,mTau4))+969431/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau4}},5/6+1/2*mTau4,mTau4))+Gt({{0,0},{2,1/2*mTau4}},5/6+1/2*mTau4,mTau4))+20261/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau4}},1/6+2/3*mTau4,mTau4))+Gt({{0,0},{2,1/2*mTau4}},1/6+2/3*mTau4,mTau4))+577/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau4}},1/3+5/6*mTau4,mTau4))+Gt({{0,0},{2,1/2*mTau4}},1/3+5/6*mTau4,mTau4))+1639/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau4}},2/3+5/6*mTau4,mTau4))+Gt({{0,0},{2,1/2*mTau4}},2/3+5/6*mTau4,mTau4))-1011209/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau4}},5/6+5/6*mTau4,mTau4))+Gt({{0,0},{2,1/2*mTau4}},5/6+5/6*mTau4,mTau4))-5822/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau4}},1/3*mTau4,mTau4))+Gt({{0,0},{2,1/2*mTau4}},1/3*mTau4,mTau4))+231/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3*mTau4}},1/2,mTau4))+Gt({{0,0},{2,2/3*mTau4}},1/2,mTau4))-70291/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau4}},1/2,mTau4))+Gt({{0,0},{2,5/6*mTau4}},1/2,mTau4))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau4}},5/6+2/3*mTau4,mTau4))+Gt({{0,0},{2,5/6*mTau4}},5/6+2/3*mTau4,mTau4))",
		"2197/300*(pow(Pi,-2))*(-(Gt({{3,-1/6}},5/6+5/6*mTau4,mTau4))+Gt({{3,1/6}},5/6+5/6*mTau4,mTau4))-10409/90*(pow(Pi,-2))*(-(Gt({{3,-1/6}},1/2*mTau4,mTau4))+Gt({{3,1/6}},1/2*mTau4,mTau4))-2197/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/6,mTau4))+Gt({{3,1/3}},1/6,mTau4))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+1/3*mTau4,mTau4))+Gt({{3,1/3}},2/3+1/3*mTau4,mTau4))+386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+2/3*mTau4,mTau4))+Gt({{3,1/3}},2/3+2/3*mTau4,mTau4))+6207/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/2*mTau4,mTau4))+Gt({{3,1/3}},1/2*mTau4,mTau4))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3*mTau4,mTau4))+Gt({{3,1/3}},2/3*mTau4,mTau4))+665/6*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau4}},1/2,mTau4))+Gt({{3,1/6+1/6*mTau4}},1/2,mTau4))-893/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau4}},1/2*mTau4,mTau4))+Gt({{3,1/6+1/6*mTau4}},1/2*mTau4,mTau4))+1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau4}},1/2,mTau4))+Gt({{3,2/3+1/6*mTau4}},1/2,mTau4))-1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{3,2/3+1/6*mTau4}},1/2+1/2*mTau4,mTau4))+8141/120*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau4}},1/2*mTau4,mTau4))+Gt({{3,2/3+1/6*mTau4}},1/2*mTau4,mTau4))+70*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau4}},2/3,mTau4))+Gt({{3,5/6+1/6*mTau4}},2/3,mTau4))+168/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau4}},5/6,mTau4))+Gt({{3,5/6+1/6*mTau4}},5/6,mTau4))-77/2*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{3,5/6+1/6*mTau4}},1/2+1/2*mTau4,mTau4))+48/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau4}},1/6*mTau4,mTau4))+Gt({{3,5/6+1/6*mTau4}},1/6*mTau4,mTau4))+519/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau4}},1/2*mTau4,mTau4))+Gt({{3,5/6+1/6*mTau4}},1/2*mTau4,mTau4))-140/3*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau4}},1/2,mTau4))+Gt({{3,1/6+1/3*mTau4}},1/2,mTau4))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{3,1/6+1/3*mTau4}},1/2+1/2*mTau4,mTau4))-57739/288*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau4}},1/6*mTau4,mTau4))+Gt({{3,1/6+1/3*mTau4}},1/6*mTau4,mTau4))+36031/1440*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau4}},5/6*mTau4,mTau4))+Gt({{3,1/6+1/3*mTau4}},5/6*mTau4,mTau4))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau4}},1/3,mTau4))+Gt({{3,2/3+1/3*mTau4}},1/3,mTau4))-665/6*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau4}},1/2,mTau4))+Gt({{3,2/3+1/3*mTau4}},1/2,mTau4))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau4}},2/3,mTau4))+Gt({{3,2/3+1/3*mTau4}},2/3,mTau4))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau4}},1/3+1/3*mTau4,mTau4))+Gt({{3,2/3+1/3*mTau4}},1/3+1/3*mTau4,mTau4))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau4}},1/3*mTau4,mTau4))+Gt({{3,2/3+1/3*mTau4}},1/3*mTau4,mTau4))+1127/60*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau4}},1/2,mTau4))+Gt({{3,5/6+1/3*mTau4}},1/2,mTau4))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{3,5/6+1/3*mTau4}},1/2+1/2*mTau4,mTau4))-1045553/720*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau4}},1/3*mTau4,mTau4))+Gt({{3,5/6+1/3*mTau4}},1/3*mTau4,mTau4))+231407/270*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau4}},1/2*mTau4,mTau4))+Gt({{3,5/6+1/3*mTau4}},1/2*mTau4,mTau4))+22867/360*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau4}},1/2,mTau4))+Gt({{3,1/6+1/2*mTau4}},1/2,mTau4))-2069/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau4}},2/3+1/2*mTau4,mTau4))+Gt({{3,1/6+1/2*mTau4}},2/3+1/2*mTau4,mTau4))-72913/360*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau4}},1/2,mTau4))+Gt({{3,1/3+1/2*mTau4}},1/2,mTau4))+1481/20*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{3,1/3+1/2*mTau4}},1/2+1/2*mTau4,mTau4))-188113/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau4}},1/3,mTau4))+Gt({{3,1/2+1/2*mTau4}},1/3,mTau4))+1582769/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau4}},2/3,mTau4))+Gt({{3,1/2+1/2*mTau4}},2/3,mTau4))-1555/8*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau4}},5/6,mTau4))+Gt({{3,1/2+1/2*mTau4}},5/6,mTau4))+105/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau4}},1/2+1/6*mTau4,mTau4))+Gt({{3,1/2+1/2*mTau4}},1/2+1/6*mTau4,mTau4))+263/3*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau4}},1/2+1/3*mTau4,mTau4))+Gt({{3,1/2+1/2*mTau4}},1/2+1/3*mTau4,mTau4))-1367/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau4}},5/6*mTau4,mTau4))+Gt({{3,1/2+1/2*mTau4}},5/6*mTau4,mTau4))-31277/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau4}},1/2,mTau4))+Gt({{3,2/3+1/2*mTau4}},1/2,mTau4))-147/5*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{3,2/3+1/2*mTau4}},1/2+1/2*mTau4,mTau4))-9379/360*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau4}},1/2,mTau4))+Gt({{3,5/6+1/2*mTau4}},1/2,mTau4))-126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau4}},2/3,mTau4))+Gt({{3,5/6+1/2*mTau4}},2/3,mTau4))+126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau4}},5/6,mTau4))+Gt({{3,5/6+1/2*mTau4}},5/6,mTau4))+2069/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau4}},1/2*mTau4,mTau4))+Gt({{3,5/6+1/2*mTau4}},1/2*mTau4,mTau4))+7343/60*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau4}},1/2,mTau4))+Gt({{3,1/6+2/3*mTau4}},1/2,mTau4))-1427/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau4}},1/2*mTau4,mTau4))+Gt({{3,1/6+2/3*mTau4}},1/2*mTau4,mTau4))+847/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau4}},2/3*mTau4,mTau4))+Gt({{3,1/6+2/3*mTau4}},2/3*mTau4,mTau4))+665/12*(pow(Pi,-2))*(-(Gt({{3,-1/3-2/3*mTau4}},1/2,mTau4))+Gt({{3,1/3+2/3*mTau4}},1/2,mTau4))+77/10*(pow(Pi,-2))*(-(Gt({{3,-1/2-2/3*mTau4}},1/2,mTau4))+Gt({{3,1/2+2/3*mTau4}},1/2,mTau4))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau4}},1/3,mTau4))+Gt({{3,2/3+2/3*mTau4}},1/3,mTau4))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau4}},2/3,mTau4))+Gt({{3,2/3+2/3*mTau4}},2/3,mTau4))+223/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau4}},1/2,mTau4))+Gt({{3,5/6+2/3*mTau4}},1/2,mTau4))+24/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau4}},2/3,mTau4))+Gt({{3,5/6+2/3*mTau4}},2/3,mTau4))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau4}},1/6+1/6*mTau4,mTau4))+Gt({{3,5/6+2/3*mTau4}},1/6+1/6*mTau4,mTau4))+14/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau4}},2/3+5/6*mTau4,mTau4))+Gt({{3,5/6+2/3*mTau4}},2/3+5/6*mTau4,mTau4))-21637/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau4}},1/6*mTau4,mTau4))+Gt({{3,5/6+2/3*mTau4}},1/6*mTau4,mTau4))-1579/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau4}},5/6*mTau4,mTau4))+Gt({{3,5/6+2/3*mTau4}},5/6*mTau4,mTau4))-1579/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{3,1/6+5/6*mTau4}},1/2*mTau4,mTau4))-55/8*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau4}},2/3*mTau4,mTau4))+Gt({{3,1/6+5/6*mTau4}},2/3*mTau4,mTau4))+893/60*(pow(Pi,-2))*(-(Gt({{3,-1/3-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{3,1/3+5/6*mTau4}},1/2*mTau4,mTau4))-21/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{3,1/2+5/6*mTau4}},1/2+1/2*mTau4,mTau4))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau4}},1/2+2/3*mTau4,mTau4))+Gt({{3,1/2+5/6*mTau4}},1/2+2/3*mTau4,mTau4))+203/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{3,1/2+5/6*mTau4}},1/2*mTau4,mTau4))-1111/10*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau4}},1/2,mTau4))+Gt({{3,2/3+5/6*mTau4}},1/2,mTau4))-41/12*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau4}},1/2+1/3*mTau4,mTau4))+Gt({{3,2/3+5/6*mTau4}},1/2+1/3*mTau4,mTau4))+221/60*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau4}},1/2+1/2*mTau4,mTau4))+Gt({{3,2/3+5/6*mTau4}},1/2+1/2*mTau4,mTau4))-253/180*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{3,2/3+5/6*mTau4}},1/2*mTau4,mTau4))-37841/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau4}},1/3,mTau4))+Gt({{3,5/6+5/6*mTau4}},1/3,mTau4))+321817/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau4}},1/2,mTau4))+Gt({{3,5/6+5/6*mTau4}},1/2,mTau4))-136121/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau4}},2/3,mTau4))+Gt({{3,5/6+5/6*mTau4}},2/3,mTau4))+12277/300*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau4}},5/6,mTau4))+Gt({{3,5/6+5/6*mTau4}},5/6,mTau4))-208783/144*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau4}},1/6*mTau4,mTau4))+Gt({{3,5/6+5/6*mTau4}},1/6*mTau4,mTau4))+1078601/2160*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau4}},1/2*mTau4,mTau4))+Gt({{3,5/6+5/6*mTau4}},1/2*mTau4,mTau4))-141/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau4}},5/6*mTau4,mTau4))+Gt({{3,5/6+5/6*mTau4}},5/6*mTau4,mTau4))-13319/96*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau4}},1/2,mTau4))+Gt({{3,1/6*mTau4}},1/2,mTau4))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau4}},5/6+2/3*mTau4,mTau4))+Gt({{3,1/6*mTau4}},5/6+2/3*mTau4,mTau4))-77/10*(pow(Pi,-2))*(-(Gt({{3,-1/3*mTau4}},1/2,mTau4))+Gt({{3,1/3*mTau4}},1/2,mTau4))-755827/7200*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau4}},5/6,mTau4))+Gt({{3,1/2*mTau4}},5/6,mTau4))-22841/120*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau4}},2/3+1/6*mTau4,mTau4))+Gt({{3,1/2*mTau4}},2/3+1/6*mTau4,mTau4))-1371547/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau4}},5/6+1/3*mTau4,mTau4))+Gt({{3,1/2*mTau4}},5/6+1/3*mTau4,mTau4))+969431/720*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau4}},5/6+1/2*mTau4,mTau4))+Gt({{3,1/2*mTau4}},5/6+1/2*mTau4,mTau4))+20261/1440*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau4}},1/6+2/3*mTau4,mTau4))+Gt({{3,1/2*mTau4}},1/6+2/3*mTau4,mTau4))+577/60*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau4}},1/3+5/6*mTau4,mTau4))+Gt({{3,1/2*mTau4}},1/3+5/6*mTau4,mTau4))+1639/180*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau4}},2/3+5/6*mTau4,mTau4))+Gt({{3,1/2*mTau4}},2/3+5/6*mTau4,mTau4))-1011209/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau4}},5/6+5/6*mTau4,mTau4))+Gt({{3,1/2*mTau4}},5/6+5/6*mTau4,mTau4))-2911/15*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau4}},1/3*mTau4,mTau4))+Gt({{3,1/2*mTau4}},1/3*mTau4,mTau4))+77/20*(pow(Pi,-2))*(-(Gt({{3,-2/3*mTau4}},1/2,mTau4))+Gt({{3,2/3*mTau4}},1/2,mTau4))-70291/480*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau4}},1/2,mTau4))+Gt({{3,5/6*mTau4}},1/2,mTau4))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau4}},5/6+2/3*mTau4,mTau4))+Gt({{3,5/6*mTau4}},5/6+2/3*mTau4,mTau4))",
		"2197/25*(-(Gt({{0,0},{0,0},{1,-1/6}},5/6+5/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6}},5/6+5/6*mTau5,mTau5))-20818/15*(-(Gt({{0,0},{0,0},{1,-1/6}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6}},1/2*mTau5,mTau5))-6591/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/6,mTau5))+Gt({{0,0},{0,0},{1,1/3}},1/6,mTau5))-386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+1/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/3}},2/3+1/3*mTau5,mTau5))+386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+2/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/3}},2/3+2/3*mTau5,mTau5))+18621/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/3}},1/2*mTau5,mTau5))-386267/60*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/3}},2/3*mTau5,mTau5))+1330*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau5}},1/2,mTau5))-893/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau5}},1/2*mTau5,mTau5))+1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau5}},1/2,mTau5))-1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau5}},1/2+1/2*mTau5,mTau5))+8141/10*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau5}},1/2*mTau5,mTau5))+840*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau5}},2/3,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau5}},2/3,mTau5))+2016/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau5}},5/6,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau5}},5/6,mTau5))-462*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau5}},1/2+1/2*mTau5,mTau5))+576/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau5}},1/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau5}},1/6*mTau5,mTau5))+1557/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau5}},1/2*mTau5,mTau5))-560*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau5}},1/2,mTau5))+168/5*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau5}},1/2+1/2*mTau5,mTau5))-57739/24*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau5}},1/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau5}},1/6*mTau5,mTau5))+36031/120*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau5}},5/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau5}},5/6*mTau5,mTau5))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau5}},1/3,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau5}},1/3,mTau5))-1330*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau5}},1/2,mTau5))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau5}},2/3,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau5}},2/3,mTau5))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau5}},1/3+1/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau5}},1/3+1/3*mTau5,mTau5))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau5}},1/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau5}},1/3*mTau5,mTau5))+1127/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau5}},1/2,mTau5))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau5}},1/2+1/2*mTau5,mTau5))-1045553/60*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau5}},1/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau5}},1/3*mTau5,mTau5))+462814/45*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau5}},1/2*mTau5,mTau5))+22867/30*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau5}},1/2,mTau5))-6207/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau5}},2/3+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau5}},2/3+1/2*mTau5,mTau5))-72913/30*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau5}},1/2,mTau5))+4443/5*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau5}},1/2+1/2*mTau5,mTau5))-188113/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau5}},1/3,mTau5))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau5}},1/3,mTau5))+1582769/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau5}},2/3,mTau5))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau5}},2/3,mTau5))-4665/2*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau5}},5/6,mTau5))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau5}},5/6,mTau5))+630*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau5}},1/2+1/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau5}},1/2+1/6*mTau5,mTau5))+1052*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau5}},1/2+1/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau5}},1/2+1/3*mTau5,mTau5))-2734/5*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau5}},5/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau5}},5/6*mTau5,mTau5))-31277/30*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau5}},1/2,mTau5))-1764/5*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau5}},1/2+1/2*mTau5,mTau5))-9379/30*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau5}},1/2,mTau5))-1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau5}},2/3,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau5}},2/3,mTau5))+1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau5}},5/6,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau5}},5/6,mTau5))+6207/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau5}},1/2*mTau5,mTau5))+7343/5*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau5}},1/2,mTau5))-4281/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau5}},1/2*mTau5,mTau5))+2541/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau5}},2/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau5}},2/3*mTau5,mTau5))+665*(-(Gt({{0,0},{0,0},{1,-1/3-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,1/3+2/3*mTau5}},1/2,mTau5))+462/5*(-(Gt({{0,0},{0,0},{1,-1/2-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,1/2+2/3*mTau5}},1/2,mTau5))-386267/30*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau5}},1/3,mTau5))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau5}},1/3,mTau5))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau5}},2/3,mTau5))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau5}},2/3,mTau5))+1338/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau5}},1/2,mTau5))+288/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau5}},2/3,mTau5))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau5}},2/3,mTau5))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau5}},1/6+1/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau5}},1/6+1/6*mTau5,mTau5))+168/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau5}},2/3+5/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau5}},2/3+5/6*mTau5,mTau5))-64911/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau5}},1/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau5}},1/6*mTau5,mTau5))-4737/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau5}},5/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau5}},5/6*mTau5,mTau5))-1579/10*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau5}},1/2*mTau5,mTau5))-165/2*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau5}},2/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau5}},2/3*mTau5,mTau5))+893/5*(-(Gt({{0,0},{0,0},{1,-1/3-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/3+5/6*mTau5}},1/2*mTau5,mTau5))-126*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau5}},1/2+1/2*mTau5,mTau5))+168/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau5}},1/2+2/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau5}},1/2+2/3*mTau5,mTau5))+406/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau5}},1/2*mTau5,mTau5))-6666/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau5}},1/2,mTau5))-41*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau5}},1/2+1/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau5}},1/2+1/3*mTau5,mTau5))+221/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau5}},1/2+1/2*mTau5,mTau5))-253/15*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau5}},1/2*mTau5,mTau5))-37841/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau5}},1/3,mTau5))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau5}},1/3,mTau5))+321817/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau5}},1/2,mTau5))-136121/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau5}},2/3,mTau5))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau5}},2/3,mTau5))+12277/25*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau5}},5/6,mTau5))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau5}},5/6,mTau5))-208783/12*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau5}},1/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau5}},1/6*mTau5,mTau5))+1078601/180*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau5}},1/2*mTau5,mTau5))-846/5*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau5}},5/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau5}},5/6*mTau5,mTau5))-13319/8*(-(Gt({{0,0},{0,0},{1,-1/6*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,1/6*mTau5}},1/2,mTau5))+8037/40*(-(Gt({{0,0},{0,0},{1,-1/6*mTau5}},5/6+2/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/6*mTau5}},5/6+2/3*mTau5,mTau5))-462/5*(-(Gt({{0,0},{0,0},{1,-1/3*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,1/3*mTau5}},1/2,mTau5))-755827/600*(-(Gt({{0,0},{0,0},{1,-1/2*mTau5}},5/6,mTau5))+Gt({{0,0},{0,0},{1,1/2*mTau5}},5/6,mTau5))-22841/10*(-(Gt({{0,0},{0,0},{1,-1/2*mTau5}},2/3+1/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2*mTau5}},2/3+1/6*mTau5,mTau5))-1371547/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau5}},5/6+1/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2*mTau5}},5/6+1/3*mTau5,mTau5))+969431/60*(-(Gt({{0,0},{0,0},{1,-1/2*mTau5}},5/6+1/2*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2*mTau5}},5/6+1/2*mTau5,mTau5))+20261/120*(-(Gt({{0,0},{0,0},{1,-1/2*mTau5}},1/6+2/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2*mTau5}},1/6+2/3*mTau5,mTau5))+577/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau5}},1/3+5/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2*mTau5}},1/3+5/6*mTau5,mTau5))+1639/15*(-(Gt({{0,0},{0,0},{1,-1/2*mTau5}},2/3+5/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2*mTau5}},2/3+5/6*mTau5,mTau5))-1011209/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau5}},5/6+5/6*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2*mTau5}},5/6+5/6*mTau5,mTau5))-11644/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau5}},1/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,1/2*mTau5}},1/3*mTau5,mTau5))+231/5*(-(Gt({{0,0},{0,0},{1,-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,2/3*mTau5}},1/2,mTau5))-70291/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau5}},1/2,mTau5))+Gt({{0,0},{0,0},{1,5/6*mTau5}},1/2,mTau5))+8037/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau5}},5/6+2/3*mTau5,mTau5))+Gt({{0,0},{0,0},{1,5/6*mTau5}},5/6+2/3*mTau5,mTau5))",
		"2197/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},5/6+5/6*mTau5,mTau5))+Gt({{0,0},{2,1/6}},5/6+5/6*mTau5,mTau5))-10409/15*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},1/2*mTau5,mTau5))+Gt({{0,0},{2,1/6}},1/2*mTau5,mTau5))-6591/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/6,mTau5))+Gt({{0,0},{2,1/3}},1/6,mTau5))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+1/3*mTau5,mTau5))+Gt({{0,0},{2,1/3}},2/3+1/3*mTau5,mTau5))+386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+2/3*mTau5,mTau5))+Gt({{0,0},{2,1/3}},2/3+2/3*mTau5,mTau5))+18621/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/2*mTau5,mTau5))+Gt({{0,0},{2,1/3}},1/2*mTau5,mTau5))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3*mTau5,mTau5))+Gt({{0,0},{2,1/3}},2/3*mTau5,mTau5))+665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau5}},1/2,mTau5))+Gt({{0,0},{2,1/6+1/6*mTau5}},1/2,mTau5))-893/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,1/6+1/6*mTau5}},1/2*mTau5,mTau5))+1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau5}},1/2,mTau5))+Gt({{0,0},{2,2/3+1/6*mTau5}},1/2,mTau5))-1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{2,2/3+1/6*mTau5}},1/2+1/2*mTau5,mTau5))+8141/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,2/3+1/6*mTau5}},1/2*mTau5,mTau5))+420*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau5}},2/3,mTau5))+Gt({{0,0},{2,5/6+1/6*mTau5}},2/3,mTau5))+1008/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau5}},5/6,mTau5))+Gt({{0,0},{2,5/6+1/6*mTau5}},5/6,mTau5))-231*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{2,5/6+1/6*mTau5}},1/2+1/2*mTau5,mTau5))+288/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau5}},1/6*mTau5,mTau5))+Gt({{0,0},{2,5/6+1/6*mTau5}},1/6*mTau5,mTau5))+1557/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,5/6+1/6*mTau5}},1/2*mTau5,mTau5))-280*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau5}},1/2,mTau5))+Gt({{0,0},{2,1/6+1/3*mTau5}},1/2,mTau5))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{2,1/6+1/3*mTau5}},1/2+1/2*mTau5,mTau5))-57739/48*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau5}},1/6*mTau5,mTau5))+Gt({{0,0},{2,1/6+1/3*mTau5}},1/6*mTau5,mTau5))+36031/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau5}},5/6*mTau5,mTau5))+Gt({{0,0},{2,1/6+1/3*mTau5}},5/6*mTau5,mTau5))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau5}},1/3,mTau5))+Gt({{0,0},{2,2/3+1/3*mTau5}},1/3,mTau5))-665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau5}},1/2,mTau5))+Gt({{0,0},{2,2/3+1/3*mTau5}},1/2,mTau5))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau5}},2/3,mTau5))+Gt({{0,0},{2,2/3+1/3*mTau5}},2/3,mTau5))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau5}},1/3+1/3*mTau5,mTau5))+Gt({{0,0},{2,2/3+1/3*mTau5}},1/3+1/3*mTau5,mTau5))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau5}},1/3*mTau5,mTau5))+Gt({{0,0},{2,2/3+1/3*mTau5}},1/3*mTau5,mTau5))+1127/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau5}},1/2,mTau5))+Gt({{0,0},{2,5/6+1/3*mTau5}},1/2,mTau5))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{2,5/6+1/3*mTau5}},1/2+1/2*mTau5,mTau5))-1045553/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau5}},1/3*mTau5,mTau5))+Gt({{0,0},{2,5/6+1/3*mTau5}},1/3*mTau5,mTau5))+231407/45*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,5/6+1/3*mTau5}},1/2*mTau5,mTau5))+22867/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau5}},1/2,mTau5))+Gt({{0,0},{2,1/6+1/2*mTau5}},1/2,mTau5))-6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau5}},2/3+1/2*mTau5,mTau5))+Gt({{0,0},{2,1/6+1/2*mTau5}},2/3+1/2*mTau5,mTau5))-72913/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau5}},1/2,mTau5))+Gt({{0,0},{2,1/3+1/2*mTau5}},1/2,mTau5))+4443/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{2,1/3+1/2*mTau5}},1/2+1/2*mTau5,mTau5))-188113/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau5}},1/3,mTau5))+Gt({{0,0},{2,1/2+1/2*mTau5}},1/3,mTau5))+1582769/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau5}},2/3,mTau5))+Gt({{0,0},{2,1/2+1/2*mTau5}},2/3,mTau5))-4665/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau5}},5/6,mTau5))+Gt({{0,0},{2,1/2+1/2*mTau5}},5/6,mTau5))+315*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau5}},1/2+1/6*mTau5,mTau5))+Gt({{0,0},{2,1/2+1/2*mTau5}},1/2+1/6*mTau5,mTau5))+526*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau5}},1/2+1/3*mTau5,mTau5))+Gt({{0,0},{2,1/2+1/2*mTau5}},1/2+1/3*mTau5,mTau5))-1367/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau5}},5/6*mTau5,mTau5))+Gt({{0,0},{2,1/2+1/2*mTau5}},5/6*mTau5,mTau5))-31277/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau5}},1/2,mTau5))+Gt({{0,0},{2,2/3+1/2*mTau5}},1/2,mTau5))-882/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{2,2/3+1/2*mTau5}},1/2+1/2*mTau5,mTau5))-9379/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau5}},1/2,mTau5))+Gt({{0,0},{2,5/6+1/2*mTau5}},1/2,mTau5))-756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau5}},2/3,mTau5))+Gt({{0,0},{2,5/6+1/2*mTau5}},2/3,mTau5))+756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau5}},5/6,mTau5))+Gt({{0,0},{2,5/6+1/2*mTau5}},5/6,mTau5))+6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,5/6+1/2*mTau5}},1/2*mTau5,mTau5))+7343/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{2,1/6+2/3*mTau5}},1/2,mTau5))-4281/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,1/6+2/3*mTau5}},1/2*mTau5,mTau5))+2541/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau5}},2/3*mTau5,mTau5))+Gt({{0,0},{2,1/6+2/3*mTau5}},2/3*mTau5,mTau5))+665/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{2,1/3+2/3*mTau5}},1/2,mTau5))+231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{2,1/2+2/3*mTau5}},1/2,mTau5))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau5}},1/3,mTau5))+Gt({{0,0},{2,2/3+2/3*mTau5}},1/3,mTau5))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau5}},2/3,mTau5))+Gt({{0,0},{2,2/3+2/3*mTau5}},2/3,mTau5))+669/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{2,5/6+2/3*mTau5}},1/2,mTau5))+144/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau5}},2/3,mTau5))+Gt({{0,0},{2,5/6+2/3*mTau5}},2/3,mTau5))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau5}},1/6+1/6*mTau5,mTau5))+Gt({{0,0},{2,5/6+2/3*mTau5}},1/6+1/6*mTau5,mTau5))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau5}},2/3+5/6*mTau5,mTau5))+Gt({{0,0},{2,5/6+2/3*mTau5}},2/3+5/6*mTau5,mTau5))-64911/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau5}},1/6*mTau5,mTau5))+Gt({{0,0},{2,5/6+2/3*mTau5}},1/6*mTau5,mTau5))-4737/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau5}},5/6*mTau5,mTau5))+Gt({{0,0},{2,5/6+2/3*mTau5}},5/6*mTau5,mTau5))-1579/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,1/6+5/6*mTau5}},1/2*mTau5,mTau5))-165/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau5}},2/3*mTau5,mTau5))+Gt({{0,0},{2,1/6+5/6*mTau5}},2/3*mTau5,mTau5))+893/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,1/3+5/6*mTau5}},1/2*mTau5,mTau5))-63*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{2,1/2+5/6*mTau5}},1/2+1/2*mTau5,mTau5))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau5}},1/2+2/3*mTau5,mTau5))+Gt({{0,0},{2,1/2+5/6*mTau5}},1/2+2/3*mTau5,mTau5))+203/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,1/2+5/6*mTau5}},1/2*mTau5,mTau5))-3333/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau5}},1/2,mTau5))+Gt({{0,0},{2,2/3+5/6*mTau5}},1/2,mTau5))-41/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau5}},1/2+1/3*mTau5,mTau5))+Gt({{0,0},{2,2/3+5/6*mTau5}},1/2+1/3*mTau5,mTau5))+221/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{0,0},{2,2/3+5/6*mTau5}},1/2+1/2*mTau5,mTau5))-253/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,2/3+5/6*mTau5}},1/2*mTau5,mTau5))-37841/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau5}},1/3,mTau5))+Gt({{0,0},{2,5/6+5/6*mTau5}},1/3,mTau5))+321817/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau5}},1/2,mTau5))+Gt({{0,0},{2,5/6+5/6*mTau5}},1/2,mTau5))-136121/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau5}},2/3,mTau5))+Gt({{0,0},{2,5/6+5/6*mTau5}},2/3,mTau5))+12277/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau5}},5/6,mTau5))+Gt({{0,0},{2,5/6+5/6*mTau5}},5/6,mTau5))-208783/24*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau5}},1/6*mTau5,mTau5))+Gt({{0,0},{2,5/6+5/6*mTau5}},1/6*mTau5,mTau5))+1078601/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{0,0},{2,5/6+5/6*mTau5}},1/2*mTau5,mTau5))-423/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau5}},5/6*mTau5,mTau5))+Gt({{0,0},{2,5/6+5/6*mTau5}},5/6*mTau5,mTau5))-13319/16*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau5}},1/2,mTau5))+Gt({{0,0},{2,1/6*mTau5}},1/2,mTau5))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau5}},5/6+2/3*mTau5,mTau5))+Gt({{0,0},{2,1/6*mTau5}},5/6+2/3*mTau5,mTau5))-231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3*mTau5}},1/2,mTau5))+Gt({{0,0},{2,1/3*mTau5}},1/2,mTau5))-755827/1200*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau5}},5/6,mTau5))+Gt({{0,0},{2,1/2*mTau5}},5/6,mTau5))-22841/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau5}},2/3+1/6*mTau5,mTau5))+Gt({{0,0},{2,1/2*mTau5}},2/3+1/6*mTau5,mTau5))-1371547/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau5}},5/6+1/3*mTau5,mTau5))+Gt({{0,0},{2,1/2*mTau5}},5/6+1/3*mTau5,mTau5))+969431/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau5}},5/6+1/2*mTau5,mTau5))+Gt({{0,0},{2,1/2*mTau5}},5/6+1/2*mTau5,mTau5))+20261/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau5}},1/6+2/3*mTau5,mTau5))+Gt({{0,0},{2,1/2*mTau5}},1/6+2/3*mTau5,mTau5))+577/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau5}},1/3+5/6*mTau5,mTau5))+Gt({{0,0},{2,1/2*mTau5}},1/3+5/6*mTau5,mTau5))+1639/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau5}},2/3+5/6*mTau5,mTau5))+Gt({{0,0},{2,1/2*mTau5}},2/3+5/6*mTau5,mTau5))-1011209/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau5}},5/6+5/6*mTau5,mTau5))+Gt({{0,0},{2,1/2*mTau5}},5/6+5/6*mTau5,mTau5))-5822/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau5}},1/3*mTau5,mTau5))+Gt({{0,0},{2,1/2*mTau5}},1/3*mTau5,mTau5))+231/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3*mTau5}},1/2,mTau5))+Gt({{0,0},{2,2/3*mTau5}},1/2,mTau5))-70291/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau5}},1/2,mTau5))+Gt({{0,0},{2,5/6*mTau5}},1/2,mTau5))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau5}},5/6+2/3*mTau5,mTau5))+Gt({{0,0},{2,5/6*mTau5}},5/6+2/3*mTau5,mTau5))",
		"2197/300*(pow(Pi,-2))*(-(Gt({{3,-1/6}},5/6+5/6*mTau5,mTau5))+Gt({{3,1/6}},5/6+5/6*mTau5,mTau5))-10409/90*(pow(Pi,-2))*(-(Gt({{3,-1/6}},1/2*mTau5,mTau5))+Gt({{3,1/6}},1/2*mTau5,mTau5))-2197/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/6,mTau5))+Gt({{3,1/3}},1/6,mTau5))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+1/3*mTau5,mTau5))+Gt({{3,1/3}},2/3+1/3*mTau5,mTau5))+386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+2/3*mTau5,mTau5))+Gt({{3,1/3}},2/3+2/3*mTau5,mTau5))+6207/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/2*mTau5,mTau5))+Gt({{3,1/3}},1/2*mTau5,mTau5))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3*mTau5,mTau5))+Gt({{3,1/3}},2/3*mTau5,mTau5))+665/6*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau5}},1/2,mTau5))+Gt({{3,1/6+1/6*mTau5}},1/2,mTau5))-893/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau5}},1/2*mTau5,mTau5))+Gt({{3,1/6+1/6*mTau5}},1/2*mTau5,mTau5))+1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau5}},1/2,mTau5))+Gt({{3,2/3+1/6*mTau5}},1/2,mTau5))-1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{3,2/3+1/6*mTau5}},1/2+1/2*mTau5,mTau5))+8141/120*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau5}},1/2*mTau5,mTau5))+Gt({{3,2/3+1/6*mTau5}},1/2*mTau5,mTau5))+70*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau5}},2/3,mTau5))+Gt({{3,5/6+1/6*mTau5}},2/3,mTau5))+168/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau5}},5/6,mTau5))+Gt({{3,5/6+1/6*mTau5}},5/6,mTau5))-77/2*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{3,5/6+1/6*mTau5}},1/2+1/2*mTau5,mTau5))+48/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau5}},1/6*mTau5,mTau5))+Gt({{3,5/6+1/6*mTau5}},1/6*mTau5,mTau5))+519/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau5}},1/2*mTau5,mTau5))+Gt({{3,5/6+1/6*mTau5}},1/2*mTau5,mTau5))-140/3*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau5}},1/2,mTau5))+Gt({{3,1/6+1/3*mTau5}},1/2,mTau5))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{3,1/6+1/3*mTau5}},1/2+1/2*mTau5,mTau5))-57739/288*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau5}},1/6*mTau5,mTau5))+Gt({{3,1/6+1/3*mTau5}},1/6*mTau5,mTau5))+36031/1440*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau5}},5/6*mTau5,mTau5))+Gt({{3,1/6+1/3*mTau5}},5/6*mTau5,mTau5))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau5}},1/3,mTau5))+Gt({{3,2/3+1/3*mTau5}},1/3,mTau5))-665/6*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau5}},1/2,mTau5))+Gt({{3,2/3+1/3*mTau5}},1/2,mTau5))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau5}},2/3,mTau5))+Gt({{3,2/3+1/3*mTau5}},2/3,mTau5))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau5}},1/3+1/3*mTau5,mTau5))+Gt({{3,2/3+1/3*mTau5}},1/3+1/3*mTau5,mTau5))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau5}},1/3*mTau5,mTau5))+Gt({{3,2/3+1/3*mTau5}},1/3*mTau5,mTau5))+1127/60*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau5}},1/2,mTau5))+Gt({{3,5/6+1/3*mTau5}},1/2,mTau5))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{3,5/6+1/3*mTau5}},1/2+1/2*mTau5,mTau5))-1045553/720*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau5}},1/3*mTau5,mTau5))+Gt({{3,5/6+1/3*mTau5}},1/3*mTau5,mTau5))+231407/270*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau5}},1/2*mTau5,mTau5))+Gt({{3,5/6+1/3*mTau5}},1/2*mTau5,mTau5))+22867/360*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau5}},1/2,mTau5))+Gt({{3,1/6+1/2*mTau5}},1/2,mTau5))-2069/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau5}},2/3+1/2*mTau5,mTau5))+Gt({{3,1/6+1/2*mTau5}},2/3+1/2*mTau5,mTau5))-72913/360*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau5}},1/2,mTau5))+Gt({{3,1/3+1/2*mTau5}},1/2,mTau5))+1481/20*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{3,1/3+1/2*mTau5}},1/2+1/2*mTau5,mTau5))-188113/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau5}},1/3,mTau5))+Gt({{3,1/2+1/2*mTau5}},1/3,mTau5))+1582769/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau5}},2/3,mTau5))+Gt({{3,1/2+1/2*mTau5}},2/3,mTau5))-1555/8*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau5}},5/6,mTau5))+Gt({{3,1/2+1/2*mTau5}},5/6,mTau5))+105/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau5}},1/2+1/6*mTau5,mTau5))+Gt({{3,1/2+1/2*mTau5}},1/2+1/6*mTau5,mTau5))+263/3*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau5}},1/2+1/3*mTau5,mTau5))+Gt({{3,1/2+1/2*mTau5}},1/2+1/3*mTau5,mTau5))-1367/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau5}},5/6*mTau5,mTau5))+Gt({{3,1/2+1/2*mTau5}},5/6*mTau5,mTau5))-31277/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau5}},1/2,mTau5))+Gt({{3,2/3+1/2*mTau5}},1/2,mTau5))-147/5*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{3,2/3+1/2*mTau5}},1/2+1/2*mTau5,mTau5))-9379/360*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau5}},1/2,mTau5))+Gt({{3,5/6+1/2*mTau5}},1/2,mTau5))-126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau5}},2/3,mTau5))+Gt({{3,5/6+1/2*mTau5}},2/3,mTau5))+126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau5}},5/6,mTau5))+Gt({{3,5/6+1/2*mTau5}},5/6,mTau5))+2069/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau5}},1/2*mTau5,mTau5))+Gt({{3,5/6+1/2*mTau5}},1/2*mTau5,mTau5))+7343/60*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau5}},1/2,mTau5))+Gt({{3,1/6+2/3*mTau5}},1/2,mTau5))-1427/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau5}},1/2*mTau5,mTau5))+Gt({{3,1/6+2/3*mTau5}},1/2*mTau5,mTau5))+847/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau5}},2/3*mTau5,mTau5))+Gt({{3,1/6+2/3*mTau5}},2/3*mTau5,mTau5))+665/12*(pow(Pi,-2))*(-(Gt({{3,-1/3-2/3*mTau5}},1/2,mTau5))+Gt({{3,1/3+2/3*mTau5}},1/2,mTau5))+77/10*(pow(Pi,-2))*(-(Gt({{3,-1/2-2/3*mTau5}},1/2,mTau5))+Gt({{3,1/2+2/3*mTau5}},1/2,mTau5))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau5}},1/3,mTau5))+Gt({{3,2/3+2/3*mTau5}},1/3,mTau5))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau5}},2/3,mTau5))+Gt({{3,2/3+2/3*mTau5}},2/3,mTau5))+223/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau5}},1/2,mTau5))+Gt({{3,5/6+2/3*mTau5}},1/2,mTau5))+24/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau5}},2/3,mTau5))+Gt({{3,5/6+2/3*mTau5}},2/3,mTau5))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau5}},1/6+1/6*mTau5,mTau5))+Gt({{3,5/6+2/3*mTau5}},1/6+1/6*mTau5,mTau5))+14/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau5}},2/3+5/6*mTau5,mTau5))+Gt({{3,5/6+2/3*mTau5}},2/3+5/6*mTau5,mTau5))-21637/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau5}},1/6*mTau5,mTau5))+Gt({{3,5/6+2/3*mTau5}},1/6*mTau5,mTau5))-1579/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau5}},5/6*mTau5,mTau5))+Gt({{3,5/6+2/3*mTau5}},5/6*mTau5,mTau5))-1579/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{3,1/6+5/6*mTau5}},1/2*mTau5,mTau5))-55/8*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau5}},2/3*mTau5,mTau5))+Gt({{3,1/6+5/6*mTau5}},2/3*mTau5,mTau5))+893/60*(pow(Pi,-2))*(-(Gt({{3,-1/3-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{3,1/3+5/6*mTau5}},1/2*mTau5,mTau5))-21/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{3,1/2+5/6*mTau5}},1/2+1/2*mTau5,mTau5))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau5}},1/2+2/3*mTau5,mTau5))+Gt({{3,1/2+5/6*mTau5}},1/2+2/3*mTau5,mTau5))+203/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{3,1/2+5/6*mTau5}},1/2*mTau5,mTau5))-1111/10*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau5}},1/2,mTau5))+Gt({{3,2/3+5/6*mTau5}},1/2,mTau5))-41/12*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau5}},1/2+1/3*mTau5,mTau5))+Gt({{3,2/3+5/6*mTau5}},1/2+1/3*mTau5,mTau5))+221/60*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau5}},1/2+1/2*mTau5,mTau5))+Gt({{3,2/3+5/6*mTau5}},1/2+1/2*mTau5,mTau5))-253/180*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{3,2/3+5/6*mTau5}},1/2*mTau5,mTau5))-37841/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau5}},1/3,mTau5))+Gt({{3,5/6+5/6*mTau5}},1/3,mTau5))+321817/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau5}},1/2,mTau5))+Gt({{3,5/6+5/6*mTau5}},1/2,mTau5))-136121/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau5}},2/3,mTau5))+Gt({{3,5/6+5/6*mTau5}},2/3,mTau5))+12277/300*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau5}},5/6,mTau5))+Gt({{3,5/6+5/6*mTau5}},5/6,mTau5))-208783/144*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau5}},1/6*mTau5,mTau5))+Gt({{3,5/6+5/6*mTau5}},1/6*mTau5,mTau5))+1078601/2160*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau5}},1/2*mTau5,mTau5))+Gt({{3,5/6+5/6*mTau5}},1/2*mTau5,mTau5))-141/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau5}},5/6*mTau5,mTau5))+Gt({{3,5/6+5/6*mTau5}},5/6*mTau5,mTau5))-13319/96*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau5}},1/2,mTau5))+Gt({{3,1/6*mTau5}},1/2,mTau5))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau5}},5/6+2/3*mTau5,mTau5))+Gt({{3,1/6*mTau5}},5/6+2/3*mTau5,mTau5))-77/10*(pow(Pi,-2))*(-(Gt({{3,-1/3*mTau5}},1/2,mTau5))+Gt({{3,1/3*mTau5}},1/2,mTau5))-755827/7200*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau5}},5/6,mTau5))+Gt({{3,1/2*mTau5}},5/6,mTau5))-22841/120*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau5}},2/3+1/6*mTau5,mTau5))+Gt({{3,1/2*mTau5}},2/3+1/6*mTau5,mTau5))-1371547/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau5}},5/6+1/3*mTau5,mTau5))+Gt({{3,1/2*mTau5}},5/6+1/3*mTau5,mTau5))+969431/720*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau5}},5/6+1/2*mTau5,mTau5))+Gt({{3,1/2*mTau5}},5/6+1/2*mTau5,mTau5))+20261/1440*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau5}},1/6+2/3*mTau5,mTau5))+Gt({{3,1/2*mTau5}},1/6+2/3*mTau5,mTau5))+577/60*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau5}},1/3+5/6*mTau5,mTau5))+Gt({{3,1/2*mTau5}},1/3+5/6*mTau5,mTau5))+1639/180*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau5}},2/3+5/6*mTau5,mTau5))+Gt({{3,1/2*mTau5}},2/3+5/6*mTau5,mTau5))-1011209/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau5}},5/6+5/6*mTau5,mTau5))+Gt({{3,1/2*mTau5}},5/6+5/6*mTau5,mTau5))-2911/15*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau5}},1/3*mTau5,mTau5))+Gt({{3,1/2*mTau5}},1/3*mTau5,mTau5))+77/20*(pow(Pi,-2))*(-(Gt({{3,-2/3*mTau5}},1/2,mTau5))+Gt({{3,2/3*mTau5}},1/2,mTau5))-70291/480*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau5}},1/2,mTau5))+Gt({{3,5/6*mTau5}},1/2,mTau5))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau5}},5/6+2/3*mTau5,mTau5))+Gt({{3,5/6*mTau5}},5/6+2/3*mTau5,mTau5))",
		"2197/25*(-(Gt({{0,0},{0,0},{1,-1/6}},5/6+5/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6}},5/6+5/6*mTau6,mTau6))-20818/15*(-(Gt({{0,0},{0,0},{1,-1/6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6}},1/2*mTau6,mTau6))-6591/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/6,mTau6))+Gt({{0,0},{0,0},{1,1/3}},1/6,mTau6))-386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+1/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/3}},2/3+1/3*mTau6,mTau6))+386267/30*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3+2/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/3}},2/3+2/3*mTau6,mTau6))+18621/10*(-(Gt({{0,0},{0,0},{1,-1/3}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/3}},1/2*mTau6,mTau6))-386267/60*(-(Gt({{0,0},{0,0},{1,-1/3}},2/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/3}},2/3*mTau6,mTau6))+1330*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau6}},1/2,mTau6))-893/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6+1/6*mTau6}},1/2*mTau6,mTau6))+1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau6}},1/2,mTau6))-1271/2*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau6}},1/2+1/2*mTau6,mTau6))+8141/10*(-(Gt({{0,0},{0,0},{1,-2/3-1/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/6*mTau6}},1/2*mTau6,mTau6))+840*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau6}},2/3,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau6}},2/3,mTau6))+2016/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau6}},5/6,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau6}},5/6,mTau6))-462*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau6}},1/2+1/2*mTau6,mTau6))+576/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau6}},1/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau6}},1/6*mTau6,mTau6))+1557/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/6*mTau6}},1/2*mTau6,mTau6))-560*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau6}},1/2,mTau6))+168/5*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau6}},1/2+1/2*mTau6,mTau6))-57739/24*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau6}},1/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau6}},1/6*mTau6,mTau6))+36031/120*(-(Gt({{0,0},{0,0},{1,-1/6-1/3*mTau6}},5/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6+1/3*mTau6}},5/6*mTau6,mTau6))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau6}},1/3,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau6}},1/3,mTau6))-1330*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau6}},1/2,mTau6))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau6}},2/3,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau6}},2/3,mTau6))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau6}},1/3+1/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau6}},1/3+1/3*mTau6,mTau6))-386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-1/3*mTau6}},1/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/3*mTau6}},1/3*mTau6,mTau6))+1127/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau6}},1/2,mTau6))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau6}},1/2+1/2*mTau6,mTau6))-1045553/60*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau6}},1/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau6}},1/3*mTau6,mTau6))+462814/45*(-(Gt({{0,0},{0,0},{1,-5/6-1/3*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/3*mTau6}},1/2*mTau6,mTau6))+22867/30*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau6}},1/2,mTau6))-6207/10*(-(Gt({{0,0},{0,0},{1,-1/6-1/2*mTau6}},2/3+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6+1/2*mTau6}},2/3+1/2*mTau6,mTau6))-72913/30*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau6}},1/2,mTau6))+4443/5*(-(Gt({{0,0},{0,0},{1,-1/3-1/2*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/3+1/2*mTau6}},1/2+1/2*mTau6,mTau6))-188113/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau6}},1/3,mTau6))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau6}},1/3,mTau6))+1582769/900*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau6}},2/3,mTau6))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau6}},2/3,mTau6))-4665/2*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau6}},5/6,mTau6))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau6}},5/6,mTau6))+630*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau6}},1/2+1/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau6}},1/2+1/6*mTau6,mTau6))+1052*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau6}},1/2+1/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau6}},1/2+1/3*mTau6,mTau6))-2734/5*(-(Gt({{0,0},{0,0},{1,-1/2-1/2*mTau6}},5/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2+1/2*mTau6}},5/6*mTau6,mTau6))-31277/30*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau6}},1/2,mTau6))-1764/5*(-(Gt({{0,0},{0,0},{1,-2/3-1/2*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,2/3+1/2*mTau6}},1/2+1/2*mTau6,mTau6))-9379/30*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau6}},1/2,mTau6))-1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau6}},2/3,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau6}},2/3,mTau6))+1512/5*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau6}},5/6,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau6}},5/6,mTau6))+6207/10*(-(Gt({{0,0},{0,0},{1,-5/6-1/2*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+1/2*mTau6}},1/2*mTau6,mTau6))+7343/5*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau6}},1/2,mTau6))-4281/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau6}},1/2*mTau6,mTau6))+2541/10*(-(Gt({{0,0},{0,0},{1,-1/6-2/3*mTau6}},2/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6+2/3*mTau6}},2/3*mTau6,mTau6))+665*(-(Gt({{0,0},{0,0},{1,-1/3-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,1/3+2/3*mTau6}},1/2,mTau6))+462/5*(-(Gt({{0,0},{0,0},{1,-1/2-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,1/2+2/3*mTau6}},1/2,mTau6))-386267/30*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau6}},1/3,mTau6))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau6}},1/3,mTau6))+386267/60*(-(Gt({{0,0},{0,0},{1,-2/3-2/3*mTau6}},2/3,mTau6))+Gt({{0,0},{0,0},{1,2/3+2/3*mTau6}},2/3,mTau6))+1338/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau6}},1/2,mTau6))+288/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau6}},2/3,mTau6))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau6}},2/3,mTau6))+6216/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau6}},1/6+1/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau6}},1/6+1/6*mTau6,mTau6))+168/5*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau6}},2/3+5/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau6}},2/3+5/6*mTau6,mTau6))-64911/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau6}},1/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau6}},1/6*mTau6,mTau6))-4737/40*(-(Gt({{0,0},{0,0},{1,-5/6-2/3*mTau6}},5/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+2/3*mTau6}},5/6*mTau6,mTau6))-1579/10*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau6}},1/2*mTau6,mTau6))-165/2*(-(Gt({{0,0},{0,0},{1,-1/6-5/6*mTau6}},2/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6+5/6*mTau6}},2/3*mTau6,mTau6))+893/5*(-(Gt({{0,0},{0,0},{1,-1/3-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/3+5/6*mTau6}},1/2*mTau6,mTau6))-126*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau6}},1/2+1/2*mTau6,mTau6))+168/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau6}},1/2+2/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau6}},1/2+2/3*mTau6,mTau6))+406/5*(-(Gt({{0,0},{0,0},{1,-1/2-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2+5/6*mTau6}},1/2*mTau6,mTau6))-6666/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau6}},1/2,mTau6))-41*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau6}},1/2+1/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau6}},1/2+1/3*mTau6,mTau6))+221/5*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau6}},1/2+1/2*mTau6,mTau6))-253/15*(-(Gt({{0,0},{0,0},{1,-2/3-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,2/3+5/6*mTau6}},1/2*mTau6,mTau6))-37841/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau6}},1/3,mTau6))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau6}},1/3,mTau6))+321817/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau6}},1/2,mTau6))-136121/225*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau6}},2/3,mTau6))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau6}},2/3,mTau6))+12277/25*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau6}},5/6,mTau6))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau6}},5/6,mTau6))-208783/12*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau6}},1/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau6}},1/6*mTau6,mTau6))+1078601/180*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau6}},1/2*mTau6,mTau6))-846/5*(-(Gt({{0,0},{0,0},{1,-5/6-5/6*mTau6}},5/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6+5/6*mTau6}},5/6*mTau6,mTau6))-13319/8*(-(Gt({{0,0},{0,0},{1,-1/6*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,1/6*mTau6}},1/2,mTau6))+8037/40*(-(Gt({{0,0},{0,0},{1,-1/6*mTau6}},5/6+2/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/6*mTau6}},5/6+2/3*mTau6,mTau6))-462/5*(-(Gt({{0,0},{0,0},{1,-1/3*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,1/3*mTau6}},1/2,mTau6))-755827/600*(-(Gt({{0,0},{0,0},{1,-1/2*mTau6}},5/6,mTau6))+Gt({{0,0},{0,0},{1,1/2*mTau6}},5/6,mTau6))-22841/10*(-(Gt({{0,0},{0,0},{1,-1/2*mTau6}},2/3+1/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2*mTau6}},2/3+1/6*mTau6,mTau6))-1371547/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau6}},5/6+1/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2*mTau6}},5/6+1/3*mTau6,mTau6))+969431/60*(-(Gt({{0,0},{0,0},{1,-1/2*mTau6}},5/6+1/2*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2*mTau6}},5/6+1/2*mTau6,mTau6))+20261/120*(-(Gt({{0,0},{0,0},{1,-1/2*mTau6}},1/6+2/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2*mTau6}},1/6+2/3*mTau6,mTau6))+577/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau6}},1/3+5/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2*mTau6}},1/3+5/6*mTau6,mTau6))+1639/15*(-(Gt({{0,0},{0,0},{1,-1/2*mTau6}},2/3+5/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2*mTau6}},2/3+5/6*mTau6,mTau6))-1011209/180*(-(Gt({{0,0},{0,0},{1,-1/2*mTau6}},5/6+5/6*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2*mTau6}},5/6+5/6*mTau6,mTau6))-11644/5*(-(Gt({{0,0},{0,0},{1,-1/2*mTau6}},1/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,1/2*mTau6}},1/3*mTau6,mTau6))+231/5*(-(Gt({{0,0},{0,0},{1,-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,2/3*mTau6}},1/2,mTau6))-70291/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau6}},1/2,mTau6))+Gt({{0,0},{0,0},{1,5/6*mTau6}},1/2,mTau6))+8037/40*(-(Gt({{0,0},{0,0},{1,-5/6*mTau6}},5/6+2/3*mTau6,mTau6))+Gt({{0,0},{0,0},{1,5/6*mTau6}},5/6+2/3*mTau6,mTau6))",
		"2197/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},5/6+5/6*mTau6,mTau6))+Gt({{0,0},{2,1/6}},5/6+5/6*mTau6,mTau6))-10409/15*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,1/6}},1/2*mTau6,mTau6))-6591/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/6,mTau6))+Gt({{0,0},{2,1/3}},1/6,mTau6))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+1/3*mTau6,mTau6))+Gt({{0,0},{2,1/3}},2/3+1/3*mTau6,mTau6))+386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3+2/3*mTau6,mTau6))+Gt({{0,0},{2,1/3}},2/3+2/3*mTau6,mTau6))+18621/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},1/2*mTau6,mTau6))+Gt({{0,0},{2,1/3}},1/2*mTau6,mTau6))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3}},2/3*mTau6,mTau6))+Gt({{0,0},{2,1/3}},2/3*mTau6,mTau6))+665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau6}},1/2,mTau6))+Gt({{0,0},{2,1/6+1/6*mTau6}},1/2,mTau6))-893/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,1/6+1/6*mTau6}},1/2*mTau6,mTau6))+1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau6}},1/2,mTau6))+Gt({{0,0},{2,2/3+1/6*mTau6}},1/2,mTau6))-1271/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{2,2/3+1/6*mTau6}},1/2+1/2*mTau6,mTau6))+8141/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,2/3+1/6*mTau6}},1/2*mTau6,mTau6))+420*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau6}},2/3,mTau6))+Gt({{0,0},{2,5/6+1/6*mTau6}},2/3,mTau6))+1008/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau6}},5/6,mTau6))+Gt({{0,0},{2,5/6+1/6*mTau6}},5/6,mTau6))-231*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{2,5/6+1/6*mTau6}},1/2+1/2*mTau6,mTau6))+288/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau6}},1/6*mTau6,mTau6))+Gt({{0,0},{2,5/6+1/6*mTau6}},1/6*mTau6,mTau6))+1557/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,5/6+1/6*mTau6}},1/2*mTau6,mTau6))-280*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau6}},1/2,mTau6))+Gt({{0,0},{2,1/6+1/3*mTau6}},1/2,mTau6))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{2,1/6+1/3*mTau6}},1/2+1/2*mTau6,mTau6))-57739/48*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau6}},1/6*mTau6,mTau6))+Gt({{0,0},{2,1/6+1/3*mTau6}},1/6*mTau6,mTau6))+36031/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/3*mTau6}},5/6*mTau6,mTau6))+Gt({{0,0},{2,1/6+1/3*mTau6}},5/6*mTau6,mTau6))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau6}},1/3,mTau6))+Gt({{0,0},{2,2/3+1/3*mTau6}},1/3,mTau6))-665*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau6}},1/2,mTau6))+Gt({{0,0},{2,2/3+1/3*mTau6}},1/2,mTau6))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau6}},2/3,mTau6))+Gt({{0,0},{2,2/3+1/3*mTau6}},2/3,mTau6))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau6}},1/3+1/3*mTau6,mTau6))+Gt({{0,0},{2,2/3+1/3*mTau6}},1/3+1/3*mTau6,mTau6))-386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/3*mTau6}},1/3*mTau6,mTau6))+Gt({{0,0},{2,2/3+1/3*mTau6}},1/3*mTau6,mTau6))+1127/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau6}},1/2,mTau6))+Gt({{0,0},{2,5/6+1/3*mTau6}},1/2,mTau6))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{2,5/6+1/3*mTau6}},1/2+1/2*mTau6,mTau6))-1045553/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau6}},1/3*mTau6,mTau6))+Gt({{0,0},{2,5/6+1/3*mTau6}},1/3*mTau6,mTau6))+231407/45*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/3*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,5/6+1/3*mTau6}},1/2*mTau6,mTau6))+22867/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau6}},1/2,mTau6))+Gt({{0,0},{2,1/6+1/2*mTau6}},1/2,mTau6))-6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-1/2*mTau6}},2/3+1/2*mTau6,mTau6))+Gt({{0,0},{2,1/6+1/2*mTau6}},2/3+1/2*mTau6,mTau6))-72913/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau6}},1/2,mTau6))+Gt({{0,0},{2,1/3+1/2*mTau6}},1/2,mTau6))+4443/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-1/2*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{2,1/3+1/2*mTau6}},1/2+1/2*mTau6,mTau6))-188113/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau6}},1/3,mTau6))+Gt({{0,0},{2,1/2+1/2*mTau6}},1/3,mTau6))+1582769/1800*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau6}},2/3,mTau6))+Gt({{0,0},{2,1/2+1/2*mTau6}},2/3,mTau6))-4665/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau6}},5/6,mTau6))+Gt({{0,0},{2,1/2+1/2*mTau6}},5/6,mTau6))+315*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau6}},1/2+1/6*mTau6,mTau6))+Gt({{0,0},{2,1/2+1/2*mTau6}},1/2+1/6*mTau6,mTau6))+526*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau6}},1/2+1/3*mTau6,mTau6))+Gt({{0,0},{2,1/2+1/2*mTau6}},1/2+1/3*mTau6,mTau6))-1367/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-1/2*mTau6}},5/6*mTau6,mTau6))+Gt({{0,0},{2,1/2+1/2*mTau6}},5/6*mTau6,mTau6))-31277/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau6}},1/2,mTau6))+Gt({{0,0},{2,2/3+1/2*mTau6}},1/2,mTau6))-882/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-1/2*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{2,2/3+1/2*mTau6}},1/2+1/2*mTau6,mTau6))-9379/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau6}},1/2,mTau6))+Gt({{0,0},{2,5/6+1/2*mTau6}},1/2,mTau6))-756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau6}},2/3,mTau6))+Gt({{0,0},{2,5/6+1/2*mTau6}},2/3,mTau6))+756/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau6}},5/6,mTau6))+Gt({{0,0},{2,5/6+1/2*mTau6}},5/6,mTau6))+6207/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-1/2*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,5/6+1/2*mTau6}},1/2*mTau6,mTau6))+7343/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{2,1/6+2/3*mTau6}},1/2,mTau6))-4281/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,1/6+2/3*mTau6}},1/2*mTau6,mTau6))+2541/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-2/3*mTau6}},2/3*mTau6,mTau6))+Gt({{0,0},{2,1/6+2/3*mTau6}},2/3*mTau6,mTau6))+665/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{2,1/3+2/3*mTau6}},1/2,mTau6))+231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{2,1/2+2/3*mTau6}},1/2,mTau6))-386267/60*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau6}},1/3,mTau6))+Gt({{0,0},{2,2/3+2/3*mTau6}},1/3,mTau6))+386267/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-2/3*mTau6}},2/3,mTau6))+Gt({{0,0},{2,2/3+2/3*mTau6}},2/3,mTau6))+669/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{2,5/6+2/3*mTau6}},1/2,mTau6))+144/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau6}},2/3,mTau6))+Gt({{0,0},{2,5/6+2/3*mTau6}},2/3,mTau6))+3108/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau6}},1/6+1/6*mTau6,mTau6))+Gt({{0,0},{2,5/6+2/3*mTau6}},1/6+1/6*mTau6,mTau6))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau6}},2/3+5/6*mTau6,mTau6))+Gt({{0,0},{2,5/6+2/3*mTau6}},2/3+5/6*mTau6,mTau6))-64911/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau6}},1/6*mTau6,mTau6))+Gt({{0,0},{2,5/6+2/3*mTau6}},1/6*mTau6,mTau6))-4737/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-2/3*mTau6}},5/6*mTau6,mTau6))+Gt({{0,0},{2,5/6+2/3*mTau6}},5/6*mTau6,mTau6))-1579/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,1/6+5/6*mTau6}},1/2*mTau6,mTau6))-165/4*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6-5/6*mTau6}},2/3*mTau6,mTau6))+Gt({{0,0},{2,1/6+5/6*mTau6}},2/3*mTau6,mTau6))+893/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,1/3+5/6*mTau6}},1/2*mTau6,mTau6))-63*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{2,1/2+5/6*mTau6}},1/2+1/2*mTau6,mTau6))+84/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau6}},1/2+2/3*mTau6,mTau6))+Gt({{0,0},{2,1/2+5/6*mTau6}},1/2+2/3*mTau6,mTau6))+203/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,1/2+5/6*mTau6}},1/2*mTau6,mTau6))-3333/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau6}},1/2,mTau6))+Gt({{0,0},{2,2/3+5/6*mTau6}},1/2,mTau6))-41/2*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau6}},1/2+1/3*mTau6,mTau6))+Gt({{0,0},{2,2/3+5/6*mTau6}},1/2+1/3*mTau6,mTau6))+221/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{0,0},{2,2/3+5/6*mTau6}},1/2+1/2*mTau6,mTau6))-253/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,2/3+5/6*mTau6}},1/2*mTau6,mTau6))-37841/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau6}},1/3,mTau6))+Gt({{0,0},{2,5/6+5/6*mTau6}},1/3,mTau6))+321817/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau6}},1/2,mTau6))+Gt({{0,0},{2,5/6+5/6*mTau6}},1/2,mTau6))-136121/450*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau6}},2/3,mTau6))+Gt({{0,0},{2,5/6+5/6*mTau6}},2/3,mTau6))+12277/50*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau6}},5/6,mTau6))+Gt({{0,0},{2,5/6+5/6*mTau6}},5/6,mTau6))-208783/24*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau6}},1/6*mTau6,mTau6))+Gt({{0,0},{2,5/6+5/6*mTau6}},1/6*mTau6,mTau6))+1078601/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{0,0},{2,5/6+5/6*mTau6}},1/2*mTau6,mTau6))-423/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6-5/6*mTau6}},5/6*mTau6,mTau6))+Gt({{0,0},{2,5/6+5/6*mTau6}},5/6*mTau6,mTau6))-13319/16*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau6}},1/2,mTau6))+Gt({{0,0},{2,1/6*mTau6}},1/2,mTau6))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/6*mTau6}},5/6+2/3*mTau6,mTau6))+Gt({{0,0},{2,1/6*mTau6}},5/6+2/3*mTau6,mTau6))-231/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/3*mTau6}},1/2,mTau6))+Gt({{0,0},{2,1/3*mTau6}},1/2,mTau6))-755827/1200*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau6}},5/6,mTau6))+Gt({{0,0},{2,1/2*mTau6}},5/6,mTau6))-22841/20*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau6}},2/3+1/6*mTau6,mTau6))+Gt({{0,0},{2,1/2*mTau6}},2/3+1/6*mTau6,mTau6))-1371547/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau6}},5/6+1/3*mTau6,mTau6))+Gt({{0,0},{2,1/2*mTau6}},5/6+1/3*mTau6,mTau6))+969431/120*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau6}},5/6+1/2*mTau6,mTau6))+Gt({{0,0},{2,1/2*mTau6}},5/6+1/2*mTau6,mTau6))+20261/240*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau6}},1/6+2/3*mTau6,mTau6))+Gt({{0,0},{2,1/2*mTau6}},1/6+2/3*mTau6,mTau6))+577/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau6}},1/3+5/6*mTau6,mTau6))+Gt({{0,0},{2,1/2*mTau6}},1/3+5/6*mTau6,mTau6))+1639/30*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau6}},2/3+5/6*mTau6,mTau6))+Gt({{0,0},{2,1/2*mTau6}},2/3+5/6*mTau6,mTau6))-1011209/360*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau6}},5/6+5/6*mTau6,mTau6))+Gt({{0,0},{2,1/2*mTau6}},5/6+5/6*mTau6,mTau6))-5822/5*(pow(Pi,-1))*(-(Gt({{0,0},{2,-1/2*mTau6}},1/3*mTau6,mTau6))+Gt({{0,0},{2,1/2*mTau6}},1/3*mTau6,mTau6))+231/10*(pow(Pi,-1))*(-(Gt({{0,0},{2,-2/3*mTau6}},1/2,mTau6))+Gt({{0,0},{2,2/3*mTau6}},1/2,mTau6))-70291/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau6}},1/2,mTau6))+Gt({{0,0},{2,5/6*mTau6}},1/2,mTau6))+8037/80*(pow(Pi,-1))*(-(Gt({{0,0},{2,-5/6*mTau6}},5/6+2/3*mTau6,mTau6))+Gt({{0,0},{2,5/6*mTau6}},5/6+2/3*mTau6,mTau6))",
		"2197/300*(pow(Pi,-2))*(-(Gt({{3,-1/6}},5/6+5/6*mTau6,mTau6))+Gt({{3,1/6}},5/6+5/6*mTau6,mTau6))-10409/90*(pow(Pi,-2))*(-(Gt({{3,-1/6}},1/2*mTau6,mTau6))+Gt({{3,1/6}},1/2*mTau6,mTau6))-2197/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/6,mTau6))+Gt({{3,1/3}},1/6,mTau6))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+1/3*mTau6,mTau6))+Gt({{3,1/3}},2/3+1/3*mTau6,mTau6))+386267/360*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3+2/3*mTau6,mTau6))+Gt({{3,1/3}},2/3+2/3*mTau6,mTau6))+6207/40*(pow(Pi,-2))*(-(Gt({{3,-1/3}},1/2*mTau6,mTau6))+Gt({{3,1/3}},1/2*mTau6,mTau6))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-1/3}},2/3*mTau6,mTau6))+Gt({{3,1/3}},2/3*mTau6,mTau6))+665/6*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau6}},1/2,mTau6))+Gt({{3,1/6+1/6*mTau6}},1/2,mTau6))-893/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/6*mTau6}},1/2*mTau6,mTau6))+Gt({{3,1/6+1/6*mTau6}},1/2*mTau6,mTau6))+1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau6}},1/2,mTau6))+Gt({{3,2/3+1/6*mTau6}},1/2,mTau6))-1271/24*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{3,2/3+1/6*mTau6}},1/2+1/2*mTau6,mTau6))+8141/120*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/6*mTau6}},1/2*mTau6,mTau6))+Gt({{3,2/3+1/6*mTau6}},1/2*mTau6,mTau6))+70*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau6}},2/3,mTau6))+Gt({{3,5/6+1/6*mTau6}},2/3,mTau6))+168/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau6}},5/6,mTau6))+Gt({{3,5/6+1/6*mTau6}},5/6,mTau6))-77/2*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{3,5/6+1/6*mTau6}},1/2+1/2*mTau6,mTau6))+48/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau6}},1/6*mTau6,mTau6))+Gt({{3,5/6+1/6*mTau6}},1/6*mTau6,mTau6))+519/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/6*mTau6}},1/2*mTau6,mTau6))+Gt({{3,5/6+1/6*mTau6}},1/2*mTau6,mTau6))-140/3*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau6}},1/2,mTau6))+Gt({{3,1/6+1/3*mTau6}},1/2,mTau6))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{3,1/6+1/3*mTau6}},1/2+1/2*mTau6,mTau6))-57739/288*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau6}},1/6*mTau6,mTau6))+Gt({{3,1/6+1/3*mTau6}},1/6*mTau6,mTau6))+36031/1440*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/3*mTau6}},5/6*mTau6,mTau6))+Gt({{3,1/6+1/3*mTau6}},5/6*mTau6,mTau6))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau6}},1/3,mTau6))+Gt({{3,2/3+1/3*mTau6}},1/3,mTau6))-665/6*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau6}},1/2,mTau6))+Gt({{3,2/3+1/3*mTau6}},1/2,mTau6))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau6}},2/3,mTau6))+Gt({{3,2/3+1/3*mTau6}},2/3,mTau6))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau6}},1/3+1/3*mTau6,mTau6))+Gt({{3,2/3+1/3*mTau6}},1/3+1/3*mTau6,mTau6))-386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/3*mTau6}},1/3*mTau6,mTau6))+Gt({{3,2/3+1/3*mTau6}},1/3*mTau6,mTau6))+1127/60*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau6}},1/2,mTau6))+Gt({{3,5/6+1/3*mTau6}},1/2,mTau6))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{3,5/6+1/3*mTau6}},1/2+1/2*mTau6,mTau6))-1045553/720*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau6}},1/3*mTau6,mTau6))+Gt({{3,5/6+1/3*mTau6}},1/3*mTau6,mTau6))+231407/270*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/3*mTau6}},1/2*mTau6,mTau6))+Gt({{3,5/6+1/3*mTau6}},1/2*mTau6,mTau6))+22867/360*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau6}},1/2,mTau6))+Gt({{3,1/6+1/2*mTau6}},1/2,mTau6))-2069/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-1/2*mTau6}},2/3+1/2*mTau6,mTau6))+Gt({{3,1/6+1/2*mTau6}},2/3+1/2*mTau6,mTau6))-72913/360*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau6}},1/2,mTau6))+Gt({{3,1/3+1/2*mTau6}},1/2,mTau6))+1481/20*(pow(Pi,-2))*(-(Gt({{3,-1/3-1/2*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{3,1/3+1/2*mTau6}},1/2+1/2*mTau6,mTau6))-188113/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau6}},1/3,mTau6))+Gt({{3,1/2+1/2*mTau6}},1/3,mTau6))+1582769/10800*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau6}},2/3,mTau6))+Gt({{3,1/2+1/2*mTau6}},2/3,mTau6))-1555/8*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau6}},5/6,mTau6))+Gt({{3,1/2+1/2*mTau6}},5/6,mTau6))+105/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau6}},1/2+1/6*mTau6,mTau6))+Gt({{3,1/2+1/2*mTau6}},1/2+1/6*mTau6,mTau6))+263/3*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau6}},1/2+1/3*mTau6,mTau6))+Gt({{3,1/2+1/2*mTau6}},1/2+1/3*mTau6,mTau6))-1367/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-1/2*mTau6}},5/6*mTau6,mTau6))+Gt({{3,1/2+1/2*mTau6}},5/6*mTau6,mTau6))-31277/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau6}},1/2,mTau6))+Gt({{3,2/3+1/2*mTau6}},1/2,mTau6))-147/5*(pow(Pi,-2))*(-(Gt({{3,-2/3-1/2*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{3,2/3+1/2*mTau6}},1/2+1/2*mTau6,mTau6))-9379/360*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau6}},1/2,mTau6))+Gt({{3,5/6+1/2*mTau6}},1/2,mTau6))-126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau6}},2/3,mTau6))+Gt({{3,5/6+1/2*mTau6}},2/3,mTau6))+126/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau6}},5/6,mTau6))+Gt({{3,5/6+1/2*mTau6}},5/6,mTau6))+2069/40*(pow(Pi,-2))*(-(Gt({{3,-5/6-1/2*mTau6}},1/2*mTau6,mTau6))+Gt({{3,5/6+1/2*mTau6}},1/2*mTau6,mTau6))+7343/60*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau6}},1/2,mTau6))+Gt({{3,1/6+2/3*mTau6}},1/2,mTau6))-1427/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau6}},1/2*mTau6,mTau6))+Gt({{3,1/6+2/3*mTau6}},1/2*mTau6,mTau6))+847/40*(pow(Pi,-2))*(-(Gt({{3,-1/6-2/3*mTau6}},2/3*mTau6,mTau6))+Gt({{3,1/6+2/3*mTau6}},2/3*mTau6,mTau6))+665/12*(pow(Pi,-2))*(-(Gt({{3,-1/3-2/3*mTau6}},1/2,mTau6))+Gt({{3,1/3+2/3*mTau6}},1/2,mTau6))+77/10*(pow(Pi,-2))*(-(Gt({{3,-1/2-2/3*mTau6}},1/2,mTau6))+Gt({{3,1/2+2/3*mTau6}},1/2,mTau6))-386267/360*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau6}},1/3,mTau6))+Gt({{3,2/3+2/3*mTau6}},1/3,mTau6))+386267/720*(pow(Pi,-2))*(-(Gt({{3,-2/3-2/3*mTau6}},2/3,mTau6))+Gt({{3,2/3+2/3*mTau6}},2/3,mTau6))+223/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau6}},1/2,mTau6))+Gt({{3,5/6+2/3*mTau6}},1/2,mTau6))+24/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau6}},2/3,mTau6))+Gt({{3,5/6+2/3*mTau6}},2/3,mTau6))+518/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau6}},1/6+1/6*mTau6,mTau6))+Gt({{3,5/6+2/3*mTau6}},1/6+1/6*mTau6,mTau6))+14/5*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau6}},2/3+5/6*mTau6,mTau6))+Gt({{3,5/6+2/3*mTau6}},2/3+5/6*mTau6,mTau6))-21637/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau6}},1/6*mTau6,mTau6))+Gt({{3,5/6+2/3*mTau6}},1/6*mTau6,mTau6))-1579/160*(pow(Pi,-2))*(-(Gt({{3,-5/6-2/3*mTau6}},5/6*mTau6,mTau6))+Gt({{3,5/6+2/3*mTau6}},5/6*mTau6,mTau6))-1579/120*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{3,1/6+5/6*mTau6}},1/2*mTau6,mTau6))-55/8*(pow(Pi,-2))*(-(Gt({{3,-1/6-5/6*mTau6}},2/3*mTau6,mTau6))+Gt({{3,1/6+5/6*mTau6}},2/3*mTau6,mTau6))+893/60*(pow(Pi,-2))*(-(Gt({{3,-1/3-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{3,1/3+5/6*mTau6}},1/2*mTau6,mTau6))-21/2*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{3,1/2+5/6*mTau6}},1/2+1/2*mTau6,mTau6))+14/5*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau6}},1/2+2/3*mTau6,mTau6))+Gt({{3,1/2+5/6*mTau6}},1/2+2/3*mTau6,mTau6))+203/30*(pow(Pi,-2))*(-(Gt({{3,-1/2-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{3,1/2+5/6*mTau6}},1/2*mTau6,mTau6))-1111/10*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau6}},1/2,mTau6))+Gt({{3,2/3+5/6*mTau6}},1/2,mTau6))-41/12*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau6}},1/2+1/3*mTau6,mTau6))+Gt({{3,2/3+5/6*mTau6}},1/2+1/3*mTau6,mTau6))+221/60*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau6}},1/2+1/2*mTau6,mTau6))+Gt({{3,2/3+5/6*mTau6}},1/2+1/2*mTau6,mTau6))-253/180*(pow(Pi,-2))*(-(Gt({{3,-2/3-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{3,2/3+5/6*mTau6}},1/2*mTau6,mTau6))-37841/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau6}},1/3,mTau6))+Gt({{3,5/6+5/6*mTau6}},1/3,mTau6))+321817/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau6}},1/2,mTau6))+Gt({{3,5/6+5/6*mTau6}},1/2,mTau6))-136121/2700*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau6}},2/3,mTau6))+Gt({{3,5/6+5/6*mTau6}},2/3,mTau6))+12277/300*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau6}},5/6,mTau6))+Gt({{3,5/6+5/6*mTau6}},5/6,mTau6))-208783/144*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau6}},1/6*mTau6,mTau6))+Gt({{3,5/6+5/6*mTau6}},1/6*mTau6,mTau6))+1078601/2160*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau6}},1/2*mTau6,mTau6))+Gt({{3,5/6+5/6*mTau6}},1/2*mTau6,mTau6))-141/10*(pow(Pi,-2))*(-(Gt({{3,-5/6-5/6*mTau6}},5/6*mTau6,mTau6))+Gt({{3,5/6+5/6*mTau6}},5/6*mTau6,mTau6))-13319/96*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau6}},1/2,mTau6))+Gt({{3,1/6*mTau6}},1/2,mTau6))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-1/6*mTau6}},5/6+2/3*mTau6,mTau6))+Gt({{3,1/6*mTau6}},5/6+2/3*mTau6,mTau6))-77/10*(pow(Pi,-2))*(-(Gt({{3,-1/3*mTau6}},1/2,mTau6))+Gt({{3,1/3*mTau6}},1/2,mTau6))-755827/7200*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau6}},5/6,mTau6))+Gt({{3,1/2*mTau6}},5/6,mTau6))-22841/120*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau6}},2/3+1/6*mTau6,mTau6))+Gt({{3,1/2*mTau6}},2/3+1/6*mTau6,mTau6))-1371547/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau6}},5/6+1/3*mTau6,mTau6))+Gt({{3,1/2*mTau6}},5/6+1/3*mTau6,mTau6))+969431/720*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau6}},5/6+1/2*mTau6,mTau6))+Gt({{3,1/2*mTau6}},5/6+1/2*mTau6,mTau6))+20261/1440*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau6}},1/6+2/3*mTau6,mTau6))+Gt({{3,1/2*mTau6}},1/6+2/3*mTau6,mTau6))+577/60*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau6}},1/3+5/6*mTau6,mTau6))+Gt({{3,1/2*mTau6}},1/3+5/6*mTau6,mTau6))+1639/180*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau6}},2/3+5/6*mTau6,mTau6))+Gt({{3,1/2*mTau6}},2/3+5/6*mTau6,mTau6))-1011209/2160*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau6}},5/6+5/6*mTau6,mTau6))+Gt({{3,1/2*mTau6}},5/6+5/6*mTau6,mTau6))-2911/15*(pow(Pi,-2))*(-(Gt({{3,-1/2*mTau6}},1/3*mTau6,mTau6))+Gt({{3,1/2*mTau6}},1/3*mTau6,mTau6))+77/20*(pow(Pi,-2))*(-(Gt({{3,-2/3*mTau6}},1/2,mTau6))+Gt({{3,2/3*mTau6}},1/2,mTau6))-70291/480*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau6}},1/2,mTau6))+Gt({{3,5/6*mTau6}},1/2,mTau6))+2679/160*(pow(Pi,-2))*(-(Gt({{3,-5/6*mTau6}},5/6+2/3*mTau6,mTau6))+Gt({{3,5/6*mTau6}},5/6+2/3*mTau6,mTau6))",
	};


#define LIST_SYMBOLS(f) f(mTau1) f(mTau2) f(mTau3) f(mTau4) f(mTau5) f(mTau6)

	DEFINE_SYMBOLS
	MAKE_PARSER

#undef LIST_SYMBOLS

	const ex points = lst{
		mTau1==I,
		mTau2==numeric(1,3) + 3*I/2,
		mTau3==numeric(13,12)*I,
		mTau4==numeric(1,4) + I/10,
		mTau5==numeric(10,3) + I,
		mTau6==numeric(-7,4) + I/4
	};

	lst inputs;
	for (size_t i = 0; i < 18; i++)
		inputs.append(parse(tests[i]));

	timer clock;
	clock.start();
	Gt::lst_evaluate(inputs, &points);
	clock.stop();

	cout << "Time: " << clock.read() << "s" << endl;

	return 0;
}

// eq. 5.11 from 2108.03828
static unsigned time_bhabha()
{

#define LIST_SYMBOLS(f) f(y) f(z) f(t)

	DEFINE_SYMBOLS
	MAKE_PARSER

#undef LIST_SYMBOLS

	// physically less relevant point:
	// Mathematica: ~7 digits in 458.2s
	// Ours: 17 digits in 38.7s
	//const ex points = lst{
	//    //x == 0.300,
	//    y == 0.100,
	//    z == 0.196,
	//    t == 0.388*I
	//};

	// physically relevant point:
	// Mathematica: fails
	const ex points = lst{
		y == 0.382,
		z == 0.124,
		t == 0.877*I
	};


	const char* expr = "(8/45)*(4*(pow(Pi,4))+15*(pow(Pi,2))*(G({0,0},y))+30*(pow(Pi,2))*(G({0,1},y))+45*(G({0,0,0,0},y))-90*(G({0,0,0,1},y)))+((-8/3)*(pow(Pi,2))*(G({0},y))+(-16/3)*(pow(Pi,2))*(G({1},y))-8*(G({0,0,0},y))+16*(G({0,0,1},y)))*(Gt({{1,-3/8}},-1/4+z,t))+((8/3)*(pow(Pi,2))*(G({0},y))+(16/3)*(pow(Pi,2))*(G({1},y))+8*(G({0,0,0},y))-16*(G({0,0,1},y)))*(Gt({{1,-1/8}},-1/4+z,t))+((8/3)*(pow(Pi,2))*(G({0},y))+(16/3)*(pow(Pi,2))*(G({1},y))+8*(G({0,0,0},y))-16*(G({0,0,1},y)))*(Gt({{1,1/8}},-1/4+z,t))+((-8/3)*(pow(Pi,2))*(G({0},y))+(-16/3)*(pow(Pi,2))*(G({1},y))-8*(G({0,0,0},y))+16*(G({0,0,1},y)))*(Gt({{1,3/8}},-1/4+z,t))+(-16/3)*(pow(Pi,2))*(Gt({{1,-3/8},{1,-3/8}},-1/4+z,t))+(-16/3)*(pow(Pi,2))*(Gt({{1,-3/8},{1,-1/8}},-1/4+z,t))+(16/3)*(pow(Pi,2))*(Gt({{1,-3/8},{1,1/8}},-1/4+z,t))+(16/3)*(pow(Pi,2))*(Gt({{1,-3/8},{1,3/8}},-1/4+z,t))+(16/3)*(pow(Pi,2))*(Gt({{1,-1/8},{1,-3/8}},-1/4+z,t))+(16/3)*(pow(Pi,2))*(Gt({{1,-1/8},{1,-1/8}},-1/4+z,t))+(-16/3)*(pow(Pi,2))*(Gt({{1,-1/8},{1,1/8}},-1/4+z,t))+(-16/3)*(pow(Pi,2))*(Gt({{1,-1/8},{1,3/8}},-1/4+z,t))+((32/3)*(pow(Pi,2))+16*(G({0,0},y))-32*(G({0,1},y)))*(Gt({{1,0},{1,-3/8}},-1/4+z,t))+((-64/3)*(pow(Pi,2))-32*(G({0,0},y))+64*(G({0,1},y)))*(Gt({{1,0},{1,-1/4}},-1/4+z,t))+((32/3)*(pow(Pi,2))+16*(G({0,0},y))-32*(G({0,1},y)))*(Gt({{1,0},{1,-1/8}},-1/4+z,t))+((32/3)*(pow(Pi,2))+16*(G({0,0},y))-32*(G({0,1},y)))*(Gt({{1,0},{1,1/8}},-1/4+z,t))+((-64/3)*(pow(Pi,2))-32*(G({0,0},y))+64*(G({0,1},y)))*(Gt({{1,0},{1,1/4}},-1/4+z,t))+((32/3)*(pow(Pi,2))+16*(G({0,0},y))-32*(G({0,1},y)))*(Gt({{1,0},{1,3/8}},-1/4+z,t))+(-16/3)*(pow(Pi,2))*(Gt({{1,1/8},{1,-3/8}},-1/4+z,t))+(-16/3)*(pow(Pi,2))*(Gt({{1,1/8},{1,-1/8}},-1/4+z,t))+(16/3)*(pow(Pi,2))*(Gt({{1,1/8},{1,1/8}},-1/4+z,t))+(16/3)*(pow(Pi,2))*(Gt({{1,1/8},{1,3/8}},-1/4+z,t))+(16/3)*(pow(Pi,2))*(Gt({{1,3/8},{1,-3/8}},-1/4+z,t))+(16/3)*(pow(Pi,2))*(Gt({{1,3/8},{1,-1/8}},-1/4+z,t))+(-16/3)*(pow(Pi,2))*(Gt({{1,3/8},{1,1/8}},-1/4+z,t))+(-16/3)*(pow(Pi,2))*(Gt({{1,3/8},{1,3/8}},-1/4+z,t))+((-32/3)*(pow(Pi,2))-16*(G({0,0},y))+32*(G({0,1},y)))*(Gt({{1,1/2},{1,-3/8}},-1/4+z,t))+((64/3)*(pow(Pi,2))+32*(G({0,0},y))-64*(G({0,1},y)))*(Gt({{1,1/2},{1,-1/4}},-1/4+z,t))+((-32/3)*(pow(Pi,2))-16*(G({0,0},y))+32*(G({0,1},y)))*(Gt({{1,1/2},{1,-1/8}},-1/4+z,t))+((-32/3)*(pow(Pi,2))-16*(G({0,0},y))+32*(G({0,1},y)))*(Gt({{1,1/2},{1,1/8}},-1/4+z,t))+((64/3)*(pow(Pi,2))+32*(G({0,0},y))-64*(G({0,1},y)))*(Gt({{1,1/2},{1,1/4}},-1/4+z,t))+((-32/3)*(pow(Pi,2))-16*(G({0,0},y))+32*(G({0,1},y)))*(Gt({{1,1/2},{1,3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-3/8},{1,-3/8},{1,1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-3/8},{1,-3/8},{1,3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-3/8},{1,-1/8},{1,1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-3/8},{1,-1/8},{1,3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-3/8},{1,1/8},{1,-3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-3/8},{1,1/8},{1,-1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-3/8},{1,1/8},{1,1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-3/8},{1,1/8},{1,3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-3/8},{1,3/8},{1,-3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-3/8},{1,3/8},{1,-1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-3/8},{1,3/8},{1,1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-3/8},{1,3/8},{1,3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-1/8},{1,-3/8},{1,1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-1/8},{1,-3/8},{1,3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-1/8},{1,-1/8},{1,1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-1/8},{1,-1/8},{1,3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-1/8},{1,1/8},{1,-3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-1/8},{1,1/8},{1,-1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-1/8},{1,1/8},{1,1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-1/8},{1,1/8},{1,3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-1/8},{1,3/8},{1,-3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,-1/8},{1,3/8},{1,-1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-1/8},{1,3/8},{1,1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,-1/8},{1,3/8},{1,3/8}},-1/4+z,t))+(32*(G({0},y))-64*(G({1},y)))*(Gt({{1,0},{1,-1/4},{1,-3/8}},-1/4+z,t))+(32*(G({0},y))-64*(G({1},y)))*(Gt({{1,0},{1,-1/4},{1,-1/8}},-1/4+z,t))+((-32)*(G({0},y))+64*(G({1},y)))*(Gt({{1,0},{1,-1/4},{1,1/8}},-1/4+z,t))+((-32)*(G({0},y))+64*(G({1},y)))*(Gt({{1,0},{1,-1/4},{1,3/8}},-1/4+z,t))+((-32)*(G({0},y))+64*(G({1},y)))*(Gt({{1,0},{1,1/4},{1,-3/8}},-1/4+z,t))+((-32)*(G({0},y))+64*(G({1},y)))*(Gt({{1,0},{1,1/4},{1,-1/8}},-1/4+z,t))+(32*(G({0},y))-64*(G({1},y)))*(Gt({{1,0},{1,1/4},{1,1/8}},-1/4+z,t))+(32*(G({0},y))-64*(G({1},y)))*(Gt({{1,0},{1,1/4},{1,3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,1/8},{1,-3/8},{1,1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,1/8},{1,-3/8},{1,3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,1/8},{1,-1/8},{1,1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,1/8},{1,-1/8},{1,3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,1/8},{1,1/8},{1,-3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,1/8},{1,1/8},{1,-1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,1/8},{1,1/8},{1,1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,1/8},{1,1/8},{1,3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,1/8},{1,3/8},{1,-3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,1/8},{1,3/8},{1,-1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,1/8},{1,3/8},{1,1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,1/8},{1,3/8},{1,3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,3/8},{1,-3/8},{1,1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,3/8},{1,-3/8},{1,3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,3/8},{1,-1/8},{1,1/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,3/8},{1,-1/8},{1,3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,3/8},{1,1/8},{1,-3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,3/8},{1,1/8},{1,-1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,3/8},{1,1/8},{1,1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,3/8},{1,1/8},{1,3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,3/8},{1,3/8},{1,-3/8}},-1/4+z,t))+((-16)*(G({0},y))+32*(G({1},y)))*(Gt({{1,3/8},{1,3/8},{1,-1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,3/8},{1,3/8},{1,1/8}},-1/4+z,t))+(16*(G({0},y))-32*(G({1},y)))*(Gt({{1,3/8},{1,3/8},{1,3/8}},-1/4+z,t))+((-32)*(G({0},y))+64*(G({1},y)))*(Gt({{1,1/2},{1,-1/4},{1,-3/8}},-1/4+z,t))+((-32)*(G({0},y))+64*(G({1},y)))*(Gt({{1,1/2},{1,-1/4},{1,-1/8}},-1/4+z,t))+(32*(G({0},y))-64*(G({1},y)))*(Gt({{1,1/2},{1,-1/4},{1,1/8}},-1/4+z,t))+(32*(G({0},y))-64*(G({1},y)))*(Gt({{1,1/2},{1,-1/4},{1,3/8}},-1/4+z,t))+(32*(G({0},y))-64*(G({1},y)))*(Gt({{1,1/2},{1,1/4},{1,-3/8}},-1/4+z,t))+(32*(G({0},y))-64*(G({1},y)))*(Gt({{1,1/2},{1,1/4},{1,-1/8}},-1/4+z,t))+((-32)*(G({0},y))+64*(G({1},y)))*(Gt({{1,1/2},{1,1/4},{1,1/8}},-1/4+z,t))+((-32)*(G({0},y))+64*(G({1},y)))*(Gt({{1,1/2},{1,1/4},{1,3/8}},-1/4+z,t))-40*(Gt({{1,-3/8},{1,-3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))-40*(Gt({{1,-3/8},{1,-3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+40*(Gt({{1,-3/8},{1,-3/8},{1,-3/8},{1,1/8}},-1/4+z,t))+40*(Gt({{1,-3/8},{1,-3/8},{1,-3/8},{1,3/8}},-1/4+z,t))-40*(Gt({{1,-3/8},{1,-3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))-40*(Gt({{1,-3/8},{1,-3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+40*(Gt({{1,-3/8},{1,-3/8},{1,-1/8},{1,1/8}},-1/4+z,t))+40*(Gt({{1,-3/8},{1,-3/8},{1,-1/8},{1,3/8}},-1/4+z,t))+8*(Gt({{1,-3/8},{1,-3/8},{1,1/8},{1,-3/8}},-1/4+z,t))+8*(Gt({{1,-3/8},{1,-3/8},{1,1/8},{1,-1/8}},-1/4+z,t))-8*(Gt({{1,-3/8},{1,-3/8},{1,1/8},{1,1/8}},-1/4+z,t))-8*(Gt({{1,-3/8},{1,-3/8},{1,1/8},{1,3/8}},-1/4+z,t))+8*(Gt({{1,-3/8},{1,-3/8},{1,3/8},{1,-3/8}},-1/4+z,t))+8*(Gt({{1,-3/8},{1,-3/8},{1,3/8},{1,-1/8}},-1/4+z,t))-8*(Gt({{1,-3/8},{1,-3/8},{1,3/8},{1,1/8}},-1/4+z,t))-8*(Gt({{1,-3/8},{1,-3/8},{1,3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,-3/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,-3/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,-3/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,-3/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-40*(Gt({{1,-3/8},{1,-1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))-40*(Gt({{1,-3/8},{1,-1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+40*(Gt({{1,-3/8},{1,-1/8},{1,-3/8},{1,1/8}},-1/4+z,t))+40*(Gt({{1,-3/8},{1,-1/8},{1,-3/8},{1,3/8}},-1/4+z,t))-40*(Gt({{1,-3/8},{1,-1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))-40*(Gt({{1,-3/8},{1,-1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+40*(Gt({{1,-3/8},{1,-1/8},{1,-1/8},{1,1/8}},-1/4+z,t))+40*(Gt({{1,-3/8},{1,-1/8},{1,-1/8},{1,3/8}},-1/4+z,t))+8*(Gt({{1,-3/8},{1,-1/8},{1,1/8},{1,-3/8}},-1/4+z,t))+8*(Gt({{1,-3/8},{1,-1/8},{1,1/8},{1,-1/8}},-1/4+z,t))-8*(Gt({{1,-3/8},{1,-1/8},{1,1/8},{1,1/8}},-1/4+z,t))-8*(Gt({{1,-3/8},{1,-1/8},{1,1/8},{1,3/8}},-1/4+z,t))+8*(Gt({{1,-3/8},{1,-1/8},{1,3/8},{1,-3/8}},-1/4+z,t))+8*(Gt({{1,-3/8},{1,-1/8},{1,3/8},{1,-1/8}},-1/4+z,t))-8*(Gt({{1,-3/8},{1,-1/8},{1,3/8},{1,1/8}},-1/4+z,t))-8*(Gt({{1,-3/8},{1,-1/8},{1,3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,-1/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,-1/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,-1/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,-1/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,0},{1,-3/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,0},{1,-3/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,0},{1,-3/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,0},{1,-3/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,0},{1,-1/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,0},{1,-1/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,0},{1,-1/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,0},{1,-1/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,0},{1,1/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,0},{1,1/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,0},{1,1/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,0},{1,1/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,0},{1,3/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,0},{1,3/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,0},{1,3/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,0},{1,3/8},{1,3/8}},-1/4+z,t))+56*(Gt({{1,-3/8},{1,1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+56*(Gt({{1,-3/8},{1,1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))-56*(Gt({{1,-3/8},{1,1/8},{1,-3/8},{1,1/8}},-1/4+z,t))-56*(Gt({{1,-3/8},{1,1/8},{1,-3/8},{1,3/8}},-1/4+z,t))+56*(Gt({{1,-3/8},{1,1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+56*(Gt({{1,-3/8},{1,1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))-56*(Gt({{1,-3/8},{1,1/8},{1,-1/8},{1,1/8}},-1/4+z,t))-56*(Gt({{1,-3/8},{1,1/8},{1,-1/8},{1,3/8}},-1/4+z,t))-24*(Gt({{1,-3/8},{1,1/8},{1,1/8},{1,-3/8}},-1/4+z,t))-24*(Gt({{1,-3/8},{1,1/8},{1,1/8},{1,-1/8}},-1/4+z,t))+24*(Gt({{1,-3/8},{1,1/8},{1,1/8},{1,1/8}},-1/4+z,t))+24*(Gt({{1,-3/8},{1,1/8},{1,1/8},{1,3/8}},-1/4+z,t))-24*(Gt({{1,-3/8},{1,1/8},{1,3/8},{1,-3/8}},-1/4+z,t))-24*(Gt({{1,-3/8},{1,1/8},{1,3/8},{1,-1/8}},-1/4+z,t))+24*(Gt({{1,-3/8},{1,1/8},{1,3/8},{1,1/8}},-1/4+z,t))+24*(Gt({{1,-3/8},{1,1/8},{1,3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,1/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,1/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,1/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,1/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))+56*(Gt({{1,-3/8},{1,3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+56*(Gt({{1,-3/8},{1,3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))-56*(Gt({{1,-3/8},{1,3/8},{1,-3/8},{1,1/8}},-1/4+z,t))-56*(Gt({{1,-3/8},{1,3/8},{1,-3/8},{1,3/8}},-1/4+z,t))+56*(Gt({{1,-3/8},{1,3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+56*(Gt({{1,-3/8},{1,3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))-56*(Gt({{1,-3/8},{1,3/8},{1,-1/8},{1,1/8}},-1/4+z,t))-56*(Gt({{1,-3/8},{1,3/8},{1,-1/8},{1,3/8}},-1/4+z,t))-24*(Gt({{1,-3/8},{1,3/8},{1,1/8},{1,-3/8}},-1/4+z,t))-24*(Gt({{1,-3/8},{1,3/8},{1,1/8},{1,-1/8}},-1/4+z,t))+24*(Gt({{1,-3/8},{1,3/8},{1,1/8},{1,1/8}},-1/4+z,t))+24*(Gt({{1,-3/8},{1,3/8},{1,1/8},{1,3/8}},-1/4+z,t))-24*(Gt({{1,-3/8},{1,3/8},{1,3/8},{1,-3/8}},-1/4+z,t))-24*(Gt({{1,-3/8},{1,3/8},{1,3/8},{1,-1/8}},-1/4+z,t))+24*(Gt({{1,-3/8},{1,3/8},{1,3/8},{1,1/8}},-1/4+z,t))+24*(Gt({{1,-3/8},{1,3/8},{1,3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,3/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,-3/8},{1,3/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,3/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,-3/8},{1,3/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,1/2},{1,-3/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,1/2},{1,-3/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,1/2},{1,-3/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,1/2},{1,-3/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,1/2},{1,-1/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,1/2},{1,-1/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,1/2},{1,-1/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,1/2},{1,-1/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,1/2},{1,1/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,1/2},{1,1/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,1/2},{1,1/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,1/2},{1,1/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,1/2},{1,3/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,-3/8},{1,1/2},{1,3/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,1/2},{1,3/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,-3/8},{1,1/2},{1,3/8},{1,3/8}},-1/4+z,t))+40*(Gt({{1,-1/8},{1,-3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+40*(Gt({{1,-1/8},{1,-3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))-40*(Gt({{1,-1/8},{1,-3/8},{1,-3/8},{1,1/8}},-1/4+z,t))-40*(Gt({{1,-1/8},{1,-3/8},{1,-3/8},{1,3/8}},-1/4+z,t))+40*(Gt({{1,-1/8},{1,-3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+40*(Gt({{1,-1/8},{1,-3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))-40*(Gt({{1,-1/8},{1,-3/8},{1,-1/8},{1,1/8}},-1/4+z,t))-40*(Gt({{1,-1/8},{1,-3/8},{1,-1/8},{1,3/8}},-1/4+z,t))-8*(Gt({{1,-1/8},{1,-3/8},{1,1/8},{1,-3/8}},-1/4+z,t))-8*(Gt({{1,-1/8},{1,-3/8},{1,1/8},{1,-1/8}},-1/4+z,t))+8*(Gt({{1,-1/8},{1,-3/8},{1,1/8},{1,1/8}},-1/4+z,t))+8*(Gt({{1,-1/8},{1,-3/8},{1,1/8},{1,3/8}},-1/4+z,t))-8*(Gt({{1,-1/8},{1,-3/8},{1,3/8},{1,-3/8}},-1/4+z,t))-8*(Gt({{1,-1/8},{1,-3/8},{1,3/8},{1,-1/8}},-1/4+z,t))+8*(Gt({{1,-1/8},{1,-3/8},{1,3/8},{1,1/8}},-1/4+z,t))+8*(Gt({{1,-1/8},{1,-3/8},{1,3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,-3/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,-3/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,-3/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,-3/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))+40*(Gt({{1,-1/8},{1,-1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+40*(Gt({{1,-1/8},{1,-1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))-40*(Gt({{1,-1/8},{1,-1/8},{1,-3/8},{1,1/8}},-1/4+z,t))-40*(Gt({{1,-1/8},{1,-1/8},{1,-3/8},{1,3/8}},-1/4+z,t))+40*(Gt({{1,-1/8},{1,-1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+40*(Gt({{1,-1/8},{1,-1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))-40*(Gt({{1,-1/8},{1,-1/8},{1,-1/8},{1,1/8}},-1/4+z,t))-40*(Gt({{1,-1/8},{1,-1/8},{1,-1/8},{1,3/8}},-1/4+z,t))-8*(Gt({{1,-1/8},{1,-1/8},{1,1/8},{1,-3/8}},-1/4+z,t))-8*(Gt({{1,-1/8},{1,-1/8},{1,1/8},{1,-1/8}},-1/4+z,t))+8*(Gt({{1,-1/8},{1,-1/8},{1,1/8},{1,1/8}},-1/4+z,t))+8*(Gt({{1,-1/8},{1,-1/8},{1,1/8},{1,3/8}},-1/4+z,t))-8*(Gt({{1,-1/8},{1,-1/8},{1,3/8},{1,-3/8}},-1/4+z,t))-8*(Gt({{1,-1/8},{1,-1/8},{1,3/8},{1,-1/8}},-1/4+z,t))+8*(Gt({{1,-1/8},{1,-1/8},{1,3/8},{1,1/8}},-1/4+z,t))+8*(Gt({{1,-1/8},{1,-1/8},{1,3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,-1/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,-1/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,-1/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,-1/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,0},{1,-3/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,0},{1,-3/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,0},{1,-3/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,0},{1,-3/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,0},{1,-1/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,0},{1,-1/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,0},{1,-1/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,0},{1,-1/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,0},{1,1/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,0},{1,1/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,0},{1,1/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,0},{1,1/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,0},{1,3/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,0},{1,3/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,0},{1,3/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,0},{1,3/8},{1,3/8}},-1/4+z,t))-56*(Gt({{1,-1/8},{1,1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))-56*(Gt({{1,-1/8},{1,1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+56*(Gt({{1,-1/8},{1,1/8},{1,-3/8},{1,1/8}},-1/4+z,t))+56*(Gt({{1,-1/8},{1,1/8},{1,-3/8},{1,3/8}},-1/4+z,t))-56*(Gt({{1,-1/8},{1,1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))-56*(Gt({{1,-1/8},{1,1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+56*(Gt({{1,-1/8},{1,1/8},{1,-1/8},{1,1/8}},-1/4+z,t))+56*(Gt({{1,-1/8},{1,1/8},{1,-1/8},{1,3/8}},-1/4+z,t))+24*(Gt({{1,-1/8},{1,1/8},{1,1/8},{1,-3/8}},-1/4+z,t))+24*(Gt({{1,-1/8},{1,1/8},{1,1/8},{1,-1/8}},-1/4+z,t))-24*(Gt({{1,-1/8},{1,1/8},{1,1/8},{1,1/8}},-1/4+z,t))-24*(Gt({{1,-1/8},{1,1/8},{1,1/8},{1,3/8}},-1/4+z,t))+24*(Gt({{1,-1/8},{1,1/8},{1,3/8},{1,-3/8}},-1/4+z,t))+24*(Gt({{1,-1/8},{1,1/8},{1,3/8},{1,-1/8}},-1/4+z,t))-24*(Gt({{1,-1/8},{1,1/8},{1,3/8},{1,1/8}},-1/4+z,t))-24*(Gt({{1,-1/8},{1,1/8},{1,3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,1/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,1/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,1/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,1/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-56*(Gt({{1,-1/8},{1,3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))-56*(Gt({{1,-1/8},{1,3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+56*(Gt({{1,-1/8},{1,3/8},{1,-3/8},{1,1/8}},-1/4+z,t))+56*(Gt({{1,-1/8},{1,3/8},{1,-3/8},{1,3/8}},-1/4+z,t))-56*(Gt({{1,-1/8},{1,3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))-56*(Gt({{1,-1/8},{1,3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+56*(Gt({{1,-1/8},{1,3/8},{1,-1/8},{1,1/8}},-1/4+z,t))+56*(Gt({{1,-1/8},{1,3/8},{1,-1/8},{1,3/8}},-1/4+z,t))+24*(Gt({{1,-1/8},{1,3/8},{1,1/8},{1,-3/8}},-1/4+z,t))+24*(Gt({{1,-1/8},{1,3/8},{1,1/8},{1,-1/8}},-1/4+z,t))-24*(Gt({{1,-1/8},{1,3/8},{1,1/8},{1,1/8}},-1/4+z,t))-24*(Gt({{1,-1/8},{1,3/8},{1,1/8},{1,3/8}},-1/4+z,t))+24*(Gt({{1,-1/8},{1,3/8},{1,3/8},{1,-3/8}},-1/4+z,t))+24*(Gt({{1,-1/8},{1,3/8},{1,3/8},{1,-1/8}},-1/4+z,t))-24*(Gt({{1,-1/8},{1,3/8},{1,3/8},{1,1/8}},-1/4+z,t))-24*(Gt({{1,-1/8},{1,3/8},{1,3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,3/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,-1/8},{1,3/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,3/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,-1/8},{1,3/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,1/2},{1,-3/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,1/2},{1,-3/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,1/2},{1,-3/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,1/2},{1,-3/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,1/2},{1,-1/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,1/2},{1,-1/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,1/2},{1,-1/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,1/2},{1,-1/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,1/2},{1,1/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,1/2},{1,1/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,1/2},{1,1/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,1/2},{1,1/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,1/2},{1,3/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,-1/8},{1,1/2},{1,3/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,1/2},{1,3/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,-1/8},{1,1/2},{1,3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,0},{1,-1/4},{1,-3/8},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,0},{1,-1/4},{1,-3/8},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,0},{1,-1/4},{1,-3/8},{1,1/8}},-1/4+z,t))+32*(Gt({{1,0},{1,-1/4},{1,-3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,0},{1,-1/4},{1,-1/8},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,0},{1,-1/4},{1,-1/8},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,0},{1,-1/4},{1,-1/8},{1,1/8}},-1/4+z,t))+32*(Gt({{1,0},{1,-1/4},{1,-1/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,0},{1,-1/4},{1,1/8},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,0},{1,-1/4},{1,1/8},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,0},{1,-1/4},{1,1/8},{1,1/8}},-1/4+z,t))+32*(Gt({{1,0},{1,-1/4},{1,1/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,0},{1,-1/4},{1,3/8},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,0},{1,-1/4},{1,3/8},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,0},{1,-1/4},{1,3/8},{1,1/8}},-1/4+z,t))+32*(Gt({{1,0},{1,-1/4},{1,3/8},{1,3/8}},-1/4+z,t))+64*(Gt({{1,0},{1,-1/4},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+64*(Gt({{1,0},{1,-1/4},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-64*(Gt({{1,0},{1,-1/4},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-64*(Gt({{1,0},{1,-1/4},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+64*(Gt({{1,0},{1,-1/4},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+64*(Gt({{1,0},{1,-1/4},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-64*(Gt({{1,0},{1,-1/4},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-64*(Gt({{1,0},{1,-1/4},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))+32*(Gt({{1,0},{1,1/4},{1,-3/8},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,0},{1,1/4},{1,-3/8},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,0},{1,1/4},{1,-3/8},{1,1/8}},-1/4+z,t))-32*(Gt({{1,0},{1,1/4},{1,-3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,0},{1,1/4},{1,-1/8},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,0},{1,1/4},{1,-1/8},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,0},{1,1/4},{1,-1/8},{1,1/8}},-1/4+z,t))-32*(Gt({{1,0},{1,1/4},{1,-1/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,0},{1,1/4},{1,1/8},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,0},{1,1/4},{1,1/8},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,0},{1,1/4},{1,1/8},{1,1/8}},-1/4+z,t))-32*(Gt({{1,0},{1,1/4},{1,1/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,0},{1,1/4},{1,3/8},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,0},{1,1/4},{1,3/8},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,0},{1,1/4},{1,3/8},{1,1/8}},-1/4+z,t))-32*(Gt({{1,0},{1,1/4},{1,3/8},{1,3/8}},-1/4+z,t))-64*(Gt({{1,0},{1,1/4},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-64*(Gt({{1,0},{1,1/4},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+64*(Gt({{1,0},{1,1/4},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+64*(Gt({{1,0},{1,1/4},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-64*(Gt({{1,0},{1,1/4},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-64*(Gt({{1,0},{1,1/4},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+64*(Gt({{1,0},{1,1/4},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+64*(Gt({{1,0},{1,1/4},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-24*(Gt({{1,1/8},{1,-3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))-24*(Gt({{1,1/8},{1,-3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+24*(Gt({{1,1/8},{1,-3/8},{1,-3/8},{1,1/8}},-1/4+z,t))+24*(Gt({{1,1/8},{1,-3/8},{1,-3/8},{1,3/8}},-1/4+z,t))-24*(Gt({{1,1/8},{1,-3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))-24*(Gt({{1,1/8},{1,-3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+24*(Gt({{1,1/8},{1,-3/8},{1,-1/8},{1,1/8}},-1/4+z,t))+24*(Gt({{1,1/8},{1,-3/8},{1,-1/8},{1,3/8}},-1/4+z,t))+56*(Gt({{1,1/8},{1,-3/8},{1,1/8},{1,-3/8}},-1/4+z,t))+56*(Gt({{1,1/8},{1,-3/8},{1,1/8},{1,-1/8}},-1/4+z,t))-56*(Gt({{1,1/8},{1,-3/8},{1,1/8},{1,1/8}},-1/4+z,t))-56*(Gt({{1,1/8},{1,-3/8},{1,1/8},{1,3/8}},-1/4+z,t))+56*(Gt({{1,1/8},{1,-3/8},{1,3/8},{1,-3/8}},-1/4+z,t))+56*(Gt({{1,1/8},{1,-3/8},{1,3/8},{1,-1/8}},-1/4+z,t))-56*(Gt({{1,1/8},{1,-3/8},{1,3/8},{1,1/8}},-1/4+z,t))-56*(Gt({{1,1/8},{1,-3/8},{1,3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,-3/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,-3/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,-3/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,-3/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-24*(Gt({{1,1/8},{1,-1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))-24*(Gt({{1,1/8},{1,-1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+24*(Gt({{1,1/8},{1,-1/8},{1,-3/8},{1,1/8}},-1/4+z,t))+24*(Gt({{1,1/8},{1,-1/8},{1,-3/8},{1,3/8}},-1/4+z,t))-24*(Gt({{1,1/8},{1,-1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))-24*(Gt({{1,1/8},{1,-1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+24*(Gt({{1,1/8},{1,-1/8},{1,-1/8},{1,1/8}},-1/4+z,t))+24*(Gt({{1,1/8},{1,-1/8},{1,-1/8},{1,3/8}},-1/4+z,t))+56*(Gt({{1,1/8},{1,-1/8},{1,1/8},{1,-3/8}},-1/4+z,t))+56*(Gt({{1,1/8},{1,-1/8},{1,1/8},{1,-1/8}},-1/4+z,t))-56*(Gt({{1,1/8},{1,-1/8},{1,1/8},{1,1/8}},-1/4+z,t))-56*(Gt({{1,1/8},{1,-1/8},{1,1/8},{1,3/8}},-1/4+z,t))+56*(Gt({{1,1/8},{1,-1/8},{1,3/8},{1,-3/8}},-1/4+z,t))+56*(Gt({{1,1/8},{1,-1/8},{1,3/8},{1,-1/8}},-1/4+z,t))-56*(Gt({{1,1/8},{1,-1/8},{1,3/8},{1,1/8}},-1/4+z,t))-56*(Gt({{1,1/8},{1,-1/8},{1,3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,-1/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,-1/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,-1/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,-1/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,0},{1,-3/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,0},{1,-3/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,0},{1,-3/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,0},{1,-3/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,0},{1,-1/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,0},{1,-1/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,0},{1,-1/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,0},{1,-1/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,0},{1,1/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,0},{1,1/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,0},{1,1/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,0},{1,1/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,0},{1,3/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,0},{1,3/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,0},{1,3/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,0},{1,3/8},{1,3/8}},-1/4+z,t))+8*(Gt({{1,1/8},{1,1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+8*(Gt({{1,1/8},{1,1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))-8*(Gt({{1,1/8},{1,1/8},{1,-3/8},{1,1/8}},-1/4+z,t))-8*(Gt({{1,1/8},{1,1/8},{1,-3/8},{1,3/8}},-1/4+z,t))+8*(Gt({{1,1/8},{1,1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+8*(Gt({{1,1/8},{1,1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))-8*(Gt({{1,1/8},{1,1/8},{1,-1/8},{1,1/8}},-1/4+z,t))-8*(Gt({{1,1/8},{1,1/8},{1,-1/8},{1,3/8}},-1/4+z,t))-40*(Gt({{1,1/8},{1,1/8},{1,1/8},{1,-3/8}},-1/4+z,t))-40*(Gt({{1,1/8},{1,1/8},{1,1/8},{1,-1/8}},-1/4+z,t))+40*(Gt({{1,1/8},{1,1/8},{1,1/8},{1,1/8}},-1/4+z,t))+40*(Gt({{1,1/8},{1,1/8},{1,1/8},{1,3/8}},-1/4+z,t))-40*(Gt({{1,1/8},{1,1/8},{1,3/8},{1,-3/8}},-1/4+z,t))-40*(Gt({{1,1/8},{1,1/8},{1,3/8},{1,-1/8}},-1/4+z,t))+40*(Gt({{1,1/8},{1,1/8},{1,3/8},{1,1/8}},-1/4+z,t))+40*(Gt({{1,1/8},{1,1/8},{1,3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,1/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,1/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,1/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,1/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))+8*(Gt({{1,1/8},{1,3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+8*(Gt({{1,1/8},{1,3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))-8*(Gt({{1,1/8},{1,3/8},{1,-3/8},{1,1/8}},-1/4+z,t))-8*(Gt({{1,1/8},{1,3/8},{1,-3/8},{1,3/8}},-1/4+z,t))+8*(Gt({{1,1/8},{1,3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+8*(Gt({{1,1/8},{1,3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))-8*(Gt({{1,1/8},{1,3/8},{1,-1/8},{1,1/8}},-1/4+z,t))-8*(Gt({{1,1/8},{1,3/8},{1,-1/8},{1,3/8}},-1/4+z,t))-40*(Gt({{1,1/8},{1,3/8},{1,1/8},{1,-3/8}},-1/4+z,t))-40*(Gt({{1,1/8},{1,3/8},{1,1/8},{1,-1/8}},-1/4+z,t))+40*(Gt({{1,1/8},{1,3/8},{1,1/8},{1,1/8}},-1/4+z,t))+40*(Gt({{1,1/8},{1,3/8},{1,1/8},{1,3/8}},-1/4+z,t))-40*(Gt({{1,1/8},{1,3/8},{1,3/8},{1,-3/8}},-1/4+z,t))-40*(Gt({{1,1/8},{1,3/8},{1,3/8},{1,-1/8}},-1/4+z,t))+40*(Gt({{1,1/8},{1,3/8},{1,3/8},{1,1/8}},-1/4+z,t))+40*(Gt({{1,1/8},{1,3/8},{1,3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,3/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,1/8},{1,3/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,3/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,1/8},{1,3/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,1/2},{1,-3/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,1/2},{1,-3/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,1/2},{1,-3/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,1/2},{1,-3/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,1/2},{1,-1/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,1/2},{1,-1/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,1/2},{1,-1/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,1/2},{1,-1/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,1/2},{1,1/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,1/2},{1,1/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,1/2},{1,1/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,1/2},{1,1/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,1/2},{1,3/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,1/8},{1,1/2},{1,3/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,1/2},{1,3/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,1/8},{1,1/2},{1,3/8},{1,3/8}},-1/4+z,t))+24*(Gt({{1,3/8},{1,-3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+24*(Gt({{1,3/8},{1,-3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))-24*(Gt({{1,3/8},{1,-3/8},{1,-3/8},{1,1/8}},-1/4+z,t))-24*(Gt({{1,3/8},{1,-3/8},{1,-3/8},{1,3/8}},-1/4+z,t))+24*(Gt({{1,3/8},{1,-3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+24*(Gt({{1,3/8},{1,-3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))-24*(Gt({{1,3/8},{1,-3/8},{1,-1/8},{1,1/8}},-1/4+z,t))-24*(Gt({{1,3/8},{1,-3/8},{1,-1/8},{1,3/8}},-1/4+z,t))-56*(Gt({{1,3/8},{1,-3/8},{1,1/8},{1,-3/8}},-1/4+z,t))-56*(Gt({{1,3/8},{1,-3/8},{1,1/8},{1,-1/8}},-1/4+z,t))+56*(Gt({{1,3/8},{1,-3/8},{1,1/8},{1,1/8}},-1/4+z,t))+56*(Gt({{1,3/8},{1,-3/8},{1,1/8},{1,3/8}},-1/4+z,t))-56*(Gt({{1,3/8},{1,-3/8},{1,3/8},{1,-3/8}},-1/4+z,t))-56*(Gt({{1,3/8},{1,-3/8},{1,3/8},{1,-1/8}},-1/4+z,t))+56*(Gt({{1,3/8},{1,-3/8},{1,3/8},{1,1/8}},-1/4+z,t))+56*(Gt({{1,3/8},{1,-3/8},{1,3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,-3/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,-3/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,-3/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,-3/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,-3/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))+24*(Gt({{1,3/8},{1,-1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))+24*(Gt({{1,3/8},{1,-1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))-24*(Gt({{1,3/8},{1,-1/8},{1,-3/8},{1,1/8}},-1/4+z,t))-24*(Gt({{1,3/8},{1,-1/8},{1,-3/8},{1,3/8}},-1/4+z,t))+24*(Gt({{1,3/8},{1,-1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))+24*(Gt({{1,3/8},{1,-1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))-24*(Gt({{1,3/8},{1,-1/8},{1,-1/8},{1,1/8}},-1/4+z,t))-24*(Gt({{1,3/8},{1,-1/8},{1,-1/8},{1,3/8}},-1/4+z,t))-56*(Gt({{1,3/8},{1,-1/8},{1,1/8},{1,-3/8}},-1/4+z,t))-56*(Gt({{1,3/8},{1,-1/8},{1,1/8},{1,-1/8}},-1/4+z,t))+56*(Gt({{1,3/8},{1,-1/8},{1,1/8},{1,1/8}},-1/4+z,t))+56*(Gt({{1,3/8},{1,-1/8},{1,1/8},{1,3/8}},-1/4+z,t))-56*(Gt({{1,3/8},{1,-1/8},{1,3/8},{1,-3/8}},-1/4+z,t))-56*(Gt({{1,3/8},{1,-1/8},{1,3/8},{1,-1/8}},-1/4+z,t))+56*(Gt({{1,3/8},{1,-1/8},{1,3/8},{1,1/8}},-1/4+z,t))+56*(Gt({{1,3/8},{1,-1/8},{1,3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,-1/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,-1/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,-1/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,-1/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,-1/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,0},{1,-3/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,0},{1,-3/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,0},{1,-3/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,0},{1,-3/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,0},{1,-1/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,0},{1,-1/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,0},{1,-1/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,0},{1,-1/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,0},{1,1/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,0},{1,1/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,0},{1,1/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,0},{1,1/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,0},{1,3/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,0},{1,3/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,0},{1,3/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,0},{1,3/8},{1,3/8}},-1/4+z,t))-8*(Gt({{1,3/8},{1,1/8},{1,-3/8},{1,-3/8}},-1/4+z,t))-8*(Gt({{1,3/8},{1,1/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+8*(Gt({{1,3/8},{1,1/8},{1,-3/8},{1,1/8}},-1/4+z,t))+8*(Gt({{1,3/8},{1,1/8},{1,-3/8},{1,3/8}},-1/4+z,t))-8*(Gt({{1,3/8},{1,1/8},{1,-1/8},{1,-3/8}},-1/4+z,t))-8*(Gt({{1,3/8},{1,1/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+8*(Gt({{1,3/8},{1,1/8},{1,-1/8},{1,1/8}},-1/4+z,t))+8*(Gt({{1,3/8},{1,1/8},{1,-1/8},{1,3/8}},-1/4+z,t))+40*(Gt({{1,3/8},{1,1/8},{1,1/8},{1,-3/8}},-1/4+z,t))+40*(Gt({{1,3/8},{1,1/8},{1,1/8},{1,-1/8}},-1/4+z,t))-40*(Gt({{1,3/8},{1,1/8},{1,1/8},{1,1/8}},-1/4+z,t))-40*(Gt({{1,3/8},{1,1/8},{1,1/8},{1,3/8}},-1/4+z,t))+40*(Gt({{1,3/8},{1,1/8},{1,3/8},{1,-3/8}},-1/4+z,t))+40*(Gt({{1,3/8},{1,1/8},{1,3/8},{1,-1/8}},-1/4+z,t))-40*(Gt({{1,3/8},{1,1/8},{1,3/8},{1,1/8}},-1/4+z,t))-40*(Gt({{1,3/8},{1,1/8},{1,3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,1/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,1/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,1/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,1/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,1/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-8*(Gt({{1,3/8},{1,3/8},{1,-3/8},{1,-3/8}},-1/4+z,t))-8*(Gt({{1,3/8},{1,3/8},{1,-3/8},{1,-1/8}},-1/4+z,t))+8*(Gt({{1,3/8},{1,3/8},{1,-3/8},{1,1/8}},-1/4+z,t))+8*(Gt({{1,3/8},{1,3/8},{1,-3/8},{1,3/8}},-1/4+z,t))-8*(Gt({{1,3/8},{1,3/8},{1,-1/8},{1,-3/8}},-1/4+z,t))-8*(Gt({{1,3/8},{1,3/8},{1,-1/8},{1,-1/8}},-1/4+z,t))+8*(Gt({{1,3/8},{1,3/8},{1,-1/8},{1,1/8}},-1/4+z,t))+8*(Gt({{1,3/8},{1,3/8},{1,-1/8},{1,3/8}},-1/4+z,t))+40*(Gt({{1,3/8},{1,3/8},{1,1/8},{1,-3/8}},-1/4+z,t))+40*(Gt({{1,3/8},{1,3/8},{1,1/8},{1,-1/8}},-1/4+z,t))-40*(Gt({{1,3/8},{1,3/8},{1,1/8},{1,1/8}},-1/4+z,t))-40*(Gt({{1,3/8},{1,3/8},{1,1/8},{1,3/8}},-1/4+z,t))+40*(Gt({{1,3/8},{1,3/8},{1,3/8},{1,-3/8}},-1/4+z,t))+40*(Gt({{1,3/8},{1,3/8},{1,3/8},{1,-1/8}},-1/4+z,t))-40*(Gt({{1,3/8},{1,3/8},{1,3/8},{1,1/8}},-1/4+z,t))-40*(Gt({{1,3/8},{1,3/8},{1,3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,3/8},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,3/8},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,3/8},{1,3/8},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,3/8},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+32*(Gt({{1,3/8},{1,3/8},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,1/2},{1,-3/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,1/2},{1,-3/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,1/2},{1,-3/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,1/2},{1,-3/8},{1,3/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,1/2},{1,-1/8},{1,-3/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,1/2},{1,-1/8},{1,-1/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,1/2},{1,-1/8},{1,1/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,1/2},{1,-1/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,1/2},{1,1/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,1/2},{1,1/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,1/2},{1,1/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,1/2},{1,1/8},{1,3/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,1/2},{1,3/8},{1,-3/8}},-1/4+z,t))+16*(Gt({{1,3/8},{1,1/2},{1,3/8},{1,-1/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,1/2},{1,3/8},{1,1/8}},-1/4+z,t))-16*(Gt({{1,3/8},{1,1/2},{1,3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,-1/4},{1,-3/8},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,-1/4},{1,-3/8},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,-1/4},{1,-3/8},{1,1/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,-1/4},{1,-3/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,-1/4},{1,-1/8},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,-1/4},{1,-1/8},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,-1/4},{1,-1/8},{1,1/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,-1/4},{1,-1/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,-1/4},{1,1/8},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,-1/4},{1,1/8},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,-1/4},{1,1/8},{1,1/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,-1/4},{1,1/8},{1,3/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,-1/4},{1,3/8},{1,-3/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,-1/4},{1,3/8},{1,-1/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,-1/4},{1,3/8},{1,1/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,-1/4},{1,3/8},{1,3/8}},-1/4+z,t))-64*(Gt({{1,1/2},{1,-1/4},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))-64*(Gt({{1,1/2},{1,-1/4},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))+64*(Gt({{1,1/2},{1,-1/4},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))+64*(Gt({{1,1/2},{1,-1/4},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))-64*(Gt({{1,1/2},{1,-1/4},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))-64*(Gt({{1,1/2},{1,-1/4},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))+64*(Gt({{1,1/2},{1,-1/4},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))+64*(Gt({{1,1/2},{1,-1/4},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,1/4},{1,-3/8},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,1/4},{1,-3/8},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,1/4},{1,-3/8},{1,1/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,1/4},{1,-3/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,1/4},{1,-1/8},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,1/4},{1,-1/8},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,1/4},{1,-1/8},{1,1/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,1/4},{1,-1/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,1/4},{1,1/8},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,1/4},{1,1/8},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,1/4},{1,1/8},{1,1/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,1/4},{1,1/8},{1,3/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,1/4},{1,3/8},{1,-3/8}},-1/4+z,t))-32*(Gt({{1,1/2},{1,1/4},{1,3/8},{1,-1/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,1/4},{1,3/8},{1,1/8}},-1/4+z,t))+32*(Gt({{1,1/2},{1,1/4},{1,3/8},{1,3/8}},-1/4+z,t))+64*(Gt({{1,1/2},{1,1/4},{1,-1/2+(-1/2)*(t)},{1,-3/8}},-1/4+z,t))+64*(Gt({{1,1/2},{1,1/4},{1,-1/2+(-1/2)*(t)},{1,-1/8}},-1/4+z,t))-64*(Gt({{1,1/2},{1,1/4},{1,-1/2+(-1/2)*(t)},{1,1/8}},-1/4+z,t))-64*(Gt({{1,1/2},{1,1/4},{1,-1/2+(-1/2)*(t)},{1,3/8}},-1/4+z,t))+64*(Gt({{1,1/2},{1,1/4},{1,(1/2)*(t)},{1,-3/8}},-1/4+z,t))+64*(Gt({{1,1/2},{1,1/4},{1,(1/2)*(t)},{1,-1/8}},-1/4+z,t))-64*(Gt({{1,1/2},{1,1/4},{1,(1/2)*(t)},{1,1/8}},-1/4+z,t))-64*(Gt({{1,1/2},{1,1/4},{1,(1/2)*(t)},{1,3/8}},-1/4+z,t))";
	ex input = parse(expr);

	timer clock;
	clock.start();
	const numeric output = Gt::ex_evaluate(input, &points);
	clock.stop();

	// Expected result (300 digit precision):
	// -735.92213007608412725408783483772090853621209805750601591458872039902125596093767639548538665511258645312569221105068721717331503185119873079322237413973912453917741955985588067349968755892776778373257493461870759572852674296459562853903941907043717509698670076902413720623317463551579655131668592853628523015
	// -3578.5563972789591920204032899668203047502938207399092748091389393494616709665237697715485510267899967246547128648005434562119710581522447976545703477836341150208471602072263049005885603875780240300164070341224878086646306031025440391993902423651003247920506722945041558546816993709444522532525067843167904584*I

	cout << "Output: " << output << endl;
	cout << "Time: " << clock.read() << "s" << endl;

	return 0;
}

extern void randomify_symbol_serials();

int main(int argc, char** argv)
{
	randomify_symbol_serials();

	// Take optional argument that specifies which tests to run
	uint32_t digit_goal = 17;
	if (argc > 1)
		std::sscanf(argv[1], "%u", &digit_goal);
	if (digit_goal < 17)
		digit_goal = 17; // compute at least to double precision
	Digits = digit_goal;

	const int select_test = 1;

	// expected timings for banana test:
	//  17 digits:  ~30s
	//  30 digits:  ~ 1m
	//  50 digits:  ~ 2m
	// 100 digits:  ~ 3m
	// 200 digits:  ~15m
	// 300 digits:  ~40m

	if (select_test == 0) {
		cout << "Running banana timing test with " << digit_goal << " digit precision" << endl;
		return time_banana();
	}

	// expected timings for Bhabha test:
	//  17 digits:  ~1.5m
	//  30 digits:  ~  3m
	//  50 digits:  ~  6m
	// 100 digits:  ~ 20m
	// 200 digits:  ~ 95m
	// 300 digits:  ~4.5h

	if (select_test == 1) {
		cout << "Running Bhabha timing test with " << digit_goal << " digit precision" << endl;
		return time_bhabha();
	}

	cout << "Not test selected" << endl;
	return 1;
}
