# -*- coding: utf-8 -*-

##--------------------------------------#######
#                  Erreurs                    #
##--------------------------------------#######
#    WxGeometrie
#    Dynamic geometry, graph plotter, and more for french mathematic teachers.
#    Copyright (C) 2005-2013  Nicolas Pourcelot
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

# version unicode


# généré par :
# import exceptions;l = ["    " + key + ": u\"\"\"" + val.__doc__ + "\"\"\"" for key, val in vars(exceptions).items() if not isinstance(val, basestring)];l.sort();print "messages = {\n" + ",\n".join(l) + "\n}"


messages = {
    ArithmeticError: """Erreur de calcul.""",
    AssertionError: """Assertion non vérifiée.""",
    AttributeError: """L'attribut n'existe pas.""",
    BaseException: """Common base class for all exceptions""",
    DeprecationWarning: """Base class for warnings about deprecated features.""",
    EOFError: """Read beyond end of file.""",
    EnvironmentError: """Base class for I/O related errors.""",
    Exception: """Common base class for all non-exit exceptions.""",
    FloatingPointError: """Erreur de calcul (flottants).""",
    FutureWarning: """Base class for warnings about constructs that will change semantically
in the future.""",
    GeneratorExit: """Request that a generator exit.""",
    IOError: """Impossible d'écrire sur le périphérique.""",
    ImportWarning: """Base class for warnings about probable mistakes in module imports""",
    ImportError: """Module introuvable.""",
    IndentationError: """Indentation incorrecte.""",
    IndexError: """Indexation incorrecte.""",
    KeyError: """Référence non trouvée (clé).""",
    KeyboardInterrupt: """Program interrupted by user.""",
    LookupError: """Base class for lookup errors.""",
    MemoryError: """Manque de mémoire.""",
    NameError: """Nom inconnu.""",
    NotImplementedError: """Method or function hasn't been implemented yet.""",
    OSError: """OS system call failed.""",
    OverflowError: """Le résultat est trop grand.""",
    PendingDeprecationWarning: """Base class for warnings about features which will be deprecated
in the future.""",
    ReferenceError: """Référence non trouvée (référence faible).""",
    RuntimeError: """Unspecified run-time error.""",
    RuntimeWarning: """Base class for warnings about dubious runtime behavior.""",
    StopIteration: """Fin d'itération.""",
    SyntaxError: """Erreur de syntaxe.""",
    SyntaxWarning: """Base class for warnings about dubious syntax.""",
    SystemError: """Internal error in the Python interpreter.""",
    SystemExit: """Request to exit from the interpreter.""",
    TabError: """Mélange de tabulations et d'espaces.""",
    TypeError: """Type d'argument incorrect.""",
    UnboundLocalError: """Référence à une variable non définie.""",
    UnicodeDecodeError: """Problème de décodage (caractères spéciaux).""",
    UnicodeEncodeError: """Problème d'encodage (caractères spéciaux).""",
    UnicodeError: """Erreur unicode (caractères spéciaux).""",
    UnicodeTranslateError: """Erreur unicode (caractères spéciaux).""",
    UnicodeWarning: """Problème d'encodage.""",
    UserWarning: """Base class for warnings generated by user code.""",
    ValueError: """Valeur incorrecte.""",
    Warning: """Base class for warning categories.""",
    ZeroDivisionError: """Division par zéro."""
}

try:
    messages[WindowsError] = """MS-Windows OS system call failed."""
except NameError: # non défini sous Linux par exemple
    pass

def message(erreur):
    try:
        super(erreur) # si ça marche, c'est une "classe", sinon, c'est une instance
        return messages.get(erreur, "Erreur inconnue.")
    except TypeError:
        return messages.get(type(erreur), "Erreur inconnue.")
