/// <reference types="react" />
export interface MenuListProps extends React.HTMLProps<HTMLUListElement> {
    /** Anything that can be rendered inside of menu list */
    children: React.ReactNode;
    /** Additional classes added to the menu list */
    className?: string;
    /** Indicates to assistive technologies whether more than one item can be selected
     * for a non-checkbox menu. Only applies when the menu's role is "listbox".
     */
    isAriaMultiselectable?: boolean;
    /** Adds an accessible name to the menu. */
    'aria-label'?: string;
}
export declare const MenuList: React.FunctionComponent<MenuListProps>;
//# sourceMappingURL=MenuList.d.ts.map