/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

public class mxFastOrganicLayout
extends mxGraphLayout {
    protected boolean useInputOrigin = true;
    protected boolean resetEdges = true;
    protected boolean disableEdgeStyle = true;
    protected double forceConstant = 50.0;
    protected double forceConstantSquared = 0.0;
    protected double minDistanceLimit = 2.0;
    protected double minDistanceLimitSquared = 0.0;
    protected double initialTemp = 200.0;
    protected double temperature = 0.0;
    protected int maxIterations = 0;
    protected int iteration = 0;
    protected Object[] vertexArray;
    protected double[] dispX;
    protected double[] dispY;
    protected double[][] cellLocation;
    protected double[] radius;
    protected double[] radiusSquared;
    protected boolean[] isMoveable;
    protected int[][] neighbours;
    protected boolean allowedToRun = true;
    protected Hashtable<Object, Integer> indices = new Hashtable();

    public mxFastOrganicLayout(mxGraph mxGraph2) {
        super(mxGraph2);
    }

    @Override
    public boolean isVertexIgnored(Object object) {
        return super.isVertexIgnored(object) || this.graph.getConnections(object).length == 0;
    }

    public boolean isUseInputOrigin() {
        return this.useInputOrigin;
    }

    public void setUseInputOrigin(boolean bl) {
        this.useInputOrigin = bl;
    }

    public boolean isResetEdges() {
        return this.resetEdges;
    }

    public void setResetEdges(boolean bl) {
        this.resetEdges = bl;
    }

    public boolean isDisableEdgeStyle() {
        return this.disableEdgeStyle;
    }

    public void setDisableEdgeStyle(boolean bl) {
        this.disableEdgeStyle = bl;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public double getForceConstant() {
        return this.forceConstant;
    }

    public void setForceConstant(double d) {
        this.forceConstant = d;
    }

    public double getMinDistanceLimit() {
        return this.minDistanceLimit;
    }

    public void setMinDistanceLimit(double d) {
        this.minDistanceLimit = d;
    }

    public double getInitialTemp() {
        return this.initialTemp;
    }

    public void setInitialTemp(double d) {
        this.initialTemp = d;
    }

    protected void reduceTemperature() {
        this.temperature = this.initialTemp * (1.0 - (double)(this.iteration / this.maxIterations));
    }

    @Override
    public void moveCell(Object object, double d, double d2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Object object) {
        double d;
        double d2;
        Object[] objectArray;
        Object object2;
        int n;
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        Object[] objectArray2 = this.graph.getChildVertices(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray2.length);
        for (int i = 0; i < objectArray2.length; ++i) {
            if (this.isVertexIgnored(objectArray2[i])) continue;
            arrayList.add(objectArray2[i]);
        }
        this.vertexArray = arrayList.toArray();
        mxRectangle mxRectangle2 = this.useInputOrigin ? this.graph.getBoundsForCells(this.vertexArray, false, false, true) : null;
        int n2 = this.vertexArray.length;
        this.dispX = new double[n2];
        this.dispY = new double[n2];
        this.cellLocation = new double[n2][];
        this.isMoveable = new boolean[n2];
        this.neighbours = new int[n2][];
        this.radius = new double[n2];
        this.radiusSquared = new double[n2];
        this.minDistanceLimitSquared = this.minDistanceLimit * this.minDistanceLimit;
        if (this.forceConstant < 0.001) {
            this.forceConstant = 0.001;
        }
        this.forceConstantSquared = this.forceConstant * this.forceConstant;
        for (n = 0; n < this.vertexArray.length; ++n) {
            object2 = this.vertexArray[n];
            this.cellLocation[n] = new double[2];
            this.indices.put(object2, new Integer(n));
            objectArray = this.getVertexBounds(object2);
            double d3 = objectArray.getWidth();
            d2 = objectArray.getHeight();
            d = objectArray.getX();
            double d4 = objectArray.getY();
            this.cellLocation[n][0] = d + d3 / 2.0;
            this.cellLocation[n][1] = d4 + d2 / 2.0;
            this.radius[n] = Math.min(d3, d2);
            this.radiusSquared[n] = this.radius[n] * this.radius[n];
        }
        mxIGraphModel2.beginUpdate();
        try {
            double d5;
            Serializable serializable;
            for (n = 0; n < n2; ++n) {
                this.dispX[n] = 0.0;
                this.dispY[n] = 0.0;
                this.isMoveable[n] = this.isVertexMovable(this.vertexArray[n]);
                object2 = this.graph.getConnections(this.vertexArray[n], object);
                for (int i = 0; i < ((Object[])object2).length; ++i) {
                    if (this.isResetEdges()) {
                        this.graph.resetEdge(object2[i]);
                    }
                    if (!this.isDisableEdgeStyle()) continue;
                    this.setEdgeStyleEnabled(object2[i], false);
                }
                objectArray = this.graph.getOpposites((Object[])object2, this.vertexArray[n]);
                this.neighbours[n] = new int[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    serializable = this.indices.get(objectArray[i]);
                    this.neighbours[n][i] = serializable != null ? (Integer)serializable : n;
                }
            }
            this.temperature = this.initialTemp;
            if (this.maxIterations == 0) {
                this.maxIterations = (int)(20.0 * Math.sqrt(n2));
            }
            this.iteration = 0;
            while (this.iteration < this.maxIterations) {
                if (!this.allowedToRun) {
                    return;
                }
                this.calcRepulsion();
                this.calcAttraction();
                this.calcPositions();
                this.reduceTemperature();
                ++this.iteration;
            }
            Double d6 = null;
            object2 = null;
            for (int i = 0; i < this.vertexArray.length; ++i) {
                Object object3 = this.vertexArray[i];
                serializable = mxIGraphModel2.getGeometry(object3);
                if (serializable == null) continue;
                double[] dArray = this.cellLocation[i];
                dArray[0] = dArray[0] - ((mxRectangle)serializable).getWidth() / 2.0;
                double[] dArray2 = this.cellLocation[i];
                dArray2[1] = dArray2[1] - ((mxRectangle)serializable).getHeight() / 2.0;
                d2 = this.graph.snap(this.cellLocation[i][0]);
                d = this.graph.snap(this.cellLocation[i][1]);
                this.setVertexLocation(object3, d2, d);
                d6 = d6 == null ? new Double(d2) : new Double(Math.min(d6, d2));
                object2 = object2 == null ? new Double(d) : new Double(Math.min(object2.doubleValue(), d));
            }
            double d7 = d6 != null ? -d6.doubleValue() - 1.0 : 0.0;
            double d8 = d5 = object2 != null ? -object2.doubleValue() - 1.0 : 0.0;
            if (mxRectangle2 != null) {
                d7 += mxRectangle2.getX();
                d5 += mxRectangle2.getY();
            }
            this.graph.moveCells(this.vertexArray, d7, d5);
        }
        finally {
            mxIGraphModel2.endUpdate();
        }
    }

    protected void calcPositions() {
        for (int i = 0; i < this.vertexArray.length; ++i) {
            if (!this.isMoveable[i]) continue;
            double d = Math.sqrt(this.dispX[i] * this.dispX[i] + this.dispY[i] * this.dispY[i]);
            if (d < 0.001) {
                d = 0.001;
            }
            double d2 = this.dispX[i] / d * Math.min(d, this.temperature);
            double d3 = this.dispY[i] / d * Math.min(d, this.temperature);
            this.dispX[i] = 0.0;
            this.dispY[i] = 0.0;
            double[] dArray = this.cellLocation[i];
            dArray[0] = dArray[0] + d2;
            double[] dArray2 = this.cellLocation[i];
            dArray2[1] = dArray2[1] + d3;
        }
    }

    protected void calcAttraction() {
        for (int i = 0; i < this.vertexArray.length; ++i) {
            for (int j = 0; j < this.neighbours[i].length; ++j) {
                int n = this.neighbours[i][j];
                if (i == n) continue;
                double d = this.cellLocation[i][0] - this.cellLocation[n][0];
                double d2 = this.cellLocation[i][1] - this.cellLocation[n][1];
                double d3 = d * d + d2 * d2 - this.radiusSquared[i] - this.radiusSquared[n];
                if (d3 < this.minDistanceLimitSquared) {
                    d3 = this.minDistanceLimitSquared;
                }
                double d4 = Math.sqrt(d3);
                double d5 = d3 / this.forceConstant;
                double d6 = d / d4 * d5;
                double d7 = d2 / d4 * d5;
                if (this.isMoveable[i]) {
                    int n2 = i;
                    this.dispX[n2] = this.dispX[n2] - d6;
                    int n3 = i;
                    this.dispY[n3] = this.dispY[n3] - d7;
                }
                if (!this.isMoveable[n]) continue;
                int n4 = n;
                this.dispX[n4] = this.dispX[n4] + d6;
                int n5 = n;
                this.dispY[n5] = this.dispY[n5] + d7;
            }
        }
    }

    protected void calcRepulsion() {
        int n = this.vertexArray.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                double d;
                double d2;
                if (!this.allowedToRun) {
                    return;
                }
                if (j == i) continue;
                double d3 = this.cellLocation[i][0] - this.cellLocation[j][0];
                double d4 = this.cellLocation[i][1] - this.cellLocation[j][1];
                if (d3 == 0.0) {
                    d3 = 0.01 + Math.random();
                }
                if (d4 == 0.0) {
                    d4 = 0.01 + Math.random();
                }
                if ((d2 = (d = Math.sqrt(d3 * d3 + d4 * d4)) - this.radius[i] - this.radius[j]) < this.minDistanceLimit) {
                    d2 = this.minDistanceLimit;
                }
                double d5 = this.forceConstantSquared / d2;
                double d6 = d3 / d * d5;
                double d7 = d4 / d * d5;
                if (this.isMoveable[i]) {
                    int n2 = i;
                    this.dispX[n2] = this.dispX[n2] + d6;
                    int n3 = i;
                    this.dispY[n3] = this.dispY[n3] + d7;
                }
                if (!this.isMoveable[j]) continue;
                int n4 = j;
                this.dispX[n4] = this.dispX[n4] - d6;
                int n5 = j;
                this.dispY[n5] = this.dispY[n5] - d7;
            }
        }
    }
}

