/*
 * Decompiled with CFR 0.152.
 */
package sleep.runtime;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.SleepClosure;
import sleep.bridges.io.IOObject;
import sleep.engine.Block;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.interfaces.Function;
import sleep.interfaces.Variable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptVariables;
import sleep.runtime.SleepUtils;

public class ScriptInstance
implements Serializable,
Runnable {
    protected String name = "Script";
    protected boolean loaded;
    protected LinkedList watchers = new LinkedList();
    protected ScriptEnvironment environment;
    protected ScriptVariables variables;
    protected SleepClosure script;
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_SHOW_ERRORS = 1;
    public static final int DEBUG_SHOW_WARNINGS = 2;
    public static final int DEBUG_REQUIRE_STRICT = 4;
    public static final int DEBUG_TRACE_CALLS = 8;
    public static final int DEBUG_TRACE_PROFILE_ONLY = 24;
    protected static final int DEBUG_TRACE_SUPPRESS = 16;
    public static final int DEBUG_THROW_WARNINGS = 34;
    public static final int DEBUG_TRACE_LOGIC = 64;
    public static final int DEBUG_TRACE_TAINT = 128;
    protected int debug = 1;
    protected long loadTime = System.currentTimeMillis();
    protected List sourceFiles = new LinkedList();
    protected IOObject parent = null;

    public void associateFile(File file) {
        if (file.exists()) {
            this.sourceFiles.add(file);
        }
    }

    public boolean hasChanged() {
        Iterator iterator = this.sourceFiles.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (file.lastModified() <= this.loadTime) continue;
            return true;
        }
        return false;
    }

    public void setDebugFlags(int n) {
        this.debug = n;
    }

    public int getDebugFlags() {
        return this.debug;
    }

    public ScriptInstance(Hashtable hashtable) {
        this(null, hashtable);
    }

    public ScriptInstance(Variable variable, Hashtable hashtable) {
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.variables = variable == null ? new ScriptVariables() : new ScriptVariables(variable);
        this.environment = new ScriptEnvironment(hashtable, this);
        this.loaded = true;
    }

    public void installBlock(Block block) {
        this.script = new SleepClosure(this, block);
    }

    public ScriptInstance() {
        this(null, null);
    }

    public ScriptEnvironment getScriptEnvironment() {
        return this.environment;
    }

    public void setScriptVariables(ScriptVariables scriptVariables) {
        this.variables = scriptVariables;
    }

    public ScriptVariables getScriptVariables() {
        return this.variables;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Scalar runScript() {
        return SleepUtils.runCode(this.script, null, this, null);
    }

    public void recordStackFrame(String string, String string2, int n) {
        LinkedList<SleepStackElement> linkedList = (LinkedList<SleepStackElement>)this.getScriptEnvironment().getEnvironment().get("%strace%");
        if (linkedList == null) {
            linkedList = new LinkedList<SleepStackElement>();
            this.getScriptEnvironment().getEnvironment().put("%strace%", linkedList);
        }
        SleepStackElement sleepStackElement = new SleepStackElement();
        sleepStackElement.sourcefile = string2;
        sleepStackElement.description = string;
        sleepStackElement.lineNumber = n;
        linkedList.add(0, sleepStackElement);
    }

    public File cwd() {
        if (!this.getMetadata().containsKey("__CWD__")) {
            this.chdir(null);
        }
        return (File)this.getMetadata().get("__CWD__");
    }

    public void chdir(File file) {
        if (file == null) {
            file = new File("");
        }
        this.getMetadata().put("__CWD__", file.getAbsoluteFile());
    }

    public void recordStackFrame(String string, int n) {
        this.recordStackFrame(string, this.getScriptEnvironment().getCurrentSource(), n);
    }

    public void clearStackTrace() {
        LinkedList linkedList = new LinkedList();
        this.getScriptEnvironment().getEnvironment().put("%strace%", linkedList);
    }

    public List getStackTrace() {
        LinkedList linkedList = (LinkedList)this.getScriptEnvironment().getEnvironment().get("%strace%");
        this.clearStackTrace();
        if (linkedList == null) {
            linkedList = new LinkedList();
        }
        return linkedList;
    }

    public long total() {
        Long l = (Long)this.getMetadata().get("%total%");
        return l == null ? 0L : l;
    }

    public void collect(String string, int n, long l) {
        ProfilerStatistic profilerStatistic;
        HashMap<String, ProfilerStatistic> hashMap = (HashMap<String, ProfilerStatistic>)this.getMetadata().get("%statistics%");
        Long l2 = (Long)this.getMetadata().get("%total%");
        if (hashMap == null) {
            hashMap = new HashMap<String, ProfilerStatistic>();
            l2 = new Long(0L);
            this.getMetadata().put("%statistics%", hashMap);
            this.getMetadata().put("%total%", l2);
        }
        if ((profilerStatistic = (ProfilerStatistic)hashMap.get(string)) == null) {
            profilerStatistic = new ProfilerStatistic();
            profilerStatistic.functionName = string;
            hashMap.put(string, profilerStatistic);
        }
        profilerStatistic.ticks += l;
        ++profilerStatistic.calls;
        this.getMetadata().put("%total%", new Long(l2 + l));
    }

    public boolean isProfileOnly() {
        return (this.getDebugFlags() & 0x18) == 24;
    }

    public List getProfilerStatistics() {
        Map map2 = (Map)this.getMetadata().get("%statistics%");
        if (map2 != null) {
            LinkedList linkedList = new LinkedList(map2.values());
            Collections.sort(linkedList);
            return linkedList;
        }
        return new LinkedList();
    }

    public Map getMetadata() {
        Scalar scalar = this.getScriptVariables().getGlobalVariables().getScalar("__meta__");
        Map map2 = null;
        if (scalar == null) {
            map2 = Collections.synchronizedMap(new HashMap());
            this.getScriptVariables().getGlobalVariables().putScalar("__meta__", SleepUtils.getScalar(map2));
        } else {
            map2 = (Map)scalar.objectValue();
        }
        return map2;
    }

    public void printProfileStatistics(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        Iterator iterator = this.getProfilerStatistics().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            printWriter.println(string);
        }
    }

    public void makeSafe() {
        Hashtable hashtable = this.environment.getEnvironment();
        Hashtable hashtable2 = new Hashtable(hashtable.size() * 2 - 1);
        Iterator iterator = hashtable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey().toString().charAt(0) == '&' && entry.getValue() instanceof SleepClosure) {
                SleepClosure sleepClosure = new SleepClosure(this, ((SleepClosure)entry.getValue()).getRunnableCode());
                hashtable2.put(entry.getKey(), sleepClosure);
                continue;
            }
            hashtable2.put(entry.getKey(), (SleepClosure)entry.getValue());
        }
        this.environment.setEnvironment(hashtable2);
    }

    public ScriptInstance fork() {
        ScriptInstance scriptInstance = new ScriptInstance(this.variables.getGlobalVariables().createInternalVariableContainer(), this.environment.getEnvironment());
        scriptInstance.makeSafe();
        scriptInstance.setName(this.getName());
        scriptInstance.setDebugFlags(this.getDebugFlags());
        scriptInstance.watchers = this.watchers;
        scriptInstance.getScriptVariables().getGlobalVariables().putScalar("__meta__", SleepUtils.getScalar(this.getMetadata()));
        return scriptInstance;
    }

    public void run() {
        Scalar scalar = this.runScript();
        if (this.parent != null) {
            this.parent.setToken(scalar);
        }
    }

    public void setParent(IOObject iOObject) {
        this.parent = iOObject;
    }

    public Block getRunnableBlock() {
        return this.script.getRunnableCode();
    }

    public SleepClosure getRunnableScript() {
        return this.script;
    }

    public Scalar callFunction(String string, Stack stack) {
        Function function2 = this.getScriptEnvironment().getFunction(string);
        if (function2 == null) {
            return null;
        }
        Scalar scalar = function2.evaluate(string, this, stack);
        this.getScriptEnvironment().resetEnvironment();
        return scalar;
    }

    public void setUnloaded() {
        this.loaded = false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void addWarningWatcher(RuntimeWarningWatcher runtimeWarningWatcher) {
        this.watchers.add(runtimeWarningWatcher);
    }

    public void removeWarningWatcher(RuntimeWarningWatcher runtimeWarningWatcher) {
        this.watchers.remove(runtimeWarningWatcher);
    }

    public void fireWarning(String string, int n) {
        this.fireWarning(string, n, false);
    }

    public void fireWarning(String string, int n, boolean bl) {
        if (!(this.debug == 0 || bl && (this.getDebugFlags() & 0x10) == 16)) {
            ScriptWarning scriptWarning = new ScriptWarning(this, string, n, bl);
            Iterator iterator = this.watchers.iterator();
            while (iterator.hasNext()) {
                ((RuntimeWarningWatcher)iterator.next()).processScriptWarning(scriptWarning);
            }
        }
    }

    public static class ProfilerStatistic
    implements Comparable,
    Serializable {
        public String functionName;
        public long ticks = 0L;
        public long calls = 0L;

        public int compareTo(Object object) {
            return (int)(((ProfilerStatistic)object).ticks - this.ticks);
        }

        public String toString() {
            return (double)this.ticks / 1000.0 + "s " + this.calls + " " + this.functionName;
        }
    }

    public static class SleepStackElement
    implements Serializable {
        public String sourcefile;
        public String description;
        public int lineNumber;

        public String toString() {
            return "   " + new File(this.sourcefile).getName() + ":" + this.lineNumber + " " + this.description;
        }
    }
}

