/*
 * Decompiled with CFR 0.152.
 */
package sleep.engine.atoms;

import sleep.engine.Block;
import sleep.engine.CallRequest;
import sleep.engine.Step;
import sleep.interfaces.Function;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class Call
extends Step {
    String function;

    public Call(String string) {
        this.function = string;
    }

    public String toString(String string) {
        return string + "[Function Call]: " + this.function + "\n";
    }

    public Scalar evaluate(ScriptEnvironment scriptEnvironment) {
        Function function2 = scriptEnvironment.getFunction(this.function);
        Block block = null;
        if (function2 != null) {
            CallRequest.FunctionCallRequest functionCallRequest = new CallRequest.FunctionCallRequest(scriptEnvironment, this.getLineNumber(), this.function, function2);
            functionCallRequest.CallFunction();
        } else {
            block = scriptEnvironment.getBlock(this.function);
            if (block != null) {
                CallRequest.InlineCallRequest inlineCallRequest = new CallRequest.InlineCallRequest(scriptEnvironment, this.getLineNumber(), this.function, block);
                inlineCallRequest.CallFunction();
            } else {
                scriptEnvironment.getScriptInstance().fireWarning("Attempted to call non-existent function " + this.function, this.getLineNumber());
                scriptEnvironment.FrameResult(SleepUtils.getEmptyScalar());
            }
        }
        return null;
    }
}

