/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.SleepUtils;

public class IOObject {
    protected InputStreamReader readeru = null;
    protected DataInputStream readerb = null;
    protected BufferedInputStream reader = null;
    protected InputStream in = null;
    protected OutputStreamWriter writeru = null;
    protected DataOutputStream writerb = null;
    protected OutputStream out = null;
    protected Thread thread = null;
    protected Scalar token = null;
    private boolean stripTheLineSeparator = false;
    private static final String lineSeparator = System.getProperty("line.separator");

    public Object getSource() {
        return null;
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        if (this.writerb != null) {
            this.writeru = new OutputStreamWriter((OutputStream)this.writerb, string);
        }
        if (this.readerb != null) {
            this.readeru = new InputStreamReader((InputStream)this.readerb, string);
        }
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Scalar wait(ScriptEnvironment scriptEnvironment, long l) {
        if (this.getThread() != null && this.getThread().isAlive()) {
            try {
                this.getThread().join(l);
                if (this.getThread().isAlive()) {
                    scriptEnvironment.flagError(new IOException("wait on object timed out"));
                    return SleepUtils.getEmptyScalar();
                }
            }
            catch (Exception exception) {
                scriptEnvironment.flagError(exception);
                return SleepUtils.getEmptyScalar();
            }
        }
        return this.getToken();
    }

    public Scalar getToken() {
        if (this.token == null) {
            return SleepUtils.getEmptyScalar();
        }
        return this.token;
    }

    public void setToken(Scalar scalar) {
        this.token = scalar;
    }

    public static void setConsole(ScriptEnvironment scriptEnvironment, IOObject iOObject) {
        scriptEnvironment.getScriptInstance().getMetadata().put("%console%", iOObject);
    }

    public static IOObject getConsole(ScriptEnvironment scriptEnvironment) {
        IOObject iOObject = (IOObject)scriptEnvironment.getScriptInstance().getMetadata().get("%console%");
        if (iOObject == null) {
            iOObject = new IOObject();
            iOObject.openRead(System.in);
            iOObject.openWrite(System.out);
            IOObject.setConsole(scriptEnvironment, iOObject);
        }
        return iOObject;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void openRead(InputStream inputStream) {
        this.in = inputStream;
        if (this.in != null) {
            this.reader = new BufferedInputStream(this.in, 8192);
            this.readerb = new DataInputStream(this.reader);
            this.readeru = new InputStreamReader(this.readerb);
        }
    }

    public void openWrite(OutputStream outputStream) {
        this.out = outputStream;
        if (this.out != null) {
            this.writerb = new DataOutputStream(this.out);
            this.writeru = new OutputStreamWriter(this.writerb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.in != null) {
                this.in.notifyAll();
            }
            if (this.out != null) {
                this.out.notifyAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.readeru != null) {
                this.readeru.close();
            }
            if (this.writeru != null) {
                this.writeru.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.readerb != null) {
                this.readerb.close();
            }
            if (this.writerb != null) {
                this.writerb.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.in = null;
            this.out = null;
            this.reader = null;
            this.readerb = null;
            this.writerb = null;
            this.readeru = null;
            this.writeru = null;
        }
    }

    public String readLine() {
        try {
            if (this.readeru != null) {
                StringBuffer stringBuffer = new StringBuffer(8192);
                int n = this.readeru.read();
                if (this.stripTheLineSeparator && n == 10) {
                    n = this.readeru.read();
                }
                this.stripTheLineSeparator = false;
                while (n != -1) {
                    if (n == 10) {
                        return stringBuffer.toString();
                    }
                    if (n == 13) {
                        this.stripTheLineSeparator = true;
                        return stringBuffer.toString();
                    }
                    stringBuffer.append((char)n);
                    n = this.readeru.read();
                }
                this.close();
                if (stringBuffer.length() > 0) {
                    return stringBuffer.toString();
                }
                return null;
            }
        }
        catch (Exception exception) {
            this.close();
        }
        return null;
    }

    public String readCharacter() {
        block3: {
            try {
                if (this.readeru == null) break block3;
                int n = this.readeru.read();
                if (n == -1) {
                    this.close();
                    break block3;
                }
                return (char)n + "";
            }
            catch (Exception exception) {
                this.close();
            }
        }
        return null;
    }

    public boolean isEOF() {
        return this.reader == null;
    }

    public void sendEOF() {
        try {
            if (this.writerb != null) {
                this.writerb.close();
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BufferedInputStream getInputBuffer() {
        return this.reader;
    }

    public DataInputStream getReader() {
        return this.readerb;
    }

    public DataOutputStream getWriter() {
        return this.writerb;
    }

    public void printLine(String string) {
        this.print(string + lineSeparator);
    }

    public void print(String string) {
        try {
            if (this.writeru != null) {
                this.writeru.write(string, 0, string.length());
                this.writeru.flush();
            }
        }
        catch (Exception exception) {
            this.close();
        }
    }
}

