## TFSA-2022-016: Undefined behavior in `SparseTensorSliceDataset`

### CVE Number
CVE-2022-21736

### Impact
The [implementation of `SparseTensorSliceDataset`](https://github.com/tensorflow/tensorflow/blob/5100e359aef5c8021f2e71c7b986420b85ce7b3d/tensorflow/core/kernels/data/sparse_tensor_slice_dataset_op.cc#L227-L292) has an undefined behavior: under certain condition it can be made to dereference a `nullptr` value:

```python
import tensorflow as tf
import numpy as np

tf.raw_ops.SparseTensorSliceDataset(
  indices=[[]],
  values=[],
  dense_shape=[1,1])
```

The 3 input arguments represent a sparse tensor. However, there are some preconditions that these arguments must satisfy but these are not validated in the implementation.

### Patches
We have patched the issue in GitHub commit [965b97e4a9650495cda5a8c210ef6684b4b9eceb](https://github.com/tensorflow/tensorflow/commit/965b97e4a9650495cda5a8c210ef6684b4b9eceb).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by Faysal Hossain Shezan from University of Virginia.
