/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the documentation of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

//! [0]
QSet<QString> set;
//! [0]


//! [1]
set.insert("one");
set.insert("three");
set.insert("seven");
//! [1]


//! [2]
set << "twelve" << "fifteen" << "nineteen";
//! [2]


//! [3]
if (!set.contains("ninety-nine"))
    ...
//! [3]


//! [4]
QSetIterator<QWidget *> i(set);
while (i.hasNext()) {
    QWidget *w = i.next();
    qDebug() << w;
}
//! [4]


//! [5]
QSet<QWidget *>::const_iterator i = set.constBegin();
while (i != set.constEnd()) {
    qDebug() << *i;
    ++i;
}
//! [5]


//! [6]
QSet<QString> set;
...
foreach (const QString &value, set)
    qDebug() << value;
//! [6]


//! [7]
QSet<QString> set;
set.reserve(20000);
for (int i = 0; i < 20000; ++i)
    set.insert(values[i]);
//! [7]


//! [8]
QSet<QString> set;
set << "January" << "February" << ... << "December";

QSet<QString>::iterator i;
for (i = set.begin(); i != set.end(); ++i)
    qDebug() << *i;
//! [8]


//! [9]
QSet<QString> set;
set << "January" << "February" << ... << "December";

QSet<QString>::iterator i = set.begin();
while (i != set.end()) {
    if ((*i).startsWith('J')) {
        i = set.erase(i);
    } else {
        ++i;
    }
}
//! [9]


//! [10]
QSet<QString> set;
...
const auto predicate = [](const QString &s) { return s.compare("Jeanette", Qt::CaseInsensitive) == 0; };
QSet<QString>::iterator it = std::find_if(set.begin(), set.end(), predicate);
if (it != set.end())
    cout << "Found Jeanette" << endl;
//! [10]


//! [11]
QSet<QString> set;
set << "January" << "February" << ... << "December";

QSet<QString>::const_iterator i;
for (i = set.begin(); i != set.end(); ++i)
    qDebug() << *i;
//! [11]


//! [12]
QSet<QString> set;
...
const auto predicate = [](const QString &s) { return s.compare("Jeanette", Qt::CaseInsensitive) == 0; };
QSet<QString>::const_iterator it = std::find_if(set.cbegin(), set.cend(), predicate);
if (it != set.constEnd())
    cout << "Found Jeanette" << endl;
//! [12]
