# frozen_string_literal: true

class BackfillVulnerabilityFeedbackPipelineIdBigint < Gitlab::Database::Migration[2.2]
  restrict_gitlab_migration gitlab_schema: :gitlab_main
  milestone '16.11'

  TABLE = :vulnerability_feedback
  COLUMN = :pipeline_id

  def up
    Gitlab::Database::QueryAnalyzers::Base.suppress_schema_issues_for_decomposed_tables do
      backfill_conversion_of_integer_to_bigint(TABLE, COLUMN)
    end
  end

  def down
    Gitlab::Database::QueryAnalyzers::Base.suppress_schema_issues_for_decomposed_tables do
      revert_backfill_conversion_of_integer_to_bigint(TABLE, COLUMN)
    end
  end
end
