/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.impl.engine;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionFragment;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessageEnd;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObMessageSortEnum;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IInternalTransition;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IRegion;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateVertex;
import com.modeliosoft.modelio.api.model.uml.behavior.state.ITransition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IAttributeLink;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.api.model.uml.statik.IProvidedInterface;
import com.modeliosoft.modelio.api.model.uml.statik.IRequiredInterface;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.IObListFilter;
import com.modeliosoft.modelio.api.utils.NameFilter;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.TagTypeNotFoundException;
import com.modeliosoft.modelio.modelingwizard.gui.AttributeCreationWizard;
import com.modeliosoft.modelio.modelingwizard.gui.ClassifierCreationWizard;
import com.modeliosoft.modelio.modelingwizard.gui.ConfirmDialog;
import com.modeliosoft.modelio.modelingwizard.gui.InputDialog;
import com.modeliosoft.modelio.modelingwizard.impl.engine.ModelingWizardException;
import com.modeliosoft.modelio.modelingwizard.utils.ModelingWizardDlg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class InstanceUpdater {
    private Shell obj = null;

    public InstanceUpdater() {
        if (System.getProperty("os.name").equals("Linux")) {
            this.obj = null;
        } else {
            Display dipslay = Display.getCurrent();
            if (dipslay == null) {
                dipslay = Display.getDefault();
            }
            this.obj = dipslay.getActiveShell();
        }
    }

    public boolean createAttribute(IModelingSession session, IAttributeLink current) throws ModelingWizardException {
        String attName;
        IClassifier base;
        String aName = current.getName();
        IAttribute att = current.getBase();
        if (att != null) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createAttribute.existingBase", aName));
        }
        IInstance inst = current.getAttributed();
        if (inst.getBase() == null && this.createClassifierWithOptions(session, inst, false) == null) {
            return false;
        }
        if (inst.getBase() instanceof IClassifier) {
            base = (IClassifier)inst.getBase();
            attName = InputDialog.showInputDialog(this.obj, ModelingWizardDlg.getString("mdac.gui.process.attributeName"), ModelingWizardDlg.getString("mdac.gui.process.chooseName"), aName);
            if (attName == null || attName.equals("")) {
                return false;
            }
            if (base.getPart(IAttribute.class).select((IObListFilter)new NameFilter(attName)).size() != 0) {
                throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createAttribute.existing", aName));
            }
        } else {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createAttribute.baseType", aName));
        }
        att = session.getModel().createAttribute(attName, (IGeneralClass)session.getModel().getUmlTypes().getUNDEFINED(), base);
        current.setBase(att);
        return true;
    }

    public boolean createClassifier(IModelingSession session, IInstance current) throws ModelingWizardException {
        return this.createClassifierWithOptions(session, current, true) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateInternalStructure(IModelingSession session, IClass current) throws ModelingWizardException {
        for (IBindableInstance inst : current.getInternalStructure()) {
            if (inst instanceof IPort) continue;
            IClassifier instanciedClass = null;
            if (inst.getBase() != null) {
                if (!(inst.getBase() instanceof IClassifier)) throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createInternalStructure.baseType", inst.getName()));
                instanciedClass = (IClassifier)inst.getBase();
            } else {
                ConfirmDialog.Values res = ConfirmDialog.showConfirmDialog(this.obj, ModelingWizardDlg.getString("mdac.gui.process.updateFromClass", inst.getName()), ModelingWizardDlg.getString("mdac.gui.process.choose"));
                if (res == ConfirmDialog.Values.YES_OPTION) {
                    this.updatePartFromInstanciedClassifier(session, (IInstance)inst);
                    instanciedClass = (IClassifier)inst.getBase();
                } else if (res == ConfirmDialog.Values.NO_OPTION) {
                    instanciedClass = this.createClassifierWithOptions(session, (IInstance)inst, true);
                }
            }
            if (inst.getBase() == null) throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createInternalStructure.nothing", inst.getName()));
            this.updatePartFromInstanciedClassifier(session, (IInstance)inst, instanciedClass);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean createOperation(IModelingSession session, IMessage current) throws ModelingWizardException {
        IOperation op = current.getInvoked();
        if (op != null) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createOperation.existing", op.getName()));
        }
        ILifeline lifeline = (ILifeline)current.getReceiveEvent().getCovered().get(0);
        IInstance occurence = lifeline.getRepresented();
        if (occurence == null) {
            this.createInstanceAndClassifier(session, lifeline);
            occurence = lifeline.getRepresented();
            if (occurence == null) {
                return false;
            }
        }
        IClassifier base = null;
        if (occurence.getBase() == null) {
            if (this.createClassifierWithOptions(session, occurence, false) == null) {
                return false;
            }
            if (!(occurence.getBase() instanceof IClassifier)) throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createOperation.baseType", occurence.getName()));
            base = (IClassifier)occurence.getBase();
        } else {
            if (!(occurence.getBase() instanceof IClassifier)) throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createOperation.baseType", occurence.getName()));
            base = (IClassifier)occurence.getBase();
        }
        String opName = InputDialog.showInputDialog(this.obj, ModelingWizardDlg.getString("mdac.gui.process.operationName"), ModelingWizardDlg.getString("mdac.gui.process.chooseName"), current.getName());
        if (opName == null || opName.equals("")) return true;
        op = base.getPart().select((IObListFilter)new NameFilter(opName)).size() == 0 ? session.getModel().createOperation(opName, base) : (IOperation)base.getPart().select((IObListFilter)new NameFilter(opName)).get(0);
        current.setInvoked(op);
        return true;
    }

    public boolean createOperation(IModelingSession session, ITransition current) throws ModelingWizardException {
        IClassifier o;
        IOperation op = current.getProcessed();
        if (op != null) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createOperationFromTransition.existing", op.getName()));
        }
        INameSpace ret = this.getStateContainer(current);
        if (ret instanceof IClassifier) {
            o = (IClassifier)ret;
        } else {
            String className = InputDialog.showInputDialog(this.obj, ModelingWizardDlg.getString("mdac.gui.process.className"), ModelingWizardDlg.getString("mdac.gui.process.chooseExistingName"), "Class");
            if (className != null && className.length() > 0) {
                o = session.getModel().createClass();
                o.setOwner((IModelTree)ret);
                o.setName(className);
            } else {
                o = null;
            }
        }
        if (o != null) {
            String opName = InputDialog.showInputDialog(this.obj, ModelingWizardDlg.getString("mdac.gui.process.operationName"), ModelingWizardDlg.getString("mdac.gui.process.chooseName"), current.getName());
            if (opName != null && !opName.equals("")) {
                Iterator iterator = o.getPart(IOperation.class).select((IObListFilter)new NameFilter(opName)).iterator();
                while (iterator.hasNext()) {
                    IOperation tmp;
                    op = tmp = (IOperation)iterator.next();
                }
                if (op == null) {
                    op = session.getModel().createOperation(opName, o);
                }
                current.setProcessed(op);
                current.setEffect("");
                return true;
            }
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createOperationFromTransition.noOperationPossible"));
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updatePartFromInstanciedClassifier(IModelingSession session, IInstance current) throws ModelingWizardException {
        if (current.getBase() != null) {
            if (!(current.getBase() instanceof IClassifier)) throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.updatePartFromInstanciedClass.baseType", current.getName()));
            IClassifier base = (IClassifier)current.getBase();
            this.updatePartFromInstanciedClassifier(session, current, base);
            return true;
        } else {
            String className = InputDialog.showInputDialog(this.obj, ModelingWizardDlg.getString("mdac.gui.process.className"), ModelingWizardDlg.getString("mdac.gui.process.chooseExistingName"), current.getName());
            if (className == null || className.equals("")) {
                return false;
            }
            IPackage container = this.getContainerPackage(current);
            if (container == null) {
                throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.updatePartFromInstanciedClass.rolePackage", current.getName()));
            }
            ObList cl = container.getOwnedElement().select((IObListFilter)new NameFilter(className));
            if (cl.size() <= 0 || !(cl.get(0) instanceof IClassifier)) throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.updatePartFromInstanciedClass.find", className));
            IClassifier newClass = (IClassifier)cl.get(0);
            current.setBase((INameSpace)newClass);
            this.updatePartFromInstanciedClassifier(session, current, newClass);
        }
        return true;
    }

    public boolean createInstanceAndClassifier(IModelingSession session, ILifeline current) throws ModelingWizardException {
        if (current.getRepresented() != null) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createInstanceAndClassifier.represented", current.getRepresented().getName()));
        }
        String instName = InputDialog.showInputDialog(this.obj, ModelingWizardDlg.getString("mdac.gui.process.instanceName"), ModelingWizardDlg.getString("mdac.gui.process.chooseName"), current.getName());
        if (instName == null || instName.equals("")) {
            return false;
        }
        IPackage container = this.getContainerPackage(current);
        if (container == null) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createInstanceAndClassifier.container", current.getName()));
        }
        ObList cl = container.getDeclared().select((IObListFilter)new NameFilter(instName));
        if (cl.size() > 0) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createInstanceAndClassifier.existing", instName));
        }
        IInstance newInst = session.getModel().createInstance(instName, container);
        current.setRepresented(newInst);
        return this.createClassifier(session, newInst);
    }

    public void updateInstanceAndClassifier(IModelingSession session, ILifeline current) throws ModelingWizardException {
        if (current.getRepresented() != null) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createInstanceAndClassifier.represented", current.getRepresented().getName()));
        }
        String instName = InputDialog.showInputDialog(this.obj, ModelingWizardDlg.getString("mdac.gui.process.instanceName"), ModelingWizardDlg.getString("mdac.gui.process.chooseName"), current.getName());
        if (instName == null || instName.equals("")) {
            return;
        }
        IPackage container = this.getContainerPackage(current);
        if (container == null) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createInstanceAndClassifier.container", current.getName()));
        }
        ObList cl = container.getDeclared().select((IObListFilter)new NameFilter(instName));
        if (cl.size() > 0) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createInstanceAndClassifier.existing", instName));
        }
        IInstance newInst = session.getModel().createInstance(instName, container);
        current.setRepresented(newInst);
        this.updatePartFromInstanciedClassifier(session, newInst);
    }

    private void updatePartFromInstanciedClassifier(IModelingSession session, IInstance inst, IClassifier instanciedClass) {
        if (!(inst instanceof IPort)) {
            for (IPort sourcePort : instanciedClass.getInternalStructure(IPort.class)) {
                IPort targetPort = null;
                for (IPort port : inst.getPart(IPort.class)) {
                    if (port.getRepresentedFeature() == null || !port.getRepresentedFeature().equals((Object)sourcePort)) continue;
                    if (targetPort != null) {
                        port.delete();
                        continue;
                    }
                    targetPort = port;
                }
                if (targetPort == null) {
                    targetPort = (IPort)Modelio.getInstance().getModelManipulationService().clone((IElement)sourcePort);
                    inst.addPart((IBindableInstance)targetPort);
                    targetPort.setRepresentedFeature((IModelElement)sourcePort);
                    continue;
                }
                this.updatePortFromPort(session, targetPort, sourcePort);
            }
            for (IPort p : inst.getPart(IPort.class)) {
                if (p.getRepresentedFeature() != null && p.getRepresentedFeature().getCompositionOwner().equals((Object)instanciedClass)) continue;
                p.delete();
            }
            if (instanciedClass.getPart(IAttribute.class).size() > 0) {
                AttributeCreationWizard window = new AttributeCreationWizard(instanciedClass, inst);
                window.open();
            } else {
                Iterator iter = inst.getSlot().iterator();
                while (iter.hasNext()) {
                    ((IAttributeLink)iter.next()).delete();
                }
            }
        }
    }

    private IClassifier createClassifierWithOptions(IModelingSession session, IInstance current, boolean createContent) throws ModelingWizardException {
        IClassifier newClass = null;
        if (current.getBase() != null) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createClassWithOptions.baseType", current.getBase().getName()));
        }
        ClassifierCreationWizard diag = new ClassifierCreationWizard(current);
        diag.open();
        String className = diag.getChosenName();
        String toCreate = diag.getChosenClass();
        if (className == null || className.equals("")) {
            return null;
        }
        IPackage container = this.getContainerPackage(current);
        if (container == null) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createClassWithOptions.container", current.getName()));
        }
        ObList cl = container.getOwnedElement(this.getClassifierTypeFromName(toCreate)).select((IObListFilter)new NameFilter(className));
        if (cl.size() > 0) {
            throw new ModelingWizardException(ModelingWizardDlg.getString("mdac.error.createClassWithOptions.existing", className));
        }
        newClass = this.createClassifier(session, toCreate, className, container);
        current.setBase((INameSpace)newClass);
        if (createContent) {
            Iterator iter = current.getRepresentedLifeLine().iterator();
            while (iter.hasNext()) {
                for (IInteractionFragment inter : ((ILifeline)iter.next()).getCoveredBy()) {
                    ObMessageSortEnum sort;
                    IMessage msg;
                    if (!(inter instanceof IMessageEnd) || (msg = ((IMessageEnd)inter).getReceivedMessage()) == null || (sort = msg.getSortOfMessage()) == ObMessageSortEnum.RETURN_MESSAGE || sort == ObMessageSortEnum.A_SYNC_CALL || sort == ObMessageSortEnum.A_SYNC_SIGNAL) continue;
                    this.createOperation(session, msg);
                }
            }
            iter = current.getSlot().iterator();
            while (iter.hasNext()) {
                this.createAttribute(session, (IAttributeLink)iter.next());
            }
            for (IPort sourcePort : current.getPart(IPort.class)) {
                IPort port = this.createPortFromPort(session, newClass, sourcePort);
                this.completeRequiredProvided(session, port, sourcePort);
            }
        }
        return newClass;
    }

    private IPackage getContainerPackage(IInstance current) {
        if (current == null) {
            return null;
        }
        INameSpace container = current.getOwner();
        if (container != null) {
            while (!(container instanceof IPackage)) {
                container = container instanceof ICollaboration ? this.getContainerPackage((ICollaboration)container) : this.getContainerPackage((IModelTree)container);
            }
        } else if (current instanceof IBindableInstance) {
            container = ((IBindableInstance)current).getInternalOwner();
            if (!(container instanceof IPackage)) {
                container = this.getContainerPackage((IModelTree)container);
            }
        } else {
            return null;
        }
        return (IPackage)container;
    }

    private IPackage getContainerPackage(ICollaboration current) {
        if (current == null) {
            return null;
        }
        IModelTree container = current.getOwner();
        if (container == null) {
            if (current.getBRepresented() != null) {
                container = current.getBRepresented().getOwner();
            } else if (current.getORepresented() != null) {
                container = current.getORepresented().getOwner();
            }
        }
        if (!(container instanceof IPackage)) {
            container = this.getContainerPackage(container);
        }
        return (IPackage)container;
    }

    private void completeRequiredProvided(IModelingSession session, IPort current, IPort sourcePort) {
        Iterator iter2;
        IProvidedInterface cur;
        boolean destPortFound;
        IProvidedInterface pi = null;
        IRequiredInterface ri = null;
        Iterator iter = sourcePort.getProvided().iterator();
        while (iter.hasNext()) {
            destPortFound = false;
            cur = (IProvidedInterface)iter.next();
            if (current.getProvided().contains((Object)cur)) {
                destPortFound = true;
            }
            if (destPortFound) continue;
            pi = session.getModel().createProvidedInterface();
            current.addProvided(pi);
            iter2 = cur.getProvidedElement().iterator();
            while (iter2.hasNext()) {
                pi.addProvidedElement((IInterface)iter2.next());
            }
        }
        iter = sourcePort.getRequired().iterator();
        while (iter.hasNext()) {
            destPortFound = false;
            cur = (IRequiredInterface)iter.next();
            if (current.getRequired().contains((Object)cur)) {
                destPortFound = true;
            }
            if (destPortFound) continue;
            ri = session.getModel().createRequiredInterface();
            current.addRequired(ri);
            iter2 = cur.getRequiredElement().iterator();
            while (iter2.hasNext()) {
                ri.addRequiredElement((IInterface)iter2.next());
            }
        }
    }

    private INameSpace getStateContainer(ITransition current) {
        INameSpace o = null;
        if (current instanceof IInternalTransition) {
            o = this.getStateContainer((IInternalTransition)current);
        } else {
            o = this.getStateContainer(current.getSource());
            if (o == null) {
                o = this.getStateContainer(current.getTarget());
            }
        }
        return o;
    }

    private INameSpace getStateContainer(IStateVertex current) {
        IRegion rep;
        INameSpace o = null;
        if (current instanceof IState && (rep = ((IState)current).getParent()) != null) {
            IStateMachine stateMachine = rep.getRepresented();
            o = stateMachine != null ? stateMachine.getOwner() : this.getStateContainer((IStateVertex)rep.getParent());
        }
        return o;
    }

    private INameSpace getStateContainer(IInternalTransition current) {
        return this.getStateContainer((IStateVertex)current.getSComposed());
    }

    private IPort createPortFromPort(IModelingSession session, IClassifier current, IPort sourcePort) {
        IPort ret = session.getModel().createPort();
        sourcePort.setRepresentedFeature((IModelElement)ret);
        current.addInternalStructure((IBindableInstance)ret);
        ret.setName(sourcePort.getName());
        ret.setService(sourcePort.isService());
        ret.setBehavior(sourcePort.isBehavior());
        this.createNotesFromNotes(session, (IModelElement)sourcePort, (IModelElement)ret);
        this.createStereotypesFromStereotypes((IModelElement)sourcePort, (IModelElement)ret);
        this.createTaggedValuesFromTaggedValues(session, (IModelElement)sourcePort, (IModelElement)ret);
        return ret;
    }

    private void updatePortFromPort(IModelingSession session, IPort targetPort, IPort sourcePort) {
        targetPort.setName(sourcePort.getName());
        targetPort.setService(sourcePort.isService());
        targetPort.setBehavior(sourcePort.isBehavior());
        targetPort.setRepresentedFeature((IModelElement)sourcePort);
        this.updateNotes(session, sourcePort, targetPort);
        this.updateStereotypes(sourcePort, targetPort);
        this.updateTaggedValues(session, sourcePort, targetPort);
        this.updateProvidedIntefaces(session, sourcePort, targetPort);
        this.updateRequiredIntefaces(session, sourcePort, targetPort);
    }

    private boolean equals(IProvidedInterface pi1, IProvidedInterface pi2) {
        ObList providedElements1 = pi1.getProvidedElement();
        ObList providedElements2 = pi2.getProvidedElement();
        return providedElements1.size() == providedElements2.size() && providedElements1.containsAll((Collection)providedElements2);
    }

    private boolean equals(IRequiredInterface ri1, IRequiredInterface ri2) {
        ObList requiredElements1 = ri1.getRequiredElement();
        ObList requiredElements2 = ri2.getRequiredElement();
        return requiredElements1.size() == requiredElements2.size() && requiredElements1.containsAll((Collection)requiredElements2);
    }

    private void updateProvidedIntefaces(IModelingSession session, IPort sourcePort, IPort targetPort) {
        ArrayList piSources = new ArrayList();
        piSources.addAll(sourcePort.getProvided());
        for (IProvidedInterface piTarget : targetPort.getProvided()) {
            boolean notExist = true;
            IProvidedInterface matchPI = null;
            for (IProvidedInterface piSource : piSources) {
                if (!this.equals(piTarget, piSource)) continue;
                notExist = false;
                matchPI = piSource;
                break;
            }
            if (notExist) {
                piTarget.delete();
                continue;
            }
            piSources.remove(matchPI);
        }
        ArrayList piTargets = new ArrayList();
        piSources.addAll(sourcePort.getProvided());
        for (IProvidedInterface piSource : sourcePort.getProvided()) {
            boolean notExist = true;
            IProvidedInterface matchPI = null;
            for (IProvidedInterface piTarget : piTargets) {
                if (!this.equals(piTarget, piSource)) continue;
                notExist = false;
                matchPI = piTarget;
                break;
            }
            if (notExist) {
                session.getModel().createProvidedInterface(targetPort, piSource.getProvidedElement());
                continue;
            }
            piTargets.remove(matchPI);
        }
    }

    private void updateRequiredIntefaces(IModelingSession session, IPort sourcePort, IPort targetPort) {
        ArrayList riSources = new ArrayList();
        riSources.addAll(sourcePort.getRequired());
        for (IRequiredInterface riTarget : targetPort.getRequired()) {
            boolean notExist = true;
            IRequiredInterface matchedRI = null;
            for (IRequiredInterface riSource : riSources) {
                if (!this.equals(riTarget, riSource)) continue;
                notExist = false;
                matchedRI = riSource;
                break;
            }
            if (notExist) {
                riTarget.delete();
                continue;
            }
            riSources.remove(matchedRI);
        }
        ArrayList riTargets = new ArrayList();
        riTargets.addAll(targetPort.getRequired());
        for (IRequiredInterface riSource : sourcePort.getRequired()) {
            boolean notExist = true;
            IRequiredInterface matchedRI = null;
            for (IRequiredInterface riTarget : riTargets) {
                if (!this.equals(riTarget, riSource)) continue;
                notExist = false;
                matchedRI = riTarget;
                break;
            }
            if (notExist) {
                session.getModel().createRequiredInterface(targetPort, riSource.getRequiredElement());
                continue;
            }
            riTargets.remove(matchedRI);
        }
    }

    private void updateTaggedValues(IModelingSession session, IPort sourcePort, IPort targetPort) {
        ObList tags = targetPort.getTag();
        for (ITaggedValue tag : tags) {
            tag.delete();
        }
        this.createTaggedValuesFromTaggedValues(session, (IModelElement)sourcePort, (IModelElement)targetPort);
    }

    private void updateStereotypes(IPort sourcePort, IPort targetPort) {
        ObList extensions = targetPort.getExtension();
        for (IStereotype ster : extensions) {
            targetPort.removeExtension(ster);
        }
        this.createStereotypesFromStereotypes((IModelElement)sourcePort, (IModelElement)targetPort);
    }

    private void updateNotes(IModelingSession session, IPort sourcePort, IPort targetPort) {
        for (INote note : targetPort.getDescriptor()) {
            note.delete();
        }
        this.createNotesFromNotes(session, (IModelElement)sourcePort, (IModelElement)targetPort);
    }

    private IClassifier createClassifier(IModelingSession session, String toCreate, String className, IPackage container) {
        if (toCreate.equals(ModelingWizardDlg.getString("mdac.gui.classifierWizard.class"))) {
            return session.getModel().createClass(className, (INameSpace)container);
        }
        if (toCreate.equals(ModelingWizardDlg.getString("mdac.gui.classifierWizard.component"))) {
            return session.getModel().createComponent(className, (INameSpace)container);
        }
        if (toCreate.equals(ModelingWizardDlg.getString("mdac.gui.classifierWizard.node"))) {
            INode res = session.getModel().createNode();
            res.setOwner((IModelTree)container);
            res.setName(className);
            return res;
        }
        if (toCreate.equals(ModelingWizardDlg.getString("mdac.gui.classifierWizard.interface"))) {
            return session.getModel().createInterface(className, (INameSpace)container);
        }
        return null;
    }

    private Class<? extends IModelTree> getClassifierTypeFromName(String chosenClass) {
        if (chosenClass.equals(ModelingWizardDlg.getString("mdac.gui.classifierWizard.class"))) {
            return IClass.class;
        }
        if (chosenClass.equals(ModelingWizardDlg.getString("mdac.gui.classifierWizard.component"))) {
            return IComponent.class;
        }
        if (chosenClass.equals(ModelingWizardDlg.getString("mdac.gui.classifierWizard.node"))) {
            return INode.class;
        }
        if (chosenClass.equals(ModelingWizardDlg.getString("mdac.gui.classifierWizard.interface"))) {
            return IInterface.class;
        }
        return null;
    }

    private IPackage getContainerPackage(IModelTree current) {
        if (current == null) {
            return null;
        }
        IModelTree container = current.getOwner();
        while (!(container instanceof IPackage)) {
            container = container instanceof ICollaboration ? this.getContainerPackage((ICollaboration)container) : this.getContainerPackage(container);
        }
        return (IPackage)container;
    }

    private IPackage getContainerPackage(ILifeline current) {
        return this.getContainerPackage(current.getOwner());
    }

    private IPackage getContainerPackage(IInteraction current) {
        INameSpace container = current.getOwner();
        if (container instanceof IPackage) {
            return (IPackage)container;
        }
        return this.getContainerPackage((IModelTree)current.getOwner());
    }

    private void createStereotypesFromStereotypes(IModelElement oldElt, IModelElement newElt) {
        for (IStereotype stereo : oldElt.getExtension()) {
            newElt.addExtension(stereo);
        }
    }

    private void createTaggedValuesFromTaggedValues(IModelingSession session, IModelElement oldElt, IModelElement newElt) {
        for (ITaggedValue tag : oldElt.getTag()) {
            try {
                String n = tag.getDefinition().getName();
                ITaggedValue newTag = session.getModel().createTaggedValue(n, newElt);
                newTag.setQualifier(tag.getQualifier());
                for (ITagParameter param : tag.getActual()) {
                    session.getModel().createTagParameter(param.getValue(), newTag);
                }
            }
            catch (TagTypeNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void createNotesFromNotes(IModelingSession session, IModelElement oldElt, IModelElement newElt) {
        for (INote note : oldElt.getDescriptor()) {
            try {
                String n = note.getModel().getName();
                session.getModel().createNote(n, newElt, note.getContent());
            }
            catch (NoteTypeNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

