/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_DBACCESS_INC_HELPIDS_H
#define INCLUDED_DBACCESS_INC_HELPIDS_H

#include <rtl/string.hxx>

inline constexpr OStringLiteral HID_DATABROWSE_HEADER = "DBACCESS_HID_DATABROWSE_HEADER";
inline constexpr OStringLiteral HID_CTL_TABBROWSER = "DBACCESS_HID_CTL_TABBROWSER";
inline constexpr OStringLiteral HID_CTL_TREEVIEW = "DBACCESS_HID_CTL_TREEVIEW";

inline constexpr OStringLiteral HID_DSADMIN_BROWSECONN = "DBACCESS_HID_DSADMIN_BROWSECONN";

inline constexpr OStringLiteral HID_CTL_QRYSQLEDIT = "DBACCESS_HID_CTL_QRYSQLEDIT";

inline constexpr OStringLiteral HID_CTL_QRYDGNTAB = "DBACCESS_HID_CTL_QRYDGNTAB";
inline constexpr OStringLiteral HID_CTL_QRYDGNCRIT = "DBACCESS_HID_CTL_QRYDGNCRIT";
inline constexpr OStringLiteral HID_QRYDGN_ROW_VISIBLE = "DBACCESS_HID_QRYDGN_ROW_VISIBLE";
inline constexpr OStringLiteral HID_QRYDGN_ROW_TABLE = "DBACCESS_HID_QRYDGN_ROW_TABLE";
inline constexpr OStringLiteral HID_QRYDGN_ROW_FIELD = "DBACCESS_HID_QRYDGN_ROW_FIELD";
inline constexpr OStringLiteral HID_QRYDGN_ROW_ORDER = "DBACCESS_HID_QRYDGN_ROW_ORDER";
inline constexpr OStringLiteral HID_QRYDGN_ROW_FUNCTION = "DBACCESS_HID_QRYDGN_ROW_FUNCTION";
inline constexpr OStringLiteral HID_QRYDGN_ROW_ALIAS = "DBACCESS_HID_QRYDGN_ROW_ALIAS";
inline constexpr OStringLiteral HID_QRYDGN_ROW_CRIT = "DBACCESS_HID_QRYDGN_ROW_CRIT";

inline constexpr OStringLiteral HID_TAB_DESIGN_FIELDCONTROL = "DBACCESS_HID_TAB_DESIGN_FIELDCONTROL";
inline constexpr OStringLiteral HID_TAB_DESIGN_DESCWIN = "DBACCESS_HID_TAB_DESIGN_DESCWIN";
inline constexpr OStringLiteral HID_TABDESIGN_BACKGROUND = "DBACCESS_HID_TABDESIGN_BACKGROUND";
inline constexpr OStringLiteral HID_CTL_TABLEEDIT = "DBACCESS_HID_CTL_TABLEEDIT";
inline constexpr OStringLiteral HID_TABDESIGN_NAMECELL = "DBACCESS_HID_TABDESIGN_NAMECELL";
inline constexpr OStringLiteral HID_TABDESIGN_TYPECELL = "DBACCESS_HID_TABDESIGN_TYPECELL";
inline constexpr OStringLiteral HID_TABDESIGN_COMMENTCELL = "DBACCESS_HID_TABDESIGN_COMMENTCELL";
inline constexpr OStringLiteral HID_TAB_DESIGN_HELP_TEXT_FRAME = "DBACCESS_HID_TAB_DESIGN_HELP_TEXT_FRAME";
inline constexpr OStringLiteral HID_TAB_ENT_DEFAULT = "DBACCESS_HID_TAB_ENT_DEFAULT";
inline constexpr OStringLiteral HID_TAB_ENT_FORMAT_SAMPLE = "DBACCESS_HID_TAB_ENT_FORMAT_SAMPLE";
inline constexpr OStringLiteral HID_TAB_ENT_FORMAT = "DBACCESS_HID_TAB_ENT_FORMAT";
inline constexpr OStringLiteral HID_TAB_ENT_BOOL_DEFAULT = "DBACCESS_HID_TAB_ENT_BOOL_DEFAULT";
inline constexpr OStringLiteral HID_TAB_ENT_REQUIRED = "DBACCESS_HID_TAB_ENT_REQUIRED";
inline constexpr OStringLiteral HID_TAB_ENT_AUTOINCREMENT = "DBACCESS_HID_TAB_ENT_AUTOINCREMENT";
inline constexpr OStringLiteral HID_TAB_ENT_TEXT_LEN = "DBACCESS_HID_TAB_ENT_TEXT_LEN";
inline constexpr OStringLiteral HID_TAB_ENT_TYPE = "DBACCESS_HID_TAB_ENT_TYPE";
inline constexpr OStringLiteral HID_TAB_ENT_COLUMNNAME = "DBACCESS_HID_TAB_ENT_COLUMNNAME";
inline constexpr OStringLiteral HID_TAB_ENT_NUMTYP = "DBACCESS_HID_TAB_ENT_NUMTYP";
inline constexpr OStringLiteral HID_TAB_ENT_LEN = "DBACCESS_HID_TAB_ENT_LEN";
inline constexpr OStringLiteral HID_TAB_ENT_SCALE = "DBACCESS_HID_TAB_ENT_SCALE";
inline constexpr OStringLiteral HID_CTL_RELATIONTAB = "DBACCESS_HID_CTL_RELATIONTAB";
inline constexpr OStringLiteral HID_RELATIONDIALOG_LEFTFIELDCELL = "DBACCESS_HID_RELATIONDIALOG_LEFTFIELDCELL";
inline constexpr OStringLiteral HID_RELATIONDIALOG_RIGHTFIELDCELL = "DBACCESS_HID_RELATIONDIALOG_RIGHTFIELDCELL";
inline constexpr OStringLiteral HID_CONFIRM_DROP_BUTTON_ALL = "DBACCESS_HID_CONFIRM_DROP_BUTTON_ALL";
inline constexpr OStringLiteral HID_DSADMIN_LDAP_HOSTNAME = "DBACCESS_HID_DSADMIN_LDAP_HOSTNAME";
inline constexpr OStringLiteral HID_DSADMIN_MOZILLA_PROFILE_NAME = "DBACCESS_HID_DSADMIN_MOZILLA_PROFILE_NAME";
inline constexpr OStringLiteral HID_DSADMIN_THUNDERBIRD_PROFILE_NAME = "DBACCESS_HID_DSADMIN_THUNDERBIRD_PROFILE_NAME";

inline constexpr OStringLiteral HID_DLGINDEX_INDEXDETAILS_FIELD = "DBACCESS_HID_DLGINDEX_INDEXDETAILS_FIELD";
inline constexpr OStringLiteral HID_DLGINDEX_INDEXDETAILS_SORTORDER = "DBACCESS_HID_DLGINDEX_INDEXDETAILS_SORTORDER";

inline constexpr OStringLiteral HID_TAB_AUTOINCREMENTVALUE = "DBACCESS_HID_TAB_AUTOINCREMENTVALUE";

inline constexpr OStringLiteral HID_DSADMIN_DBASE_PATH = "DBACCESS_HID_DSADMIN_DBASE_PATH";
inline constexpr OStringLiteral HID_DSADMIN_MYSQL_DATABASE = "DBACCESS_HID_DSADMIN_MYSQL_DATABASE";
inline constexpr OStringLiteral HID_DSADMIN_MYSQL_ODBC_DATASOURCE = "DBACCESS_HID_DSADMIN_MYSQL_ODBC_DATASOURCE";
inline constexpr OStringLiteral HID_DSADMIN_ODBC_DATASOURCE = "DBACCESS_HID_DSADMIN_ODBC_DATASOURCE";
inline constexpr OStringLiteral HID_DSADMIN_MSACCESS_MDB_FILE = "DBACCESS_HID_DSADMIN_MSACCESS_MDB_FILE";
inline constexpr OStringLiteral HID_DSADMIN_FLAT_PATH = "DBACCESS_HID_DSADMIN_FLAT_PATH";
inline constexpr OStringLiteral HID_DSADMIN_CALC_PATH = "DBACCESS_HID_DSADMIN_CALC_PATH";
inline constexpr OStringLiteral HID_DSADMIN_WRITER_PATH = "DBACCESS_HID_DSADMIN_WRITER_PATH";
inline constexpr OStringLiteral HID_DSADMIN_ORACLE_DATABASE = "DBACCESS_HID_DSADMIN_ORACLE_DATABASE";

inline constexpr OStringLiteral HID_APP_TABLE_TREE = "DBACCESS_HID_APP_TABLE_TREE";
inline constexpr OStringLiteral HID_APP_FORM_TREE = "DBACCESS_HID_APP_FORM_TREE";
inline constexpr OStringLiteral HID_APP_QUERY_TREE = "DBACCESS_HID_APP_QUERY_TREE";
inline constexpr OStringLiteral HID_APP_REPORT_TREE = "DBACCESS_HID_APP_REPORT_TREE";
inline constexpr OStringLiteral HID_APP_CREATION_LIST = "DBACCESS_HID_APP_CREATION_LIST";
inline constexpr OStringLiteral HID_APP_SWAP_ICONCONTROL = "DBACCESS_HID_APP_SWAP_ICONCONTROL";


inline constexpr OStringLiteral HID_APP_HELP_TEXT = "DBACCESS_HID_APP_HELP_TEXT";
inline constexpr OStringLiteral HID_APP_DESCRIPTION_TEXT = "DBACCESS_HID_APP_DESCRIPTION_TEXT";
inline constexpr OStringLiteral HID_APP_VIEW_PREVIEW_CB = "DBACCESS_HID_APP_VIEW_PREVIEW_CB";
inline constexpr OStringLiteral HID_APP_VIEW_PREVIEW_1 = "DBACCESS_HID_APP_VIEW_PREVIEW_1";
inline constexpr OStringLiteral HID_APP_VIEW_PREVIEW_2 = "DBACCESS_HID_APP_VIEW_PREVIEW_2";
inline constexpr OStringLiteral HID_TABDESIGN_HELPTEXT = "DBACCESS_HID_TABDESIGN_HELPTEXT";
inline constexpr OStringLiteral HID_APP_VIEW_PREVIEW_3 = "DBACCESS_HID_APP_VIEW_PREVIEW_3";


inline constexpr OStringLiteral HID_DBWIZ_PREVIOUS = "DBACCESS_HID_DBWIZ_PREVIOUS";
inline constexpr OStringLiteral HID_DBWIZ_NEXT = "DBACCESS_HID_DBWIZ_NEXT";
inline constexpr OStringLiteral HID_DBWIZ_CANCEL = "DBACCESS_HID_DBWIZ_CANCEL";
inline constexpr OStringLiteral HID_DBWIZ_FINISH = "DBACCESS_HID_DBWIZ_FINISH";

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
