//MIT License
//
//Copyright (c) 2016 Drake Levy
//Copyright (c) 2023 szlldm
//
//Permission is hereby granted, free of charge, to any person obtaining a copy
//of this software and associated documentation files (the "Software"), to deal
//in the Software without restriction, including without limitation the rights
//to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//copies of the Software, and to permit persons to whom the Software is
//furnished to do so, subject to the following conditions:
//
//The above copyright notice and this permission notice shall be included in all
//copies or substantial portions of the Software.
//
//THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//SOFTWARE.


static const int16_t fx2a_paramFeatureBias[16] = {
    1141, -656, -204, 285, 685, -516, 401, -809, -394, -529, -64, 433, 463, 64, 395, -284, 
};

static const int16_t fx2a_paramFeatureWeights[400] = {
    -6, 303, 108, -291, 155, -141, -611, -45, 49, 151, -269, 250, 330, 31, -287, -3, 
    269, -539, 330, 223, 8, 479, 650, 89, 461, -14, 195, 546, 267, -114, 431, 76, 
    -608, 396, 157, 13, -221, 682, -374, -301, 58, 850, -780, 1146, -439, -146, -463, 510, 
    131, 33, 1529, 300, -657, 692, -909, 180, 646, 524, -389, 779, 798, -960, 607, 254, 
    -330, -277, 510, -399, -64, 408, 267, -110, -254, 136, 1, 438, 383, 8, 47, 420, 
    680, -406, -36, 146, 142, -1010, -109, 33, 737, 90, -146, -214, -71, 218, 719, -487, 
    3, -103, 1665, 626, -1007, 331, 813, 463, 658, 74, 548, -748, -356, 322, -502, -289, 
    1527, -60, 1554, 2428, -1905, 14, -955, 968, 1463, 1303, 1054, 416, 944, 4482, -1839, 700, 
    1039, 2306, 532, -274, -968, -213, 849, -1233, 47, 967, 1018, -384, -1093, -2002, -1344, 1686, 
    447, 364, -169, -162, -210, -70, -308, 39, 17, -261, -115, 224, 293, -208, 320, 93, 
    -534, 522, -438, 521, -715, -165, -165, 298, -298, -95, -88, -826, -152, 411, -552, 514, 
    438, -4285, -1477, 713, -966, 782, -1277, -109, 633, 98, -251, -1300, -1134, -207, 429, 729, 
    -1317, 665, -1721, 560, 2691, -733, 781, 3798, 1407, 789, 2023, -1439, 3451, 80, -2735, 1322, 
    -1204, 1961, -982, 1072, 1103, 24, 1637, -493, 873, 215, 534, -611, 1147, -2522, 559, 992, 
    -437, -587, 61, -289, -97, -1068, 808, 94, -66, 712, -61, 460, -975, -268, -418, 559, 
    162, 471, 184, -267, -216, 400, 442, -128, -292, 65, 108, 120, -117, -122, 363, -82, 
    -192, -1377, 178, 175, 796, -493, -468, 186, 1069, 579, -107, 573, 246, -517, 757, 310, 
    316, 216, -1726, -1390, 3466, 2642, -371, 1455, 1172, 522, -757, 604, -2880, -22, 2419, 1142, 
    -1882, 1565, -343, -547, -1221, -957, 128, -107, 613, 317, 907, -143, -1277, 1206, 1428, 1214, 
    -292, -52, 525, -1463, -890, 340, 153, 263, -504, 354, 1027, 151, 168, -468, -228, -728, 
    -416, -198, 314, -133, 450, -97, -449, -27, -214, 199, -603, -282, 404, 94, -223, 657, 
    203, -169, -312, 34, -809, -410, -508, 306, -23, -533, 665, -271, -377, 158, 18, -209, 
    276, -275, 295, 173, 1297, -688, -806, -66, -72, 679, 285, -501, -219, -149, -543, -736, 
    302, 80, 447, -638, -9, -405, 647, -7, 281, -425, -124, 343, -1543, 148, 148, 481, 
    501, 218, -662, -1206, -957, 358, -278, -141, 234, 1071, 320, -55, 1442, 280, 239, -364, 
};

static const int16_t fx2a_paramModel1Bias[16] = {
    17, 147, -612, -6057, -191, 92, 11, -360, 671, -187, 907, -634, 992, 397, -274, 567, 
};

static const int16_t fx2a_paramModel1Weights[2304] = {
    -868, -2005, -783, 404, 401, -1137, -370, -649, -904, 3330, 3062, 596, 2691, 429, 3083, -2559, 
    12, 2144, 1524, 1600, -1280, 586, 3027, 2652, -612, -143, -75, 522, -386, -1990, -540, -1106, 
    609, -2052, 1831, -695, -142, -165, 43, 276, 1568, -530, -3676, -2171, -105, 1530, -1324, 409, 
    67, -1125, -548, -790, -840, -978, 500, -485, 1794, 1156, -2642, 4, 147, -1783, -2778, -1492, 
    154, 1578, -575, 569, 1844, 710, 2666, 20, -2694, -535, -1845, -742, 475, -616, -24, 1180, 
    -687, -1238, -3263, -306, -914, -366, -231, 2089, 565, 169, 2449, -1319, -18, 1328, -61, 528, 
    -511, -1538, -499, 939, -932, -1027, 3549, -2661, -278, 356, 311, 1697, 97, -479, 782, 1983, 
    874, 532, 142, -1066, 199, 115, 650, -1268, -888, 41, 625, -2347, 567, -913, 1259, 697, 
    -735, -329, -237, 1267, 562, 285, -1529, -970, 1583, -482, -700, 120, -838, 1864, -1432, -472, 
    -282, -703, 249, -349, 477, 584, 658, -1241, 726, -607, -1024, -992, -133, 1365, -1304, -91, 
    -727, -539, 722, 2109, -1894, 796, 1177, 647, -2, -121, 168, 32, -1340, 1114, 495, 880, 
    -348, 305, 447, -1143, -695, -947, 86, 9, 651, 1763, -1948, 96, -306, 651, 688, 1033, 
    -773, -1187, -2889, -742, -382, 867, -2469, -1225, 2495, 69, 566, -2878, 548, -186, 90, -1166, 
    -1080, 836, 1994, -397, -719, 380, -1497, 519, 268, -271, -464, 1931, -1192, -295, -1082, 184, 
    399, 1404, 4110, -1760, 120, -1973, 708, 243, -200, -779, 1500, -868, 1867, -136, -2190, -397, 
    -2845, -726, -618, 882, 394, -1170, 585, -11, 9, -1410, 298, 1459, 1456, -306, 239, -1204, 
    957, -478, -658, -1954, -2442, -274, -326, 2778, -398, -526, -945, -1189, -2789, -955, 120, 113, 
    1383, -1179, -815, -1155, 1754, 101, -4025, -3069, -136, -1767, -1613, -3184, 322, 43, 455, 99, 
    1, -513, 909, 643, 3642, -368, 590, -1176, -1125, 1930, 1576, 887, 140, -1464, -1583, -1227, 
    -507, 1055, -4723, 2050, 1659, 1770, -998, 834, -985, 590, 2290, 251, 270, 555, 592, -3539, 
    1064, -372, 2110, -3779, 3651, 925, 2494, -691, -2094, 1549, -2993, -809, 336, 407, 231, 1362, 
    999, 154, 738, -223, 257, -702, 1023, -2451, -701, -1752, 1489, 383, -234, -1096, 255, 345, 
    3002, 1275, -449, 1768, 3964, -839, -270, -1013, -1963, 534, -2355, 195, -285, 256, 627, -75, 
    1572, -2115, -3756, 3305, 3007, 318, -6878, 4272, -1990, 513, 1459, -1153, -269, -1010, 227, -204, 
    -844, -1717, -2324, 627, -2557, 299, -1222, -180, -4122, -1176, 799, 536, 1136, 40, 2018, -707, 
    -385, 30, 119, 309, 527, -806, -537, 424, 515, -592, -686, 1083, 175, -796, -932, -2728, 
    -600, 1274, -750, -493, -1305, -1834, 775, 69, -1890, -751, 527, -838, -1339, 1203, -2063, -1501, 
    1385, -420, 312, 509, -1117, -831, 280, 30, -424, 1010, -1218, 705, 139, -466, -1093, 924, 
    -5791, 2598, 3122, -2235, -485, -1158, -425, 1486, 3325, 584, -6117, 1226, -1249, 23, 699, -1015, 
    -953, -1734, 585, -7, -146, 2118, 57, -2906, 2029, 1480, -995, -1194, 1049, -151, -916, 437, 
    -2293, -685, -754, 1893, 1768, 2394, 1506, -4751, 474, -142, -741, 2037, 1960, -2128, -626, -264, 
    1083, -598, 2161, -3176, -892, 562, -2333, 1635, -273, 1173, -1756, 1082, -720, -646, 822, -85, 
    915, 1276, -1775, -905, 2121, -14, -3113, 1421, 930, 1155, -1508, -476, 774, -583, 1632, -3189, 
    -1189, 2371, -288, 1069, 1485, -1209, 5249, 301, 336, -914, 1863, 1073, -378, 521, 2159, 440, 
    683, 1306, -1202, -2138, -1059, 657, -1791, 1534, -403, 1105, -2895, 2446, -772, 1943, 835, -561, 
    -521, 152, -1425, 20, 177, 56, -3917, 722, -111, 1079, 2523, 267, 9, 245, -2490, -715, 
    -461, 144, -443, 1455, -225, 1523, 863, 1566, -554, 301, 1411, -2411, -1733, -340, -150, 768, 
    -1202, -640, 1037, 2450, -1571, 187, -729, 1448, 445, 1290, 2495, 826, 5, -1127, -730, 158, 
    167, -1358, -1880, -928, -328, 2076, -1275, -2225, -836, 2108, -1966, -1519, 872, -1842, -249, 647, 
    445, -331, 1578, 576, -387, -738, -868, -2190, 2239, -1042, 42, 698, -1190, -685, 2293, -1434, 
    1757, -1361, -425, -138, 1645, -125, -578, 499, -1651, 145, -1421, -886, -64, -651, 796, 382, 
    569, -447, -297, -849, 255, 826, 925, -320, -1206, -1709, 313, 646, -1108, 97, 757, 1132, 
    -238, 62, 58, -1207, -275, -760, -605, -1837, -285, 153, 1092, 872, 1811, 178, 690, -1, 
    -279, 612, -475, 20, 401, -1276, -945, -558, -428, -157, 86, 127, 722, -986, 1010, 366, 
    380, -4438, -152, -790, 912, 1091, 1829, -226, 1402, 839, -79, 1565, -1055, 1392, -679, -397, 
    1662, 1274, 4337, 1878, -1527, -255, 3359, -412, 90, 149, -1178, -883, -1618, -828, 477, -1008, 
    -1433, -4652, 5497, 916, 1144, -1267, -2552, 908, 1644, -2733, -3833, -1763, 1365, -879, -45, 385, 
    1428, 705, -1794, -278, 186, 682, 838, 1109, 1112, 653, 1133, 2791, -186, 438, -782, 1220, 
    -2007, 286, -990, -2117, -549, 1815, 1422, -713, -485, -1118, -812, -437, -953, 1116, -449, -2297, 
    -1743, -1304, -2409, 1574, -1196, -38, -431, 1099, -593, -1407, 2042, -2057, 655, 839, -57, -1427, 
    1689, 536, 1183, 50, 970, -1231, -1928, -60, 1047, -1682, 877, 2455, 540, 2410, -7238, 1428, 
    1293, 839, 1342, 676, 628, -891, -2219, 3316, -421, 1568, 1812, 217, 381, -2693, -1742, -197, 
    -498, -631, 2949, -2392, -1877, -2582, 1309, -1421, 1174, -1760, 585, -19, -1972, 1959, -431, -196, 
    -661, 990, -3094, -152, 1683, -525, -2047, -1507, 1380, 1942, 1389, -434, -788, 782, -1150, -634, 
    -208, -2728, -4180, -811, 1843, -39, -1929, -1976, -70, -104, -1566, 349, 738, -970, 540, -812, 
    873, 682, 895, -2557, 2359, -1101, 1856, -378, -835, 96, 1275, -140, -578, -311, -36, -2602, 
    987, 1397, 952, -1714, -754, 1110, 141, 1339, -380, 926, -229, 412, -1859, -1240, -1096, 1511, 
    684, -849, 292, -134, 589, -146, -1483, 780, 542, -74, 837, 647, 845, -1704, -1125, 558, 
    99, -758, -1527, -1114, -301, -37, 835, -1205, -385, 121, 648, -231, 744, -1015, 1620, 2413, 
    707, -1034, -1033, 763, -1949, 344, 1517, -1556, -1329, 1036, -1612, 317, 578, 1065, 356, -387, 
    1042, -317, 3484, -2898, -524, -1298, -1715, -1737, -259, -1649, 3350, -153, -704, 1374, 807, 1304, 
    28, -218, 938, -313, -1886, 397, -1566, 1968, -227, -425, 3408, -758, -1805, 640, 105, 364, 
    -797, 2343, -596, 1268, 1693, -581, -545, 8590, 1815, -1114, -1738, 1077, 117, -1886, -334, -408, 
    376, -2675, -809, -112, 2518, 239, -1104, -2266, -473, 31, 289, 1077, 170, -497, 1320, 15, 
    -3402, 2709, 2617, -2640, -1421, -2148, -3174, 1345, -3520, 1766, -467, 1570, -1468, 4204, 310, 720, 
    -83, -1796, -2390, 937, 3869, -769, -9762, -6357, 315, -6601, -4204, 1513, 2325, 1239, -460, 3139, 
    -260, -869, -3493, 1992, 4152, -4080, 2715, 2467, 1579, -550, 923, 1535, 2728, 208, -6168, -2078, 
    1544, -1733, 2903, 375, -2774, 3913, 3217, -515, 4122, -207, 4415, 589, 779, -1333, -542, 3058, 
    4763, 584, 605, -714, 563, 1052, -344, 33, 1967, -3148, -3175, 4064, 4494, -829, 1248, 1202, 
    -407, 5300, -1129, -3875, 1658, 2059, 860, 6107, 3040, -1, -2490, -2923, 2325, 1461, 50, -329, 
    1134, -1443, -3270, 6540, 2549, 751, -2657, 665, -89, -2550, 2518, 1120, -1099, 799, -2730, 1589, 
    -5502, 2766, -4718, -763, 58, -550, -4721, -2207, -2754, 2550, 1045, 506, -480, 493, -4161, 1938, 
    2358, 1236, -246, -931, 855, -482, -997, 1882, 1424, -594, 926, 800, -1294, 1056, -584, -1304, 
    389, 2745, 1582, 370, 318, 487, -65, 670, 1950, 96, 1750, -2108, -946, -2444, -4197, 940, 
    488, -566, 550, 1256, -2242, 180, -190, 1069, -1873, -906, 909, -676, -111, 23, -94, -1050, 
    -2521, 242, -1469, 2247, 651, 322, 325, 1516, -2411, 2688, 461, 884, 1159, 1064, 4614, -592, 
    4977, 1592, 3314, 420, 1509, 4282, 2155, -2618, -2488, 531, -5544, -849, 647, -1824, 2122, 1354, 
    5381, 2018, -266, -7401, -1870, 327, -3651, 3655, -1316, 1830, 846, 2943, 2508, 1398, 478, -849, 
    1844, 2114, -7732, -1880, 4239, 494, 2410, -5679, -13, 960, 5994, -1992, -2614, -1375, 310, -1160, 
    2549, -203, -4236, 5207, -186, -3598, -11153, 3312, -2580, 1943, -2117, -5621, -650, 372, 875, -722, 
    1146, -479, -1866, 147, 247, 1287, -702, 247, -1818, 2917, 748, -1598, -1323, 1057, 1457, 749, 
    -79, -421, -189, -2497, -5025, -3396, -2802, 2218, -649, -77, -2113, 1447, 1826, -1999, 1639, -2, 
    -727, 255, 321, -2138, 1351, -2185, 2844, -3693, 829, -660, 194, -1977, 822, 660, -2150, 2208, 
    -2333, 107, -1397, -162, -700, -1147, 3177, -638, 2887, -74, 1312, -535, 2696, -1902, -909, -249, 
    1501, 607, -3115, 1170, 503, -2960, -552, -703, -613, -3521, 681, -141, 1761, -1429, -2584, 1146, 
    -31, 1323, 161, 2459, 1696, -1392, 3772, 2163, -1519, -2296, -3063, 1530, 468, 2261, -419, 1175, 
    -4677, -156, 5786, -2311, -779, -324, 2354, -3133, 1935, 1003, 299, -4133, -1272, -383, 529, -2692, 
    -3336, 1881, 384, -3004, -2452, -498, 1536, 321, 3553, 817, 762, -59, -3371, -219, 481, 807, 
    -1580, 391, 541, 1701, -946, -109, -752, -550, 296, 968, -360, -696, -1963, -113, -960, -2857, 
    -635, 1244, 31, 1639, 438, -1107, 871, 1365, 531, -622, 167, -1125, 346, -1181, -578, 620, 
    37, 979, 544, 628, -72, -2125, 260, 1075, 86, 304, 349, 359, 1538, -1518, 91, -260, 
    -2126, -219, 331, 1229, 1331, 1590, 81, -296, 651, 490, -68, -936, -817, -625, -1362, -395, 
    -1888, 405, 94, 2090, -2649, 2006, -956, 1009, -2026, -1535, 1239, -933, 400, -457, 1407, 486, 
    -549, -860, -3057, -1054, 933, -2462, -2773, 973, -2082, -48, 577, 1324, -408, -1093, -15, -810, 
    -1637, -74, -3175, 1642, -2193, -4579, 201, -2607, 1670, -906, 1475, 697, -65, -346, -1144, 1551, 
    2135, -668, 2454, -885, -235, 2032, 4534, -2186, -985, 1933, -2538, -1054, -276, -47, -272, -1895, 
    836, -980, -544, -284, 640, -972, -230, 2084, -2876, 197, -854, 449, -90, 964, -1023, -153, 
    280, 1556, 1556, 776, 87, -432, 3072, 2563, 611, -647, -3185, 844, 303, -562, 848, 861, 
    -1486, -1179, 1165, 2580, -158, 53, 191, -515, -2649, 177, 61, 79, 448, 838, 384, -2313, 
    30, 235, -1841, -1267, 886, 1725, 1495, -228, -2171, 1433, 2241, -1224, -2835, -317, 415, -2667, 
    -407, 1494, -1400, 1132, -318, 389, -2108, 1853, -72, 1304, 1071, -1333, 86, 516, -1738, 918, 
    -14, -1589, -1369, 529, -1673, 1029, -3053, -462, 304, -522, 1319, 1537, 507, 329, -890, -692, 
    1188, -474, 1559, -3238, 20, -731, 1530, 5505, -718, 218, 273, -451, -71, 1978, 1249, 1214, 
    -407, -467, 2162, 969, 1028, 32, -1248, 431, -1433, -1174, -1187, 1591, -392, -1326, -72, -5, 
    -488, -771, -31, 1166, -274, 554, 584, -780, -106, 863, -1304, -1351, 414, 478, -484, 245, 
    -339, -299, 495, 613, 74, -743, -495, 402, -650, 12, -1137, -1243, 2271, 1220, 90, -350, 
    499, -196, -37, -512, 193, 1368, -1184, -172, -32, 1558, 86, -933, -74, 52, 712, 1387, 
    -1062, 1124, 877, -1232, -568, -967, -518, -1477, 1048, 654, -1617, 1775, -300, -1346, -1234, -62, 
    -669, 1148, -532, 1998, -427, -2747, -2524, 2085, 129, 475, -217, -464, 883, 306, 977, -1211, 
    -1214, -854, -3456, 105, -662, 1565, -1733, -216, 150, -1050, 1962, 909, 1164, 423, -151, -854, 
    3164, -380, -878, -4759, -1520, -856, 3046, -1567, 1096, -1955, -2735, -1377, -680, 653, 687, 568, 
    1341, 2051, 3485, 295, 1539, 1592, 2158, -635, 437, 128, 2267, -1815, 809, -1172, -99, 412, 
    -443, 680, -2464, -347, 824, -274, -2106, 2977, -490, 102, -65, 1028, 2008, 365, 2131, 1409, 
    934, 369, -1371, -1599, 317, -218, -1570, -1445, 1739, 595, 3111, 1721, 1491, -175, 730, 495, 
    -1559, -1537, -2484, 3843, 3936, -1336, 1665, 1570, -1611, -5823, -4224, 1833, 293, -1526, -1933, -371, 
    1831, 255, 1102, -276, -3598, -1567, -2269, 138, 371, -842, -502, -844, -1446, -1552, -1896, 384, 
    -1263, 12, -980, -1351, -347, 1136, -1574, 926, 1522, -1952, 731, -1017, -1225, 1642, -305, -931, 
    -2572, -150, -2705, -1317, -1989, -632, 215, -141, -710, 422, 3808, 1570, -1146, -262, -1758, 999, 
    4210, 2507, 2692, 2358, 898, -2241, -2727, 1464, -245, 659, 1801, 321, -696, -1176, -1225, 283, 
    244, 1187, -1516, 308, -1602, 526, 1452, 1235, -4594, -1213, -2572, 2234, -1877, 1071, -762, 275, 
    -1118, -318, 552, -92, 996, 10, 178, 722, 1423, 105, -916, 1443, -329, -54, 135, -480, 
    741, -945, 717, 816, -2101, -1217, -788, 1005, -1340, 2712, 403, -1916, 96, -774, -1662, -1110, 
    -1256, -763, -1468, 521, -397, -1336, 2067, 490, -1185, 879, -866, -1217, 923, -322, -405, -1002, 
    -527, 299, -893, -679, 1116, 1243, 865, 357, -1757, -1215, -1493, 1010, 292, 1358, -1298, 1818, 
    -2316, -730, -952, -2107, 4730, 1430, 3606, -1940, 1710, -2127, -625, 1266, -359, -1253, 148, 1589, 
    853, -1601, -901, -243, 553, -206, 2013, 268, 792, 241, 403, -2409, -803, 994, -776, 495, 
    675, -292, 1480, 780, -1283, 3540, -9292, 597, 1672, 486, 2067, 734, -1781, -411, 568, -782, 
    -3755, -190, -340, 108, 2748, -2380, -1946, 1037, -139, -436, -1676, 1244, 397, 589, 1656, -71, 
    -196, -206, 82, -233, 2016, -187, 2196, -774, 886, -66, -3329, 2182, 474, 98, -195, 645, 
    544, -1050, -968, -1160, 1172, 2022, 1622, -496, 469, 2443, 1112, -55, -1546, -84, -2500, 338, 
    1067, -679, -349, -950, 77, 579, -1225, -328, 1403, -427, 3365, -2356, -471, -452, -173, 1278, 
    -2064, -490, -685, 37, -322, 499, -2118, 901, -551, 726, -2764, 365, -1745, 1294, 712, 1275, 
    -151, 170, -1066, -2410, -1095, 583, 693, -176, -331, 2192, 1471, -340, 1692, -953, -168, 1882, 
    1492, -1278, 1164, -543, -570, -392, -3501, -2233, -600, 1036, 608, -1104, 1006, 1783, 241, -2351, 
    -387, 1155, 101, -151, -1021, 198, 863, 342, -915, 2265, 1100, 2399, -220, -545, 1737, -1111, 
    -4421, -990, -1641, 461, -1271, 313, 3189, 1011, 691, -1536, -140, -890, -1663, 988, -1826, -370, 
    -948, 666, 178, 231, 634, 230, 1191, -1380, 141, 1468, -919, -1530, 90, -952, -225, -360, 
    -588, -159, 1103, 32, -1208, -1203, -1520, -172, 1794, 1250, -697, 1246, -560, 952, -1125, 1840, 
    262, -557, -792, -1255, 1823, 2618, -782, 197, 237, 978, 977, 646, -1318, -966, -796, 515, 
    1107, -1063, 467, 693, 1613, 299, -1030, -125, 1419, -724, 325, 276, -367, 958, -168, 2151, 
    1186, -699, -1169, 219, 538, -1477, -2329, 2679, 319, 1581, -1462, 170, -458, -1473, 1917, -713, 
    -879, 773, 2827, 370, -1323, -1567, -274, 1843, 1108, 1540, -1325, 690, -648, -693, -221, 606, 
    -803, -214, 1278, -1749, -545, -2914, 1469, 1181, 674, -1617, -1258, -490, 1540, -1886, -350, 1270, 
    -2874, 956, -1406, 333, -2596, -866, 573, -20, 2846, -282, 594, 1049, 1247, 271, 1537, 187, 
};

static const int16_t fx2a_paramModel1Alpha[16] = {
    -2276, 3571, 525, -163, 3757, 1898, 660, 5620, 1086, 1009, -5440, -2982, -15, 4082, 103, 3470, 
};

static const int16_t fx2a_paramModel2Bias[16] = {
    -130, 156, -750, 75, -531, -379, 1018, 762, 527, 378, 167, -94, -750, -531, -152, -45, 
};

static const int16_t fx2a_paramModel2Weights[2304] = {
    -160, -373, -2336, -108, -9, -119, -273, -136, -452, -492, 1547, -1671, 1164, 1098, 312, 141, 
    -216, 1051, 2252, 366, -64, 1028, 1129, -1056, -670, -975, 672, -835, 2312, 1457, -450, -405, 
    -2033, -374, 115, -427, -1826, 139, -818, -1119, 61, 1110, 1880, 406, -152, -513, -1071, -1478, 
    178, 655, -415, -1065, 1349, 176, -294, 1814, 1481, -149, 1100, 512, -1501, 1611, -2000, -392, 
    89, 997, 767, 193, -1294, 417, -772, 1448, -4, 497, -2470, 1099, 1684, -191, -823, 1613, 
    -675, -1185, -273, 193, 625, -242, -1946, -937, 457, 683, -717, 1149, -188, -739, 352, -1772, 
    -1513, -762, 1494, 1320, -12, 280, 1617, -320, -267, -235, 115, -565, -645, 220, 89, -1467, 
    231, -291, -588, 1561, -1457, -984, -201, 1520, 433, 226, 41, -904, 960, 318, -318, 708, 
    997, 14, -620, -1312, 333, 1681, 787, -649, -418, -554, -930, 450, 959, -959, 1046, -692, 
    927, -635, -846, -185, -871, -793, 1051, 85, 1319, -2071, 816, -2801, -216, 326, 183, -693, 
    935, -2130, 1692, 1491, 504, -1445, 17, 615, -1457, 122, -209, 637, -69, -1, 392, -648, 
    2170, -684, -899, -1324, 969, 582, 874, 2908, 78, 426, -922, -1213, 50, -54, 308, 1190, 
    24, 1080, -132, -1759, 915, 171, -1350, -532, 69, 829, -779, -1747, -592, 106, -416, -713, 
    116, -1227, 2568, 321, -621, -173, -319, 1473, -707, 1371, 412, -31, 613, -12, 1605, 122, 
    -94, 502, -212, 390, 1193, 2, 227, 101, 717, 157, -2381, -1059, 845, -359, -502, -201, 
    -3033, -521, -1104, -1249, -339, -1111, 129, 159, -232, -141, -390, 1697, -60, 549, -762, 819, 
    263, -94, 194, 1176, -461, -1293, -319, -1170, 100, 442, 1641, 2215, 670, 85, 1032, 1088, 
    -402, 136, 289, -373, 1069, 100, -2142, 1161, 1357, 172, -223, -328, 786, 487, 867, 827, 
    -320, -80, -2005, 925, -930, 102, -1467, 524, 265, 29, -2406, 522, -1334, 120, -2225, 1822, 
    -1021, -502, -475, -2007, -887, -983, -666, -1244, -593, 1725, -129, 1318, 572, -379, 2260, -2277, 
    2105, 1403, 2171, 3764, 1867, 619, -528, -2291, -1897, 948, 880, 3919, 361, -1156, -628, -1317, 
    399, -3487, -1575, 75, -856, -1379, -866, 247, 776, -1957, -1659, 327, 396, 1217, -673, 2249, 
    160, 1791, -2653, 97, 1633, 463, -139, -453, -1201, 870, -1054, 1533, -422, 572, -1154, -1210, 
    -971, -1019, -475, -583, 2188, -297, 775, 618, -2250, 217, -774, 3669, 330, 826, -1558, 416, 
    -726, 106, 91, -3510, -493, -263, 1223, -3225, -757, -199, -1566, -1479, -454, -795, -2007, 270, 
    -2275, 843, -2180, -744, -938, 2407, -133, -422, 536, 998, -3512, 529, -325, 660, 290, 1400, 
    -3576, -2042, 2262, 196, -311, -2216, 5644, -1591, -2614, 249, 323, -70, 356, -858, -216, 560, 
    4454, 1810, 1165, 1096, 825, -881, -602, -2522, 198, 221, 149, -1121, 796, -705, 412, -880, 
    -205, 1486, 69, -545, -876, 165, 462, -259, -73, -383, -1626, -2458, -440, -347, 231, 1404, 
    -674, -2004, 354, -529, -307, 81, 661, 1522, -711, 2027, 885, 1087, 142, 49, -1035, 1651, 
    722, 19, -332, -532, 1369, -187, -1564, 480, -1220, -939, 208, -901, 761, -277, -1258, 258, 
    -5858, -1157, 4, 2327, 1061, 582, -268, -1894, -685, 747, 807, -355, -2499, -207, 394, -1395, 
    -1962, 39, -797, 986, 1686, -51, -1465, 153, -981, 42, 1610, -1273, 258, -135, -435, 293, 
    -221, 440, 548, 1448, -1578, 1654, -1485, -354, 698, 560, -80, 524, -108, -922, -1436, 560, 
    -1172, -344, -1736, -298, 1384, -686, -908, 52, 370, 42, 698, 144, -2078, 70, -5974, 355, 
    -850, 68, 267, -128, -3221, 834, 469, 600, 1197, 1, 861, -217, -1268, 57, -366, -1147, 
    -2298, -365, 3546, 107, 1628, -851, -3200, -194, 120, -962, -1891, -671, 216, 113, -434, -1125, 
    391, 900, -582, -894, 947, -918, 521, -214, -2101, -423, 1125, 1367, -836, 778, 1360, 2, 
    -754, -510, -480, -520, -407, -48, 1340, -265, -1030, -309, 865, -227, -861, -530, 289, 1642, 
    468, 1025, 1454, 258, 397, -805, -1149, 166, 666, -560, 878, -2799, -1130, 162, 315, -3156, 
    -2566, 426, 1301, -1012, 454, -10, 2247, 1604, -119, -445, -984, -17, -208, -126, -696, -1448, 
    -232, -1566, 2212, -313, 357, 888, -1348, 76, 65, 399, -1845, 290, -131, -319, 1902, 393, 
    136, -581, 1489, -1330, -1562, 1398, 688, 84, -130, 101, -3256, -230, -881, -746, 206, -1029, 
    -3380, -184, -574, -430, -505, 877, -317, -937, -136, 449, -256, -227, 945, -191, -414, -307, 
    28, -219, -512, -763, 51, 758, -648, -15, 2112, 339, -1222, -934, -1096, 313, 1877, 80, 
    -745, 165, 225, -236, -486, -789, 762, -2248, -629, 256, 599, 903, -1397, 2017, 1320, -1247, 
    -118, 276, -746, -525, 1827, -978, -2000, -1080, -193, 637, -148, 790, -336, -701, -1915, 268, 
    -253, 393, -428, -1277, -444, 206, -59, -1415, -1241, -13, -250, -502, 257, -513, -884, 282, 
    1007, 429, -2813, 2489, 1113, -1771, 283, -8, 963, 1859, 2190, 2305, -3899, 1206, -1265, -1611, 
    -282, -704, 1457, 2258, 574, 511, 1339, 41, -224, -2281, -1214, -276, -2071, 4325, -1147, 3536, 
    -3871, -874, -114, -1926, -168, -517, -667, -2911, -2931, 1064, 565, -207, 2460, 1609, -1243, -4845, 
    -144, -1087, -795, 513, 105, -1672, 1007, 1135, 678, 161, -351, 163, -2030, 944, 804, -1042, 
    -982, -1182, 929, 574, -1061, -431, 1178, -3375, 932, -2111, -620, -911, 14, -1223, 100, -635, 
    2049, 1645, 320, 1828, -700, 197, -1386, -984, -344, -735, 1532, -1257, -599, 536, 955, -294, 
    82, 629, 468, -4580, -4783, -219, -55, -3583, -180, -1138, 101, -464, -481, -1123, -17, 2835, 
    -1568, 962, 306, 109, 341, 562, -730, 2306, 1252, -719, 893, 2585, 527, 415, 1206, 1987, 
    -344, 744, -801, 1927, -1656, 496, -1071, -882, -356, -429, -1569, 1110, 574, -1461, 2113, -1639, 
    -466, -2280, 609, -1065, 369, 22, 501, -2448, 825, -1711, -1042, -2204, 806, -1128, 1419, 68, 
    294, 331, 1089, 1736, 1044, -889, -1473, -1289, -122, -278, -124, 458, 596, -306, 155, -1599, 
    -602, -1362, -775, 1064, -2103, -792, -1781, 1806, 591, 1453, -705, 1273, 496, 523, 1104, 3671, 
    -1395, -170, -1601, -203, 892, -820, -812, 633, 896, -67, 718, 1124, 1318, 1034, 2354, 352, 
    377, 1354, -1418, 731, -1121, 568, 1201, -421, 1374, 682, 1990, -143, -577, -261, -964, 152, 
    -92, -487, 633, 554, -2894, 883, 1339, -1275, 862, 282, -630, -11, -443, -308, -558, -1143, 
    87, -1369, 378, 698, 209, 1192, -1030, -292, 1200, 289, 757, 1352, 229, -153, 290, -956, 
    1857, -2212, -352, 499, -393, -784, -634, 2499, -2136, -133, 2889, -445, 510, 1179, -1167, -5302, 
    1665, 1348, 2661, 2861, 1087, -1637, -4861, 575, 1772, -13, -893, 104, 303, 1744, 1300, -54, 
    62, 431, 1532, 4384, -2718, -137, 956, -2863, 634, 946, 1591, 2358, 369, 975, -2942, 1651, 
    1093, 1089, 2433, -5191, -2580, 14, -599, 518, 57, 869, 811, -2332, 2191, 471, 954, -1206, 
    1358, -1960, 403, -2150, -1326, -1588, -133, -2662, -1150, -3282, -281, -1676, -1449, -1009, -1353, 6118, 
    300, 538, 1061, 822, -1832, 3894, 64, -750, 2913, 377, 203, -1062, 1158, -1530, -1792, -1569, 
    1407, 2896, 1071, 3695, -515, 644, 1996, -618, 3030, 171, 3064, 2826, -2166, 644, -1010, -2854, 
    1807, 1984, -1710, -936, 1098, 1811, 1299, 1337, -1963, -557, -478, 674, -6842, -721, 1272, 937, 
    951, 2171, -594, 182, -2110, 625, 2374, -483, 1195, 1108, 560, 551, 3711, -1734, 51, 227, 
    -394, -937, 1173, -294, -1007, 342, -1670, -1797, 1064, -976, -5980, -1308, 1693, -3019, -1009, -1554, 
    -346, -1629, -3106, -2383, -959, -864, 1814, -2173, 934, 591, 613, -592, -238, -392, 529, 167, 
    737, -1844, -2104, -1367, -1101, -67, -882, 2097, 894, -292, -1334, -530, 3593, -940, 489, -4439, 
    -1631, 1456, -2469, 1889, 1371, 457, -1590, -2491, -698, 2583, 1317, -359, 3883, -663, -698, -148, 
    -43, -193, -1867, 477, -2036, 1050, 995, -2466, -761, -5077, -3020, 3632, 3663, 1312, 970, -1381, 
    -1370, -893, -336, 650, -383, 426, 1641, 2096, -3589, -1162, 2688, -3283, 2480, 971, 452, 2020, 
    415, -680, -747, -1076, 2065, 154, 1023, -110, 14, -826, -77, 2123, -763, 1443, -1837, -2160, 
    619, 675, -444, 299, -1059, 1217, -687, 2753, 730, 470, -36, -2363, -139, 803, 1346, -2292, 
    406, -1025, 1042, -791, 1834, -1364, -475, 133, -1014, -539, 842, -36, -186, -232, -552, 203, 
    -811, -943, -1117, -269, 827, 1099, -365, 795, -571, 789, 246, 380, -494, 237, -13, 1091, 
    -448, -1562, 679, -671, 768, -64, -1335, 873, 478, -1023, 861, -904, 549, -65, 519, 118, 
    1380, 254, -1814, -1290, -1199, 970, 579, 655, 1282, 1684, -1759, -1490, -1767, 355, 1869, 1292, 
    -584, -1062, 42, 514, -903, 810, 838, -40, -390, 500, -55, 1672, -769, 501, -739, 335, 
    549, 891, -2167, -57, 679, -564, 1321, -471, -518, -1561, 982, 9, 1856, 160, -1228, 732, 
    -398, -1161, 884, -801, -1305, 521, -1603, -791, 808, 155, -169, -3778, 1531, 552, -1530, -2419, 
    -2545, 200, 2798, 666, 2878, -666, 1541, 564, -903, 559, -1271, -68, 23, 518, -706, 390, 
    -1624, -856, 1474, -37, 580, -77, -625, 1059, 617, 290, -4372, -188, -687, 1038, -1374, 1104, 
    557, 583, -2062, 89, -736, 628, 247, 794, 407, 728, 277, -148, -85, -95, -441, 1150, 
    -4140, -1103, -568, 1568, -137, -575, -526, -2453, -996, 707, -551, -467, -1064, 66, 328, -1388, 
    225, 185, -353, -228, -132, 1452, -1455, 1226, -2156, -931, -85, -361, 1082, 1067, -1308, 545, 
    310, -242, -1851, -490, 840, -922, 830, 520, -1020, 1389, -447, 1011, 461, -4336, -24, 1546, 
    579, 693, -41, 40, 135, 341, -943, 1692, -1550, -270, 448, -451, -854, -290, 701, 1316, 
    -195, 434, -362, -235, -584, 1276, -44, 944, -3070, 1366, -1611, -365, 819, 468, 2154, -264, 
    2716, 473, -1260, 2842, -1634, -402, -1210, -2462, -624, 794, 323, 700, -2324, 377, -255, 113, 
    -383, -2322, 831, 1415, -1019, -1944, 740, 335, 254, -578, 106, -1303, 549, 1294, 1198, 2817, 
    -818, -81, 1581, 1420, 1716, -455, -204, 78, -186, -431, 817, -2827, 12, 121, 493, 1269, 
    139, 642, -1204, 4915, 821, -405, 465, 602, 1991, 200, -181, -212, 1010, -1733, -937, -2321, 
    358, 349, 200, -954, -69, -1246, -1013, -2031, 798, -1430, -956, 633, 263, -513, 491, 848, 
    1294, -776, -379, 1328, 444, 1176, 653, -3609, -503, 835, -549, -122, 1465, -931, -404, 121, 
    50, -181, -204, 139, -968, 34, -849, -988, 1177, 1160, -1093, -1574, 1732, 65, 825, -89, 
    -1010, -1064, -333, 325, -596, -27, 649, -444, 93, -863, 659, -535, -613, 200, 13, 1842, 
    4672, -165, 252, 1286, -1129, 563, 1130, -820, 101, 96, -374, 74, 348, -596, 1738, -367, 
    2183, -2166, -504, 1127, -131, 1181, 177, 1635, -88, 188, -265, -277, 237, 309, 1602, 303, 
    1294, -721, -53, 618, 394, 403, 213, -90, 528, -28, 159, -119, 1647, -578, -270, 789, 
    416, -505, -463, 536, 885, -1810, -702, 1876, -261, -410, -0, 427, 832, 232, 535, 667, 
    1119, 76, -337, -148, 441, 319, -627, -80, -1669, -339, -1575, -3310, -2811, -76, -1036, -1167, 
    -284, -99, 342, 669, 530, -1327, -903, -29, 1033, 2379, 174, 435, -400, 268, 1423, 73, 
    32, -55, -292, -15, -292, -334, -317, -371, 423, -2022, -1293, -1601, 550, -125, -612, 313, 
    262, 32, -436, -63, -582, -681, 772, -355, -1789, -199, 1760, -5666, 865, -1266, -46, 632, 
    1557, -623, 1996, 494, 186, -1096, 71, 222, -1538, -689, 2219, -3060, -1467, 1735, 146, 415, 
    1381, -1752, -2017, 578, -1249, 2023, 1408, 18, 280, 1370, 2050, 188, -2038, 608, 948, -33, 
    -34, -863, -246, -1255, 729, -877, 1134, 222, 315, -30, -850, 3378, 326, 462, 549, 354, 
    -2555, -2433, 71, -2925, 588, -1525, -106, -921, 2589, 443, 112, -739, 1596, -943, -1437, -671, 
    -473, 1402, 1055, 305, -4750, 593, 1991, -191, -674, 1064, -317, -2153, 1758, 1026, -1714, -3681, 
    -1290, 95, 822, -676, 328, 2209, 1794, -470, -371, -190, -1700, -2175, 1062, 342, -930, 345, 
    255, 339, 697, -642, -154, -841, -1413, 917, -700, -1385, -442, 1020, 474, -278, 1104, -1224, 
    388, 95, 527, 158, 435, 555, 1180, -226, 802, -1028, -81, 4301, 1295, -1604, -409, 1176, 
    127, -1508, 283, -244, -1244, -1337, 1502, 2076, 385, 713, -1017, -237, -1119, 103, 115, -1712, 
    -108, -1379, 1197, 682, -2718, -524, -598, 493, 672, -525, -2450, -230, -253, -1335, 449, -140, 
    -1546, 1224, -979, 680, 160, -666, -1213, -407, 407, 608, 536, -589, -899, -1357, 769, -2, 
    2196, 249, -2350, 489, -3137, -1078, -2427, 2707, -86, 42, -17, -125, -216, 3, 507, -456, 
    523, 312, -768, -410, -1542, 1969, 2751, 821, 227, -629, 1614, -1989, -3553, -1610, -2600, -215, 
    681, -131, 210, -619, -1888, -438, 1394, -997, 1185, -499, 128, -139, -1097, 128, 188, 638, 
    717, 276, 287, -882, 169, -138, 1631, 485, 563, -223, 707, 627, -218, -1301, 1484, 517, 
    233, -168, -204, 132, 789, -900, 828, -1014, -1268, 1120, 898, -341, 1378, 1497, -408, 600, 
    2526, 127, -3699, 803, 332, -804, 306, -2053, -145, -836, 3310, 2782, 435, 150, -414, -418, 
    -855, 1513, -1523, 78, -795, 137, 1534, -958, -74, 598, -244, 912, 170, 278, -3765, 51, 
    -256, -358, -455, -361, -580, -285, -103, 1103, -777, -1389, 1445, -1437, 214, 233, 1542, 73, 
    -1929, 261, -74, -1223, 846, 1161, -281, 1474, -525, -1303, 687, -3056, -2031, 449, -193, -39, 
    -695, -36, -317, -159, -1481, -678, 991, -937, 2820, -42, -987, -296, -978, 468, -2245, -2440, 
    -70, 861, 936, 620, -297, -1067, -929, 10, 1916, -1245, -1519, 677, -981, 308, 1386, 889, 
    -32, 31, 490, 173, -100, 905, -70, 306, -540, -146, -816, 397, 760, 173, 256, 808, 
    354, -516, -286, -1118, 135, 478, 592, 1574, 1041, 996, 728, -2167, 2098, -1196, 1123, -185, 
    1344, 564, 1326, 3776, 857, -1455, 1846, 1271, 232, -86, 147, -610, -461, 265, -2043, -582, 
    1991, -757, 741, 1001, 855, 1230, -1805, -618, 165, -206, -2351, -161, -1032, 1287, 320, 599, 
    -478, -486, -11, 821, -354, -1310, -594, 243, 314, 711, 302, -86, 297, -602, 643, 175, 
    1455, 466, -949, -168, 362, 629, -1326, -379, -508, 594, -199, 454, -1379, -353, -236, -1230, 
    -207, 16, -123, -571, -1869, 154, 734, -429, 1390, -698, -108, -1716, 1767, 27, -1357, -143, 
    106, -83, 504, 25, -474, -435, -1295, 953, 468, 457, -1737, -353, -1165, 366, 392, 451, 
    -30, -9, -206, 362, -224, -743, -1051, 885, 769, 657, 496, 35, 75, -1517, 119, -6, 
    -26, -158, -48, -357, 860, -1921, -341, -405, 452, -401, -575, 605, -1202, 319, -548, 668, 
};

static const int16_t fx2a_paramModel2Alpha[16] = {
    -2165, 6905, 1754, 1026, 1806, 1451, 904, 2191, 1438, 2537, 850, -3584, 717, 11065, 7383, -114, 
};

static const int16_t fx2a_paramModel3Bias[16] = {
    -102, 32, -55, -76, 69, -64, -266, -578, -141, -381, 357, 845, 169, 773, 190, -127, 
};

static const int16_t fx2a_paramModel3Weights[2304] = {
    -30, 1534, 526, 87, 893, 187, 904, 595, -748, 485, -386, -3040, 2388, -1208, -697, 1202, 
    -680, 491, -2316, 1042, -9, 1694, -1042, 599, -16, 4639, 44, 1493, -1096, -855, -340, -68, 
    295, 2012, -445, -1326, 303, -332, -518, 1085, -1034, -2180, 2429, -1114, 379, 542, -1312, -693, 
    -1098, -925, 959, -1384, -2276, 702, -1123, -25, 917, 2120, -437, -1315, -1124, 765, 665, 1515, 
    -1710, 1269, 364, -949, -1881, -125, -703, 209, 408, -313, 392, -195, -2901, -476, -326, -346, 
    610, 633, 946, -1347, 556, -848, -1653, 1181, 344, 1760, 606, 963, 904, -430, 1403, 89, 
    67, -879, 19, 1794, -128, -1151, -826, -241, -157, -249, 447, 904, -801, -59, 285, -483, 
    630, 1128, -975, -982, 184, -116, 410, -207, -699, 543, -269, 64, 1090, -1087, 61, 878, 
    -4686, -793, -134, -631, -1616, -858, 571, 254, -588, 128, -281, -63, 585, 458, 313, -2, 
    -667, 476, -340, -789, -596, -1904, 219, 231, 154, -2032, -1153, -148, 1061, -302, -120, 825, 
    901, 26, -388, -1571, 1349, -1234, -103, -1783, -177, 39, -327, 1201, -130, 1112, -616, -473, 
    73, -216, 330, 1062, -729, -143, 722, 1258, -629, 208, -110, -221, -441, -403, 5, 80, 
    -3152, -174, 131, -200, 2757, 60, 683, 310, 3673, -511, 1285, 632, 134, -835, 112, -162, 
    1484, 690, 2103, -639, 575, 108, 869, 1136, -643, 182, -1909, 470, -239, 94, 58, 399, 
    -802, -2296, -2210, 1191, 170, 88, -767, 510, 1186, 1118, 1346, -1070, 141, -607, -114, -335, 
    1052, 85, -986, -519, -1300, 232, -685, 179, -1118, -1364, -671, 320, -529, 142, 156, 53, 
    147, 510, -385, -222, -551, -995, -124, -1357, 228, -211, -287, 602, -6999, 56, 62, 760, 
    1144, 1512, -549, 2860, -137, 3149, 814, 388, 2753, 1027, -746, 1351, 2165, 1847, 4103, -1475, 
    537, 705, -378, -947, 474, -1536, 2270, -1015, 1090, 831, 1349, 334, -1706, 395, 1527, 1428, 
    637, -1189, 402, -736, 925, -1146, 625, -3492, -1095, -975, -2258, -1307, -2940, 1746, -880, -2677, 
    908, 243, -702, 174, -1615, -292, 402, 466, -1553, 185, 581, -345, 34, 947, -380, 859, 
    -405, -54, -387, 817, 770, -889, -10, -992, 414, 673, -364, -92, 239, -1794, 2464, -725, 
    409, -2394, -2462, -414, -915, -411, 966, 1821, 388, -612, 881, 198, -1, -409, -1918, 515, 
    3374, 105, -52, -341, -914, 460, -552, -1083, -187, -17, -23, -730, 1263, 112, 400, 1060, 
    -479, -22, 1225, 1202, -902, -64, 430, 1444, -35, 688, -297, -737, -58, 1204, -763, -155, 
    -2011, -3035, 119, -864, -965, -1481, -527, 463, -835, 696, -489, -959, 565, -1410, -648, 1506, 
    188, 1080, 639, -1409, -726, 1067, -1420, -360, 442, 949, -96, -1623, 555, 1310, -3872, -1098, 
    -1402, -469, 1664, 1796, -154, -1382, 2028, 1889, 529, 553, 253, 544, -790, 92, 253, 779, 
    234, 903, 843, 376, 1833, 481, -1435, 18, -636, -1230, 868, 526, 2834, -2144, -1167, 605, 
    -2210, -1206, 339, -485, 293, 1230, -564, -245, -1019, 1434, -750, 858, -74, 1085, 2127, 282, 
    694, 589, -1336, 1046, -147, 947, -2251, -1785, -794, -1810, 2524, -1072, -410, -1115, 3004, 289, 
    -531, 430, 1001, -233, 257, 1123, 358, 1594, 571, -621, 983, -276, -118, -652, -128, -2474, 
    736, -16, 767, 1048, 74, -210, -436, -70, 359, -233, -1810, -552, 2062, 436, 1030, -281, 
    -1283, 1767, 2234, 1607, 247, 1218, 1294, 316, -652, -182, 706, 2888, 725, 1000, 523, -224, 
    -183, -816, 655, 705, 150, -389, 2768, 802, -210, -963, 3076, 0, 644, 455, -1211, -687, 
    -615, -514, 586, -206, 173, 573, -142, -178, -556, -263, -619, 1571, -291, -511, 311, -1099, 
    -107, 129, -174, -361, 2131, -234, 313, 215, -5, -504, -87, 30, -926, -731, -108, 135, 
    91, -535, 1663, 302, -305, 1526, 647, 3196, 87, -1092, 181, 1069, -330, -2053, 391, -396, 
    425, -684, -1690, -655, 347, -1231, 915, -54, 131, -122, 194, -13, -447, 1561, -1196, 1189, 
    -179, 196, -472, 997, -113, -400, 124, 364, -874, -682, 102, -1104, -139, -301, 426, 78, 
    67, -890, -431, 36, 2221, -1053, -1176, 261, -1531, -904, 591, 349, -952, 388, -316, 27, 
    727, -3361, -1038, 719, 747, 584, -105, 1352, 619, -1372, 1114, -680, 448, -1684, 1342, 897, 
    -733, 2647, -1671, -2407, 307, -1107, 318, 109, -444, 210, -396, 31, 22, -183, -1434, -1171, 
    -1788, 511, 554, 765, 334, -1443, 163, -453, -365, 135, -130, 252, 609, 298, -546, 779, 
    1437, 300, -104, -930, -2087, -243, -430, -202, 740, 234, -406, 627, 1071, -79, -663, -57, 
    -197, 847, -169, 1601, 52, -799, 880, -2116, -288, 309, -1132, -109, -14, -1428, 663, 173, 
    1036, 358, 158, -1605, -348, 1980, -620, 1022, -33, 1256, 430, -461, -18, 1477, -555, -418, 
    -429, -432, 408, 591, -660, 426, 533, -5, 686, -402, 911, 870, -892, -506, 198, -1044, 
    990, -688, 1311, 1876, -929, 642, 891, -726, 2700, -272, -750, -1829, -342, 2321, 153, -1897, 
    -802, 1799, -1087, 3128, -1556, -2693, -2097, -2333, 1517, -667, 495, 258, 602, 960, -461, -415, 
    -320, -1152, 2021, -1569, 925, 1028, 479, -58, -992, 287, -2030, -1915, -268, 75, 8, 186, 
    -1896, -581, -32, -624, -341, -450, -499, 439, 920, -266, 2379, -602, 2162, 617, -279, -370, 
    -2702, 1548, -553, -567, -6881, -697, -815, 146, -1768, 438, 798, -126, -393, -519, -538, 168, 
    -61, -1233, -1410, -3094, 1526, 559, -375, 1411, 421, -852, 330, -194, 62, -743, -408, 1012, 
    116, 1656, 814, 2370, 23, -469, 1160, -1434, -178, 246, -24, -168, 1000, 872, -1790, 104, 
    -1289, -113, 851, -413, 231, -1891, 182, -1359, 531, 427, 40, -416, -859, 829, -160, 1205, 
    2377, 20, -497, 819, -3579, -1265, -1698, 225, -440, -767, 56, 327, 576, 370, -585, -46, 
    -784, -1347, 273, -1133, -700, -1660, 261, 1167, 274, 2482, -1127, 2394, 256, 925, -263, 1126, 
    229, -1370, 1349, 1468, 1081, -1212, -1805, 225, -962, 1344, 318, 484, -23, 1080, -1083, -1030, 
    1817, 983, -1074, -16, -1140, 651, -661, 1873, 431, 349, -199, 2229, -443, -224, 460, 160, 
    -272, 38, -632, 1049, 767, -1390, 599, 901, -868, 1486, 1616, 778, -360, 352, 366, -128, 
    709, -2912, -131, -2124, -395, 347, 1219, 784, -1637, -1050, -741, 669, -336, -1675, 39, -608, 
    1065, -2348, -2672, 2657, -153, -293, -50, 324, 750, 861, -702, 1774, -224, -874, 86, 1503, 
    -331, 100, 370, -458, -529, 685, 9, -93, -1620, 1651, -2075, 172, 315, 536, -346, 332, 
    -627, -1326, -170, -486, -319, 2548, -43, -301, 1652, 927, 131, -1698, 820, 622, 3049, -1357, 
    246, 1926, -4168, 842, 1665, -1140, -1609, -5059, 281, -2798, 758, 1354, -178, -592, 314, -1183, 
    -1046, 2017, -2228, -704, 1086, 1347, 1275, -1607, 218, 2495, -602, -455, 4073, -1531, -549, -2212, 
    -171, -512, 188, -682, 1300, -1668, -285, -2314, -1129, -837, -516, 1952, -1389, -2017, 1845, -1812, 
    1868, -3138, 617, -226, -1732, 41, 440, -226, -3702, -181, 546, -35, 1118, 1343, -1041, 1008, 
    -1129, -883, -1405, 1227, 131, 2536, -1876, -681, -606, -1784, 986, -98, -1355, -2224, -854, -3683, 
    -756, 1198, -3268, -2505, -1497, 1247, -2375, 2867, 610, -1139, -2807, -1980, -1204, -702, -2263, 1553, 
    -955, 292, 2198, 2470, -1939, 3277, -1190, 2124, -1243, -185, 1030, 522, -1524, 1167, -318, 476, 
    1628, -1521, 88, -1072, 234, 2294, -964, -377, 5151, 104, 411, -345, -75, -1701, 1437, -1577, 
    247, -1218, 2388, -1145, -1611, 332, 527, -1928, -630, 3911, -1192, 1604, 1020, 1644, -745, 3287, 
    -1097, -1699, 4108, -528, 53, -508, 472, -1534, -309, 1309, -11, -1144, -903, 1191, -2017, -5309, 
    -839, -269, -29, -2840, 634, 1407, 2850, 1531, 3066, 1592, 653, 288, 590, 389, 1168, 2101, 
    711, 3825, 848, -964, -1416, 2108, 1237, -1609, -907, 748, 477, -119, 345, 412, -2430, 1161, 
    -36, 1753, -1433, -3093, -853, 1003, -1578, -339, 1651, 1297, -749, -1259, 296, -2976, -293, -4607, 
    -2229, 3204, -3158, 401, 386, 500, 1448, -259, 1232, 1038, -1396, 1537, 299, -1648, 1848, 1941, 
    -563, 2334, -1056, 366, 2453, 1987, -134, 636, -429, 2723, -232, -446, -427, 356, -1104, -3348, 
    748, -293, 200, -30, -760, -900, 162, 177, -1799, -706, 414, 97, 886, -1599, 654, -866, 
    -790, 1076, -343, 1663, 972, -522, 439, 444, 1725, -1280, 549, -1197, -945, 1615, -1950, 323, 
    221, 417, 211, -1643, -192, -24, -1996, -1557, 1020, -355, 503, 1223, 740, -1154, -4083, -816, 
    704, -1344, 495, -1000, -938, 1113, 456, 553, -648, 478, -1274, 2443, -933, 1305, 1298, 1023, 
    -869, -134, 323, -261, -1403, -161, 7, -464, -303, 1162, 29, -471, -196, 1377, 56, 167, 
    1278, -10, -5356, -2857, 685, -8, -2484, -1244, 576, 276, -906, -802, -474, -1260, 1418, -2950, 
    103, 2452, 1912, 191, 64, 1376, -2245, -903, -193, 2316, -2683, 533, -124, -198, 21, 266, 
    -652, -318, 418, -2038, 314, 724, -300, -2368, -384, 831, -756, -4317, -798, 55, -73, -499, 
    -395, 1640, -110, -308, -240, 196, 263, 488, -1420, 748, -150, -157, -268, -701, -955, 1101, 
    -944, -468, -1221, 918, -1104, 1002, 1684, -2215, -704, 526, 2260, -2392, 417, -1382, 605, 2168, 
    1308, 36, -550, 1858, -1121, 223, 408, -491, 238, 554, 884, 1430, 523, -1159, 1686, -140, 
    -68, -2315, 1056, 96, 432, 1257, -345, -3847, 428, 1074, 567, -1089, 304, -373, -325, 2923, 
    1492, -642, -441, -636, -573, 1509, 88, -158, 1734, -84, 821, -123, 766, -384, 135, -665, 
    -634, 866, 1309, 1208, -545, 909, -720, -1664, -481, 67, 427, 1018, 238, 127, 579, 706, 
    1591, -1775, 986, -2317, -346, 823, 1861, -482, -147, -569, 288, 210, 469, -961, 568, -1346, 
    628, -1036, -1001, 748, 920, 658, 248, -683, 210, -565, 650, -59, 592, -1833, -707, -1128, 
    -86, -955, 879, 873, -556, 940, -618, 598, 2608, 482, -445, -555, -41, -1379, 1973, 1175, 
    766, -45, -858, 1121, -284, -363, 929, 1581, -2220, -1339, 1847, 1189, -848, 1120, -1271, 330, 
    83, -403, 877, 964, -664, -610, 159, 497, -3495, -1175, -589, 556, -706, -1067, 443, -1819, 
    -1330, -863, -333, 311, 675, 289, 104, -764, -13, -613, 323, -1780, -1098, -448, 220, 853, 
    -2245, 895, -67, -1691, -2030, -2094, 2083, -757, -1939, -717, -341, 85, 1525, -262, -151, 524, 
    684, -564, -403, -1336, 426, 498, -1341, 461, -355, 56, -252, -38, 658, 129, 667, 588, 
    2, 1399, -1049, 806, -879, 859, 481, -1260, -911, 50, -347, 217, 232, 98, 261, 433, 
    795, -1068, 1371, -825, -1065, -1270, 1629, -215, 145, -573, 667, -23, 163, 848, -556, 10, 
    1621, 404, -92, 255, 110, -1073, -844, 197, -1557, -1447, 132, -1565, 256, -805, 592, -19, 
    -63, 80, -46, -1074, 1485, 106, -16, 1825, -1964, 943, 47, -1044, 299, 189, -368, 561, 
    292, -854, 1524, 2087, 1793, -217, -549, 264, 725, -601, -23, 1316, 234, 1024, -886, -1215, 
    -523, 515, 88, -90, 465, 1359, -2125, 234, 740, -1710, 1773, 991, -420, -836, 110, 486, 
    862, -1489, -2213, -201, -327, 325, -143, 720, -682, 1104, -1011, 1388, 823, -488, -350, 492, 
    1339, 1272, -488, 595, 95, 76, 1336, 1740, -230, -471, -374, -701, 378, 43, 703, 1293, 
    -180, -968, -990, -2393, -796, -1200, 373, 313, 360, 771, -722, 410, -251, -406, 747, 586, 
    1103, 1548, 483, -726, -773, 1117, -248, -463, -15, -1070, -11, -721, -1063, 1217, -229, -732, 
    -389, -991, 1334, -409, -1789, 1205, -497, -844, 322, 1201, -209, 42, 291, -104, 238, 619, 
    -1159, 544, -363, 1379, -596, 971, -836, -1105, -3071, -741, 820, -371, 337, 2283, -1285, 140, 
    210, -339, 57, 408, -197, 265, -90, -405, -727, 333, -123, -994, -1227, -926, 463, -2747, 
    -379, -755, 41, -31, 222, -410, 932, -833, -1366, -1624, 2009, 1344, -4779, 1172, 22, 695, 
    -2201, 465, -1079, 842, -1710, -1280, 2731, -545, -2338, -152, -1732, 919, 1540, 1085, -774, -656, 
    295, 655, -907, 134, -880, 1850, -1130, 1496, 278, 2274, 1143, 43, 821, 739, -516, -7, 
    -311, -1262, 1076, -737, 1298, -1863, 1767, 64, -954, -1348, -387, 27, 830, 1517, 583, -541, 
    1023, 453, 723, 885, 1366, -1223, -476, 495, 1341, 1597, -49, -958, -157, -528, 157, -383, 
    -725, 638, 1072, -426, -13, 254, -555, 270, 1768, -2413, -1853, 907, 1742, -2082, 1704, -920, 
    683, -251, -1032, 194, 1962, 1237, 1007, -1503, 816, -122, 1168, -579, 660, -271, -361, 1641, 
    -292, -345, 1685, -402, 991, -60, 407, 1941, -974, -2938, 4561, -2966, 607, 1377, -2040, -3207, 
    629, 455, -563, -432, 980, 182, 532, -279, 15, -2460, 1131, -904, -340, -684, -184, 1468, 
    729, -176, 288, -672, -1344, 259, -387, -245, 1064, -923, 695, 258, -249, 1644, -1240, -212, 
    -1585, -966, -679, -180, -402, 862, 183, -745, 2162, 767, -472, 352, -21, 551, 830, -404, 
    394, -181, 1126, -2565, 534, -472, 4, -1319, -967, -238, 1095, 988, 365, -1342, 1245, 1420, 
    2498, -1808, 309, -195, 1846, -545, 147, -330, 840, 45, 870, 378, -441, 221, 370, -85, 
    -323, -528, -291, -4, -53, -817, 141, 371, -557, -1231, 299, -111, 40, -851, 318, -896, 
    -186, 488, -749, 1060, -18, 331, -102, 198, -2510, 563, -534, 2858, -262, 494, -223, -389, 
    205, 103, -187, -276, -387, -1415, 631, 542, 307, -141, -493, -1573, 571, -1120, 435, -1850, 
    -513, -669, 152, -505, 58, -484, -137, 265, -887, 415, 1233, 3980, 918, 631, 44, -1446, 
    -1793, 886, 192, 156, -168, -860, 573, 26, -1244, 743, 534, -310, 909, 66, 338, 102, 
    -1107, -660, 147, -1597, -733, 154, -1202, 264, 1145, 359, -251, -2461, -916, 396, 1185, -203, 
    -1033, -1305, -484, 1555, 247, -614, 154, 299, 169, 33, -82, 1464, 188, -118, 419, -2260, 
    1276, 52, -1195, -949, 88, 199, -85, 1182, 1826, -1920, -744, -1597, -1415, 39, 839, 387, 
    -1300, 385, 346, -493, 291, 480, 190, -168, -844, -77, -248, 1158, 565, -353, -386, 850, 
    -663, 404, -874, -571, 910, -832, 691, -313, 312, 212, 935, -701, 277, -1186, 977, 1194, 
    464, 852, -1016, -3023, -171, -1152, 1297, 1145, -2038, 645, -58, 765, -545, 751, -404, -338, 
    1050, -816, 288, -952, 667, 488, -149, -661, 328, 1092, 59, -677, -2690, 1203, 108, 625, 
    22, -1347, 81, 710, -104, 234, -461, 261, -1417, -77, 97, 261, 154, 826, 233, -332, 
    -551, -344, 139, 93, 684, -255, 658, 1, -668, 147, 1150, 348, -466, 435, 477, -652, 
    1239, -744, -1005, -3258, -475, -825, -85, 784, -161, -144, 89, -1491, 270, -385, 1066, -2124, 
    -2115, 552, -322, 1852, 342, -222, -474, -907, 527, -295, -939, -1418, 1222, -140, 160, -288, 
};

static const int16_t fx2a_paramModel3Alpha[16] = {
    134, 5019, 902, 4487, 3453, -570, 1184, -1249, 7004, 902, 627, -112, 3534, 283, 8613, -1003, 
};

static const int16_t fx2a_paramModel4Bias[16] = {
    14, 378, -331, 23, -535, -71, 43, -105, 32, -243, -198, 361, 279, 236, -386, -154, 
};

static const int16_t fx2a_paramModel4Weights[2304] = {
    -245, -570, -524, -403, 955, -543, 689, -586, -475, 1416, -389, 858, -936, 129, -396, 277, 
    -230, 10, -824, -1060, -810, -744, 837, 1734, 1145, -178, 1352, 919, 510, -531, 1541, -1659, 
    2279, -532, -111, -866, 1086, 100, 499, 1238, -550, -1136, 314, -1153, -313, -1235, 488, -163, 
    245, -2062, -1155, -828, 253, -452, 1979, 490, -755, 520, 425, -316, -1059, -15, -526, -884, 
    177, 414, -7, 106, -143, 487, -274, -520, -477, 692, -736, -397, -926, 214, -2292, 718, 
    -656, 506, 319, 113, -212, -488, 331, -96, 549, -391, -1, -72, -104, 876, 118, 1012, 
    1604, -1690, 90, -595, -1245, 737, 178, 298, -110, -179, -173, -1115, 760, -25, -623, -123, 
    318, -742, 101, -462, -821, 557, -831, -733, 52, -44, -663, -462, -3415, -1285, -1915, -114, 
    -142, 246, -693, 1067, -305, 95, 141, -413, -484, 1099, -651, 792, 433, -524, -809, 373, 
    110, 269, 362, 980, -173, -505, 21, -531, -301, 247, 441, 637, 1105, 482, -1246, 1396, 
    2427, -1998, 651, -1571, -560, 194, 397, 415, 1645, -1176, 933, -105, -1672, 64, -622, -1954, 
    465, -221, -439, -218, 620, -263, -1755, -385, 536, -503, 770, 946, 691, -812, 296, -226, 
    -505, 55, -610, 250, -1150, 900, -509, 766, 69, 462, 580, -137, -1491, -155, -1154, -53, 
    92, -97, -494, -245, 636, 586, 296, -761, -282, -121, 1620, 235, -583, -1018, -1691, 1797, 
    2456, -1013, 399, -723, -504, -1075, -706, -1508, 1023, -1528, 496, 543, 1731, -1982, -884, -672, 
    421, -488, -12, -274, -465, -167, -755, 78, 117, 1191, 910, -470, -1095, -929, -2994, -509, 
    -852, -194, -230, -825, 387, -394, -173, -68, -1206, 961, -81, 1197, -629, 642, 205, 1531, 
    -148, -750, 106, -1396, -919, 1957, 1819, 2070, 1484, -802, -1233, 503, 76, -912, 2419, 1334, 
    1584, -759, -648, 594, 3607, -127, -83, 1061, -346, 197, -601, -1576, -481, -1354, 1362, 1109, 
    -492, 82, 32, -166, 1246, 1025, 577, 1503, -402, -2992, -105, -621, 1471, 730, -1031, 75, 
    -454, 979, 1487, 185, 540, -613, -228, -290, -127, -218, 577, 23, 376, 461, 106, 653, 
    12, -1199, 972, -2539, 276, -489, 1370, -97, 352, 329, -872, -453, -175, 1736, 1965, 2855, 
    -2481, 1707, 895, 1780, -47, 421, 1154, 1064, 79, -567, -348, -556, 58, 213, 886, 1292, 
    655, -569, -160, 920, 536, 270, -669, -511, 1224, 103, 12, 142, -151, 1330, 161, 614, 
    1116, -615, 1100, 1935, -548, 976, 2323, -432, -665, 1823, 575, 317, 432, -719, -940, 199, 
    263, -444, 374, -227, -125, -2165, -759, -857, 713, -2809, 485, 903, 323, -440, 53, -3382, 
    -1081, -495, -448, -316, 766, -1103, -628, 1116, -554, -991, 21, -1018, -841, 85, -1296, -1622, 
    622, 1364, -678, -935, -489, 40, 1426, -209, -852, 42, 687, 140, -421, -1908, 458, -454, 
    -75, 584, 1914, -7, 247, -908, 534, 366, 141, 66, 1663, -248, -532, -519, 1165, -3, 
    -22, -1962, -734, -871, 548, -1, -377, -639, 193, 593, 2539, -1496, 298, -1726, 863, 671, 
    -432, -1062, -1132, -981, -2458, 603, -453, -931, -1819, 1223, 1017, 720, 588, -386, -312, 817, 
    -853, 372, 1603, -432, 330, 482, 337, -542, 873, -903, 551, 484, 361, 570, -548, -284, 
    -139, 194, 1050, -554, -796, 1587, -90, 345, -1761, 1241, -464, -374, 1462, 194, 1110, 464, 
    -569, -303, 1172, 1047, -1103, -420, 1213, -817, 1090, -2561, 101, 1508, -400, -721, 768, 1945, 
    588, 909, -882, 629, 257, -412, 1934, 726, 328, 12, -1197, -828, 396, -54, -84, -866, 
    171, 1389, -1443, 711, 975, -317, -1334, 1741, -60, 49, -475, 276, 1290, 486, 827, 911, 
    228, 743, 753, -500, 609, -146, 169, 284, -28, 190, -257, -145, -85, 669, -682, 211, 
    479, -2157, -396, 209, -1032, 1761, 1323, 293, 138, -223, -104, 845, -471, 1303, 1162, -659, 
    376, 825, -2, -1371, 1247, -68, 1740, 1774, 13, -249, 279, -204, -457, -95, 1244, 1011, 
    30, 705, 1796, 542, 927, -688, -161, 889, -211, 329, 140, -109, 800, -1826, -326, 811, 
    995, -467, 1041, 707, 314, 810, 894, 73, -493, 582, -734, 562, -808, 30, -1353, 43, 
    63, -629, 212, 2232, 484, -1126, -253, 875, 644, -555, 74, 490, 1011, -612, -933, -1807, 
    1538, 334, -840, -2236, -440, 874, -2081, -573, 43, -365, -188, -1317, -720, 167, -70, -1907, 
    -251, 1256, 878, 157, -300, 1259, -405, 152, -347, -1291, 573, -5, -122, -2118, -141, -768, 
    452, 26, 171, -311, 135, -863, -643, 469, -481, -21, 95, 275, -13, 1270, 575, -207, 
    410, -1625, -300, 1017, -45, 1248, -710, 467, 151, -48, -552, 7, 465, -398, -198, 562, 
    -333, 539, -269, -632, 753, -438, -258, -393, 50, 342, 1289, -525, -648, 106, -429, 178, 
    341, 1528, 97, 72, 92, -731, 1062, 66, 107, -971, 1196, 150, -88, 362, 467, 217, 
    -419, -162, -654, -145, -287, -43, -64, -285, 682, -346, 571, 38, 1231, 394, 1123, 1281, 
    -524, -586, 865, 598, -141, -1013, 1359, 817, -1083, 212, -251, -819, 1286, 443, -85, -1112, 
    992, -210, 243, -340, 812, -2246, 906, 160, -1301, -892, 1593, 473, -2329, -298, 755, -153, 
    -359, -2308, -2702, -904, 3181, -2787, 171, 73, -419, -1288, 25, 300, -504, -49, 632, 1389, 
    387, -769, 620, -892, -487, 755, 672, 40, -646, 1, -344, 293, -261, -3304, 1478, -771, 
    1010, -204, -1680, 531, 421, 382, 534, -438, 1035, -546, -889, -1801, -1843, -672, 53, 432, 
    2165, -2777, -444, -191, 264, 30, 807, 247, -5170, 1778, -1219, -28, 263, 19, 1176, 53, 
    1643, -1275, 349, 609, -98, 5, -2580, -236, 321, -1337, -845, 272, 863, -4229, -1071, -308, 
    1079, -626, 1140, -217, 186, 26, -723, 1931, -503, 179, 1256, 701, 127, -516, -2033, 826, 
    1154, 875, -435, 45, 2130, 1223, -74, -690, 707, -1111, 613, -282, 1751, -1233, -2067, 1016, 
    -1243, -1298, -1433, -1160, -2044, 1499, -1471, -1277, -2085, -218, -1518, -1226, 7, 460, -1612, -1679, 
    -778, -740, -1672, -937, 456, 1806, -2939, 262, 390, -3524, -784, 921, -1711, -1614, -441, -902, 
    1182, -22, 1512, -204, 821, 732, 687, 803, -565, -1477, -605, 1248, -1249, -1766, 1289, -2467, 
    275, -1258, -775, 591, 1561, 1091, -433, -2627, 1339, -575, -45, -544, -1711, 519, 4744, 866, 
    36, -1438, 1294, -614, -1079, 680, -1519, -1086, 475, -769, 1042, 507, 313, -230, 64, 1364, 
    -559, 761, 547, 807, 330, 1941, 457, 973, -807, -2073, -2469, -108, -1581, 404, 2705, -1033, 
    -1440, -659, 945, 251, -2026, -2225, -1196, -16, -848, 1267, 498, -844, -642, 923, 1660, -1091, 
    -982, 1014, 3845, -521, -302, -106, 228, 34, 256, 383, -2933, -4755, 743, -465, -227, -1330, 
    2866, -1973, 910, 2341, -341, -813, -444, 1793, 2456, 54, 2745, 1347, -3840, -3572, 766, 450, 
    -1361, 3487, 1067, -384, 2245, -1702, 817, -238, 1599, -246, -1623, -68, -1187, -121, -1491, 180, 
    -861, 1210, -809, -1776, 166, 3183, -229, 373, -745, -933, -2750, -704, -611, 3649, 2330, -721, 
    102, -2206, -1892, -582, -893, -43, 3015, 2373, 665, 1688, -3019, -1491, -355, -956, 325, 1324, 
    125, -2330, -1364, -915, 2154, -1834, 1637, 4152, -413, 572, -1286, -3815, -472, -547, -539, 3908, 
    -304, 444, 213, 760, 1577, -498, -877, 55, 938, -2438, -1241, -1441, -1471, 1970, 2922, 840, 
    350, -1905, 2382, -2784, 518, 233, 155, 1140, -1728, -1148, -974, -863, 976, -991, -1263, 1063, 
    1338, -429, -674, -2820, -2049, 750, 2890, 5420, 1499, 2429, -673, -3785, 958, -964, -1539, 354, 
    -1066, -2511, -575, 1582, 432, 106, 2321, -1383, -1366, -1627, -1619, -1057, -57, 1250, -1082, -1100, 
    -151, 1299, -2179, 554, 2154, -292, -2957, 3223, 612, -979, 1052, -748, -337, -1583, -796, -557, 
    -96, 2896, 2228, -1879, -1025, 500, -1917, 1056, -45, -269, -567, 2299, 3096, 1082, 1711, 1855, 
    -1020, 505, 870, 1611, 389, 180, -2185, -1023, 559, 655, 5111, -976, -2517, 1751, 2229, 3434, 
    410, 156, 512, 476, 2501, -944, -1774, -1392, -414, 1243, 836, 1640, 2071, 543, 2094, -768, 
    829, 1086, -1224, 831, 1305, -1084, -1824, 2113, 1432, 870, -594, -2170, 2254, 762, -2146, 2754, 
    837, 2281, 897, 883, 1221, -247, 1644, 504, -1414, 2038, 834, -989, -226, 566, 402, -1243, 
    -1916, 2087, 2663, 3102, -905, 39, 1468, 720, -581, -143, 34, 1284, 1845, 697, -1428, 762, 
    220, -1056, 1675, 2115, -254, 19, -1651, -402, -1751, -558, -274, 437, 1616, -317, -1597, 1166, 
    -72, 1800, -1378, 1604, 1818, 1350, -175, 1384, 423, -447, 202, 1334, 1031, -103, 574, -562, 
    -699, 1359, -1177, -1274, 2112, 348, 1084, -19, -871, 51, 126, -361, 1451, -19, -770, -61, 
    647, -2, -424, 916, -1101, -1936, 2168, 1065, 105, 432, -102, -1177, -1129, -1960, -12, 189, 
    -355, -1999, -3233, -1485, -774, -70, 1280, 1231, -507, -564, -552, -570, 318, 237, -629, 504, 
    -510, 1243, -2641, -1141, -1333, -244, -438, -848, 558, 652, -167, 229, 504, -966, -57, 984, 
    -73, -369, -910, -256, -1788, 619, 978, -595, -846, 546, -1291, -144, -301, -1129, -1068, 292, 
    250, 2675, -661, 1408, 694, 315, -192, -854, 369, 21, -1425, -1534, 462, -892, -511, -3147, 
    671, -1107, -441, -1331, 511, -515, 1346, 2773, -646, -695, -278, -754, -835, -801, -824, -1193, 
    -31, -2717, -180, -1130, 624, 1916, 274, -623, -43, -1269, -1528, -271, 1116, -2027, -636, -632, 
    344, -7, 918, 137, 422, -490, -865, -672, 387, 1642, -563, -228, -558, 31, 131, 686, 
    232, 1192, -408, -2219, -550, -1965, -1404, -250, 1119, -490, 323, -258, 201, 454, 1077, -1679, 
    62, 490, -746, -70, 632, 434, -1403, -1691, -642, 297, -921, -859, -152, -292, 1058, 493, 
    -801, 544, -239, -196, -596, -581, -1461, -133, -178, -679, -894, -546, 977, 794, -157, 504, 
    691, -511, 177, 135, 34, -34, -884, -239, 512, -926, -917, 365, 47, -1251, 490, -629, 
    -669, 1378, 151, -880, 1138, 142, -316, 1153, 1363, 2029, -1306, 348, 2478, -65, -964, 990, 
    -69, 1371, 107, -834, -569, -3129, 88, -2360, -297, -1448, -1519, -1472, 39, -5552, 301, 1336, 
    -484, -962, -2358, -617, 1195, -813, 1047, -992, -1204, -597, -258, -46, -1549, 1296, -261, 1115, 
    -227, -328, 223, -612, -80, 1463, 1472, 413, 409, -1745, -284, -1380, -149, -2238, -1073, 255, 
    372, 80, -374, 126, 2042, 974, -997, 713, 241, -1094, 678, -90, 663, -405, 888, 1528, 
    -501, -1688, 920, 382, 305, -4127, 406, -784, -1469, -1273, 594, 2079, 37, -2639, -1403, -953, 
    729, 5, -1156, -414, 1378, -698, 774, 610, -1625, 495, 1233, 1172, 1799, -889, -1770, -47, 
    -633, 61, -641, -260, -2135, -802, 160, -953, -227, -1127, 683, 1151, -714, 110, -779, -559, 
    1373, -467, -552, -177, 1690, -500, -2053, -1698, -357, 777, 1162, -854, 835, -573, -234, 595, 
    61, -2705, 170, -570, 681, -2381, -1501, 2547, -1597, 544, -1217, -323, -473, -1219, -865, 17, 
    -2033, -223, -1688, 403, 591, 2067, -2634, 316, 834, 1278, 435, 283, -731, -318, -36, -14, 
    469, 906, 814, -486, -934, -85, -517, -816, 124, -848, -534, -49, -1357, 1191, 605, 1123, 
    1541, 789, -951, 543, 2604, -758, -1942, -4, 2522, 1181, 464, 1236, -2070, 913, -2245, 489, 
    1034, -3977, -171, 847, 103, -2776, -1625, 828, -1439, -5076, -37, -992, -717, -759, 51, 493, 
    -1799, 1333, 1070, 1267, -914, 790, 333, 414, -1476, -534, -595, 177, -2495, 2510, -4565, 389, 
    -818, 488, 954, 809, 115, -1248, -70, 386, 134, 1118, 1077, -634, 68, 577, 1238, -1649, 
    -363, 511, -2170, -1696, 424, -1541, 1524, -822, 1091, 119, -692, -2008, 1886, 130, 759, -2191, 
    892, -478, -715, -949, -8, 1162, -92, 85, -49, 39, -1065, -401, 770, -3827, 718, 342, 
    -877, 1200, -1312, 313, 432, 104, -434, 1389, -62, -1124, 520, 1368, -234, -690, 177, 2055, 
    -108, -915, 371, -1274, -1630, -4644, 3677, 2231, 907, -1606, -501, -3617, -1297, -685, 670, 1289, 
    57, 315, -1111, -381, 21, 1998, 3956, -1216, 1252, -3520, -1867, -2043, 180, -788, 121, -181, 
    -969, -728, -686, 1940, -2158, -1114, 2303, 110, -377, 188, -2037, -1202, -97, -602, 887, 20, 
    758, 517, -847, 381, 328, -1664, -1351, -1827, 960, -3607, 1282, -1306, 253, 1612, 157, 867, 
    750, 171, 987, 329, 269, -534, 280, -978, -44, -2247, -1398, 1095, 595, -647, -1026, -245, 
    1111, -427, 40, -154, -406, -2050, -2286, 1951, 2161, -4140, -2833, -3595, 951, -363, -1063, -171, 
    1867, -526, -567, -588, -104, 767, -5073, -880, 81, 1115, -1537, -643, -573, -641, -816, -234, 
    -820, 227, 239, 1273, -517, -2421, -4526, 261, 2134, -2068, 1119, -791, -1235, -1313, -906, -682, 
    723, 287, 43, -1408, 426, 99, -151, -1068, 240, 290, -235, -1534, 1750, 656, 355, -1450, 
    -1020, 1742, 509, 1373, 619, -154, -2912, 2368, 1237, -284, -667, -2043, -1109, -2034, -3666, 2234, 
    38, -1246, -285, -66, 828, -936, -1567, 691, 745, -1460, 707, 486, 13, 703, -2159, 1040, 
    -1054, -531, -1221, -253, -364, -1462, 669, -186, -62, 407, -894, 840, 321, -2030, -1620, 905, 
    528, 1321, 1144, -1090, 185, -102, 717, -449, 334, -1105, -429, -622, 1246, -806, -82, -748, 
    -1203, 2012, 971, 808, 142, 345, -951, 101, -206, 521, -606, 621, -696, -1194, -1315, 693, 
    -926, -353, -1301, 57, 204, -50, 273, 789, 271, -277, -499, 195, 646, -683, 919, 740, 
    -358, 188, -1664, 210, 595, -709, 1438, 529, 38, -244, 38, -1062, -550, -2359, 809, 226, 
    -451, -708, -1169, -497, -1242, -1595, 685, 2004, -566, -364, 179, -165, -601, 1007, -183, -70, 
    698, 937, -550, -1532, 1950, 3622, 595, -2101, 481, -157, 967, -434, -90, -739, 326, 874, 
    132, -204, -183, -938, 435, -1758, 260, -166, -540, -146, -892, -237, -136, 129, 602, -173, 
    -15, 25, -658, -1334, 409, 365, 893, -1849, 186, 326, -622, -493, -78, -232, -124, 255, 
    -213, 29, -108, 775, -1555, 774, 577, 319, -637, -104, -679, -505, -505, -270, -897, -1387, 
    -1063, -1303, 1244, 888, -202, -2535, 622, 439, 302, -1015, -1224, -968, 1158, -2423, -589, 217, 
    -358, -1127, -110, -1403, 205, -588, 144, 333, -272, -562, -1198, -778, -58, -657, 47, -1195, 
    632, -1637, 35, 384, 690, 1604, -434, 682, 682, -229, 212, 246, 627, 60, 46, -1027, 
    -611, -206, 53, 388, -60, 363, 373, -1134, -494, -1835, 30, 1111, 42, -652, 413, -219, 
    921, -316, 575, -269, -469, 1667, 289, -298, 109, -646, 864, -613, -66, -258, 260, -1270, 
    -324, -519, 1126, 96, -457, -186, -659, -225, -387, -842, -787, -258, -416, 328, -694, 0, 
    331, 1197, -229, -815, 525, 305, -95, -28, 584, -346, -747, -95, -121, 942, -358, -239, 
};

static const int16_t fx2a_paramModel4Alpha[16] = {
    9981, 6840, 8188, 453, 8472, 543, -1628, -526, -701, 2686, 1810, 2851, 5728, 3126, 1771, 6017, 
};

static const int16_t fx2a_paramResidualBias[16] = {
    -717, 490, -246, 69, -465, 650, -121, 378, 125, 123, 99, -696, -734, -65, -525, 212, 
};

static const int16_t fx2a_paramResidualWeights[256] = {
    -2355, -1214, 403, -2497, -153, -222, -550, -490, 2801, 1149, -2164, 4009, -4950, -566, -379, -246, 
    -659, -3900, 1261, -1647, 412, 590, 768, 1432, 3228, 208, -195, -414, -3241, -2148, -862, 3097, 
    2574, 1683, -1626, 2106, 1557, 1853, -3721, 1181, -1319, -1443, -764, 1615, -1432, -1800, 5217, 325, 
    5396, 1186, -1008, 436, 186, 201, 1786, 1168, 137, 1939, 2549, 1518, -4171, -2871, -1034, -60, 
    -123, -5342, -539, 135, 2773, -173, -623, 413, 3336, 1887, -3283, 1770, -1607, 496, -347, 939, 
    -697, -2785, -258, -3520, 2430, -486, 8373, -2, 1573, 1065, 2029, -216, 448, -3397, -1823, 287, 
    1716, -2186, -4150, 11, 4904, -1697, -3387, -372, 2535, 4627, -3544, -834, 2567, -4763, 2320, -2200, 
    -3796, -295, -1912, 3588, 4078, -931, -1240, -1660, -5970, 2412, 3731, -3917, -4159, -1440, -2331, -838, 
    -303, -3206, 6118, -2595, 2001, -4148, -3163, 27, 4608, -988, 3745, 2500, -546, -1350, 1612, -137, 
    3159, -2567, 2559, 266, -919, -893, 1475, 5629, 4390, 1180, 5831, -1248, -1574, 1411, -5297, 222, 
    -191, 4778, 4323, -2305, -3372, 3301, 3600, -1435, -1746, -5960, 611, -460, -2322, 5072, -517, 5036, 
    -6397, 1383, -1579, -5776, 1287, 827, -1993, -3313, -442, -1567, -4692, 5734, -2298, -1937, 1031, -857, 
    -1675, -726, -402, 1626, -1536, -1757, 3404, -935, -2253, 1068, 1649, 284, 1802, 1049, -3252, -2127, 
    -1042, -1650, -2859, 2081, 1849, 1187, 3407, 525, 1225, 8511, 710, 5651, -719, 4324, 684, -4219, 
    -4775, 3576, 1404, -564, -2024, 3017, -627, -2997, 1487, -2074, -1328, 1330, 2244, 887, -3557, -4634, 
    1156, -549, -1554, 1055, -1846, 4713, -1184, 80, -4971, -4000, -487, -3219, -595, -2436, -872, 1216, 
};

static const int16_t fx2a_paramResidualAlpha[16] = {
    380, 889, 1685, 5558, 3733, 279, -328, 890, 8835, 8569, 6829, 571, 1172, -255, 1275, 7547, 
};

static const int16_t fx2a_paramSubConvolutionBias[4] = {
    121, 113, 130, 121, 
};

static const int16_t fx2a_paramSubConvolutionWeights[576] = {
    -269, -73, 7, 22, 314, 35, 131, 9, -23, 0, -34, -13, -50, -3, -50, -37, 
    82, 14, 121, 14, -210, 70, -42, 2, 52, 80, 93, -1, 50, 61, 145, 15, 
    119, 37, 71, -4, 89, -2, 43, -21, 84, -1, 55, -14, 222, -43, -61, -25, 
    16, 229, 111, 183, 153, -41, -39, 11, 155, 85, 19, 12, 135, -10, 97, -31, 
    206, 56, 148, 151, -483, 218, 24, 94, -233, -124, -66, -44, -407, -301, -161, -202, 
    367, 252, 211, 246, 424, -194, -156, -7, -503, -431, -75, 236, 1851, 343, 716, -35, 
    50, 156, 77, 152, -27, 100, 3, 77, 213, 357, 142, 275, -1, 182, -8, -11, 
    211, 44, 187, 162, 3, -160, -123, -11, 166, 227, 149, 162, 328, 435, 174, 335, 
    78, 201, 58, 65, -105, -134, 21, 11, -15, 11, 33, 18, -42, -222, -42, -70, 
    -43, 47, -27, -6, 12, -133, -38, -58, 4, 1, 15, -43, 285, 1145, 129, 550, 
    -94, -125, -68, -85, -76, -124, -45, -68, -77, -47, -82, -81, 2, -33, 5, 15, 
    84, 163, -27, 74, 48, 119, 50, -13, 60, 152, -5, 32, -106, -52, -62, -70, 
    447, 37, -487, -27, 200, 120, 478, 236, -66, 16, -5, -32, 191, 37, 89, 19, 
    -67, -57, -67, -20, 606, -25, -101, 71, 45, -57, -325, -42, 26, -21, 80, 94, 
    509, 246, 512, 324, 464, 274, 462, 297, 387, 213, 466, 294, -797, -61, -347, -206, 
    -102, 44, -420, -21, -1018, -21, -195, 30, -605, -22, 456, 84, 475, 286, 586, 389, 
    11, 339, -957, -1410, -1062, 797, -1531, 768, 490, -431, -411, -710, 482, 438, -116, 87, 
    12, 197, 481, 346, -96, -829, 1055, -959, 40, 164, 544, 118, 2059, 1524, 3568, 2614, 
    1128, 1292, 786, 991, 959, 1137, 542, 804, 739, 976, 618, 915, -770, -995, 15, -17, 
    -469, -1244, -298, -1405, 628, -451, 192, -966, -304, -1674, 431, 331, 802, 1172, 758, 1075, 
    161, 134, 137, 188, -146, -334, -108, -285, -237, -137, -142, 24, 69, 172, -35, -153, 
    -128, -240, -33, 27, -10, 112, -50, -14, -13, -40, -40, 70, 98, 304, 423, 925, 
    106, 155, 9, 1, 47, 93, 0, -52, 86, 73, 25, -3, -0, -44, -17, -28, 
    184, 327, 93, 334, 128, 70, 40, 134, 9, 161, 8, 136, 198, 203, 63, 78, 
    96, 80, 91, 85, 83, 25, 88, 64, 63, -14, -111, -105, 71, 1, 10, -67, 
    -123, -26, -90, -16, -58, 60, 223, -43, -23, -11, 33, 25, -98, -84, -225, -131, 
    117, 72, 163, 92, 135, 74, 195, 145, 72, 52, 143, 111, 21, 76, 319, 134, 
    -59, -68, -334, -303, 82, -188, -486, -175, -26, -74, -135, -7, 70, 46, 126, 127, 
    75, 66, 231, 122, -70, -2, -68, 248, 116, 81, 437, -156, 411, 199, 472, 106, 
    -229, -99, -223, 91, 4, 57, -265, -46, -43, -19, -122, -30, 62, -19, 107, -48, 
    453, 378, 691, 530, 261, 300, 501, 466, 245, 273, 436, 403, 95, 104, -124, 335, 
    165, -191, -92, -603, 234, 332, 460, 285, -157, -181, -308, -757, 330, 305, 531, 483, 
    -22, 1, 43, 93, 7, -7, -64, -127, 95, -38, -83, -305, 51, 118, 184, 322, 
    -53, -115, -225, -336, -3, 10, 24, 135, 0, -12, 11, -16, 24, 65, 55, 89, 
    4, 8, 70, 119, 4, -17, 18, 66, -8, -44, 8, 17, -69, 5, -24, 38, 
    136, 287, 367, 403, -16, 105, 132, 208, 79, -16, 63, -82, 0, 6, 92, 140, 
};

